/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.utils.animation.transformation;

import com.creativemd.littletiles.common.utils.animation.Animation;
import com.creativemd.littletiles.common.utils.animation.OffsetAnimation;
import com.creativemd.littletiles.common.utils.animation.transformation.Transformation;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.util.EnumFacing;

public class OffsetTransformation
extends Transformation {
    public double x;
    public double y;
    public double z;

    public OffsetTransformation(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public OffsetTransformation(EnumFacing facing, LittleGridContext context, int distance) {
        switch (facing.func_176740_k()) {
            case X: {
                this.x = (double)facing.func_176743_c().func_179524_a() * context.toVanillaGrid(distance);
                break;
            }
            case Y: {
                this.y = (double)facing.func_176743_c().func_179524_a() * context.toVanillaGrid(distance);
                break;
            }
            case Z: {
                this.z = (double)facing.func_176743_c().func_179524_a() * context.toVanillaGrid(distance);
                break;
            }
        }
    }

    @Override
    public boolean isAligned() {
        return true;
    }

    @Override
    public Transformation copy() {
        return new OffsetTransformation(this.x, this.y, this.z);
    }

    @Override
    public Animation createAnimationTo(Transformation transformation, long duration) {
        if (transformation instanceof OffsetTransformation) {
            return new OffsetAnimation(duration, (OffsetTransformation)this.copy(), ((OffsetTransformation)transformation).x, ((OffsetTransformation)transformation).y, ((OffsetTransformation)transformation).z);
        }
        return null;
    }

    @Override
    public Animation createAnimationToZero(long duration) {
        return new OffsetAnimation(duration, (OffsetTransformation)this.copy(), 0.0, 0.0, 0.0);
    }

    @Override
    public Animation createAnimationFromZero(long duration) {
        OffsetTransformation newTransformation = (OffsetTransformation)this.copy();
        newTransformation.x = 0.0;
        newTransformation.y = 0.0;
        newTransformation.z = 0.0;
        return new OffsetAnimation(duration, newTransformation, this.x, this.y, this.z);
    }
}

