/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.combine.AdvancedCombiner;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.preview.LittleVolumes;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.compression.LittleNBTCompressionTools;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LittlePreviews
implements Iterable<LittleTilePreview> {
    protected List<LittleTilePreview> previews;
    public LittleGridContext context;
    protected List<LittlePreviews> children = new ArrayList<LittlePreviews>();

    public LittlePreviews(LittleGridContext context) {
        this.context = context;
        this.previews = new ArrayList<LittleTilePreview>();
    }

    protected LittlePreviews(LittlePreviews previews) {
        this.previews = new ArrayList<LittleTilePreview>(previews.previews);
        this.context = previews.context;
    }

    public void assign(LittlePreviews previews) {
        this.context = previews.context;
        this.previews = previews.previews;
        this.children = previews.children;
    }

    public boolean isAbsolute() {
        return false;
    }

    public BlockPos getBlockPos() {
        return null;
    }

    public boolean hasStructure() {
        return false;
    }

    public void deleteCachedStructure() {
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                child.deleteCachedStructure();
            }
        }
    }

    public LittleStructure getStructure() {
        return null;
    }

    public NBTTagCompound getStructureData() {
        return null;
    }

    public String getStructureName() {
        if (!this.hasStructure()) {
            return null;
        }
        NBTTagCompound nbt = this.getStructureData();
        return nbt.func_74764_b("name") ? nbt.func_74779_i("name") : null;
    }

    public String getStructureId() {
        if (!this.hasStructure()) {
            return null;
        }
        NBTTagCompound nbt = this.getStructureData();
        return nbt.func_74779_i("id");
    }

    public LittleGridContext getMinContext() {
        LittleGridContext context = this.context;
        if (this.hasStructure()) {
            context = LittleGridContext.max(this.context, this.getStructure().getMinContext());
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                context = LittleGridContext.max(context, child.getMinContext());
            }
        }
        return context;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public List<LittlePreviews> getChildren() {
        return this.children;
    }

    public void updateChild(int index, LittlePreviews child) {
        this.children.set(index, child);
    }

    public void addChild(LittlePreviews child) {
        if (child.isAbsolute()) {
            throw new RuntimeException("Absolute previews cannot be added as a child!");
        }
        this.children.add((LittlePreviewsStructure)child);
        if (this.context.size < child.getSmallestContext()) {
            this.convertToSmallest();
        } else {
            child.convertTo(this.context);
        }
    }

    public void getPlacePreviews(List<PlacePreviewTile> placePreviews, LittleTileBox overallBox, boolean fixed, LittleTileVec offset) {
        for (LittleTilePreview preview : this) {
            placePreviews.add(preview.getPlaceableTile(overallBox, fixed, offset, this));
        }
        if (this.hasStructure()) {
            for (PlacePreviewTile placePreviewTile : this.getStructure().getSpecialTiles(this)) {
                if (!fixed) {
                    placePreviewTile.add(offset);
                }
                placePreviews.add(placePreviewTile);
            }
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                child.getPlacePreviews(placePreviews, overallBox, fixed, offset);
            }
        }
    }

    public void movePreviews(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, LittleGridContext context, LittleTileVec offset) {
        if (context.size > this.context.size) {
            this.convertTo(context);
        } else if (context.size < this.context.size) {
            offset.convertTo(context, this.context);
        }
        for (LittleTilePreview preview : this.previews) {
            preview.box.add(offset);
        }
        if (this.hasStructure()) {
            this.getStructure().onMove(world, player, stack, context, offset);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.movePreviews(world, player, stack, context, offset);
            }
        }
    }

    public void flipPreviews(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        for (LittleTilePreview preview : this.previews) {
            preview.flipPreview(axis, doubledCenter);
        }
        if (this.hasStructure()) {
            this.getStructure().onFlip(world, player, stack, this.context, axis, doubledCenter);
            this.getStructure().writeToNBT(this.getStructureData());
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.flipPreviews(world, player, stack, axis, doubledCenter);
            }
        }
    }

    public void rotatePreviews(World world, @Nullable EntityPlayer player, @Nullable ItemStack stack, Rotation rotation, LittleTileVec doubledCenter) {
        for (LittleTilePreview preview : this.previews) {
            preview.rotatePreview(rotation, doubledCenter);
        }
        if (this.hasStructure()) {
            this.getStructure().onRotate(world, player, stack, this.context, rotation, doubledCenter);
            this.getStructure().writeToNBT(this.getStructureData());
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.children) {
                child.rotatePreviews(world, player, stack, rotation, doubledCenter);
            }
        }
    }

    public void convertTo(LittleGridContext to) {
        if (this.context != to) {
            for (LittleTilePreview preview : this.previews) {
                preview.convertTo(this.context, to);
            }
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                child.convertTo(to);
            }
        }
        this.context = to;
    }

    protected int getSmallestContext() {
        int size = LittleGridContext.minSize;
        for (LittleTilePreview preview : this.previews) {
            size = Math.max(size, preview.getSmallestContext(this.context));
        }
        return size;
    }

    public void convertToSmallest() {
        int size = this.getSmallestContext();
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                size = Math.max(child.getSmallestContext(), size);
            }
        }
        if (size != this.context.size) {
            this.convertTo(LittleGridContext.get(size));
        }
    }

    public LittlePreviews copy() {
        LittlePreviews previews = new LittlePreviews(this.context);
        previews.previews.addAll(this.previews);
        previews.children.addAll(this.children);
        return previews;
    }

    protected LittleTilePreview getPreview(LittleTile tile) {
        LittleTilePreview preview = tile.getPreviewTile();
        LittleGridContext context = tile.getContext();
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        return preview;
    }

    public LittleTilePreview addPreview(BlockPos pos, LittleTilePreview preview, LittleGridContext context) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        this.previews.add(preview);
        return preview;
    }

    public LittleTilePreview addTile(LittleTile tile) {
        LittleTilePreview preview = this.getPreview(tile);
        this.previews.add(preview);
        return preview;
    }

    public LittleTilePreview addTile(LittleTile tile, LittleTileVec offset) {
        LittleTilePreview preview = this.getPreview(tile);
        preview.box.add(offset);
        return this.addPreview(null, tile.getPreviewTile(), tile.getContext());
    }

    public void addTiles(List<LittleTile> tiles) {
        if (tiles.isEmpty()) {
            return;
        }
        for (LittleTile tile : tiles) {
            this.addTile(tile);
        }
    }

    @Override
    public Iterator<LittleTilePreview> iterator() {
        return this.previews.iterator();
    }

    public static LittlePreviewsStructure getChild(LittleGridContext context, NBTTagCompound nbt) {
        LittlePreviewsStructure previews = (LittlePreviewsStructure)LittleNBTCompressionTools.readPreviews(new LittlePreviewsStructure(nbt.func_74775_l("structure"), context), nbt.func_150295_c("tiles", 10));
        if (nbt.func_74764_b("children")) {
            NBTTagList list = nbt.func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound child = list.func_150305_b(i);
                previews.addChild(LittlePreviews.getChild(context, child));
            }
        }
        return previews;
    }

    public static LittlePreviews getPreview(ItemStack stack, boolean allowLowResolution) {
        if (!stack.func_77942_o()) {
            return new LittlePreviews(LittleGridContext.get());
        }
        LittleGridContext context = LittleGridContext.get(stack.func_77978_p());
        if (stack.func_77978_p().func_74781_a("tiles") instanceof NBTTagInt) {
            LittlePreviews previews = new LittlePreviews(context);
            int tiles = stack.func_77978_p().func_74762_e("tiles");
            for (int i = 0; i < tiles; ++i) {
                NBTTagCompound nbt = stack.func_77978_p().func_74775_l("tile" + i);
                LittleTilePreview preview = LittleTilePreview.loadPreviewFromNBT(nbt);
                if (preview == null) continue;
                previews.previews.add(preview);
            }
            if (stack.func_77978_p().func_74764_b("structure")) {
                return new LittlePreviewsStructure(stack.func_77978_p().func_74775_l("structure"), previews);
            }
            return previews;
        }
        if (allowLowResolution && stack.func_77978_p().func_74764_b("pos")) {
            LittlePreviews previews = new LittlePreviews(context);
            NBTTagCompound tileData = new NBTTagCompound();
            LittleTileBlock tile = new LittleTileBlock(LittleTiles.coloredBlock);
            ((LittleTile)tile).saveTileExtra(tileData);
            tileData.func_74778_a("tID", tile.getID());
            NBTTagList list = stack.func_77978_p().func_150295_c("pos", 11);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                int[] array = list.func_150306_c(i);
                previews.previews.add(new LittleTilePreview(new LittleTileBox(array[0] * context.size, array[1] * context.size, array[2] * context.size, array[0] * context.size + context.maxPos, array[1] * context.size + context.maxPos, array[2] * context.size + context.maxPos), tileData));
            }
            return previews;
        }
        LittlePreviews previews = stack.func_77978_p().func_74764_b("structure") ? new LittlePreviewsStructure(stack.func_77978_p().func_74775_l("structure"), context) : new LittlePreviews(context);
        previews = LittleNBTCompressionTools.readPreviews(previews, stack.func_77978_p().func_150295_c("tiles", 10));
        if (stack.func_77978_p().func_74764_b("children")) {
            NBTTagList list = stack.func_77978_p().func_150295_c("children", 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound child = list.func_150305_b(i);
                previews.addChild(LittlePreviews.getChild(context, child));
            }
        }
        return previews;
    }

    public LittleTilePreview get(int index) {
        return this.previews.get(index);
    }

    protected Iterator<LittleTilePreview> allPreviewsIterator() {
        if (this.hasChildren()) {
            return new Iterator<LittleTilePreview>(){
                public int i = -1;
                public Iterator<LittleTilePreview> subIterator;
                public List<? extends LittlePreviews> children;
                {
                    this.subIterator = LittlePreviews.this.previews.iterator();
                    this.children = LittlePreviews.this.getChildren();
                }

                @Override
                public boolean hasNext() {
                    if (this.subIterator.hasNext()) {
                        return true;
                    }
                    while (this.i < this.children.size() - 1 && !this.subIterator.hasNext()) {
                        ++this.i;
                        this.subIterator = this.children.get(this.i).allPreviewsIterator();
                    }
                    return this.subIterator.hasNext();
                }

                @Override
                public LittleTilePreview next() {
                    return this.subIterator.next();
                }

                @Override
                public void remove() {
                    this.subIterator.remove();
                }
            };
        }
        return this.previews.iterator();
    }

    public Iterable<LittleTilePreview> allPreviews() {
        return new Iterable<LittleTilePreview>(){

            @Override
            public Iterator<LittleTilePreview> iterator() {
                return LittlePreviews.this.allPreviewsIterator();
            }
        };
    }

    public int size() {
        return this.previews.size();
    }

    public int totalSize() {
        if (!this.hasChildren()) {
            return this.size();
        }
        int size = this.size();
        for (LittlePreviews child : this.getChildren()) {
            size += child.totalSize();
        }
        return size;
    }

    public void ensureContext(LittleGridContext context) {
        if (this.context.size < context.size) {
            this.convertTo(context);
        }
    }

    public boolean isEmpty() {
        return this.previews.isEmpty();
    }

    public void addWithoutCheckingPreview(LittleTilePreview preview) {
        this.previews.add(preview);
    }

    public LittleVolumes getVolumes() {
        LittleVolumes volumes = new LittleVolumes(this.context);
        volumes.addPreviews(this);
        return volumes;
    }

    public boolean isVolumeEqual(LittlePreviews previews) {
        return this.getVolumes().equals(previews.getVolumes());
    }

    public void combinePreviewBlocks() {
        HashMapList chunked = new HashMapList();
        for (int i = 0; i < this.previews.size(); ++i) {
            chunked.add((Object)this.previews.get((int)i).box.getMinVec().getBlockPos(this.context), (Object)this.previews.get(i));
        }
        this.previews.clear();
        AdvancedCombiner combiner = new AdvancedCombiner(new ArrayList());
        for (ArrayList list : chunked.values()) {
            combiner.setCombinables(list);
            combiner.combine();
            this.previews.addAll(list);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                child.combinePreviewBlocks();
            }
        }
    }

    private void advancedScale(int from, int to) {
        for (LittleTilePreview preview : this.previews) {
            preview.convertTo(from, to);
        }
        if (this.hasChildren()) {
            for (LittlePreviews child : this.getChildren()) {
                child.advancedScale(from, to);
            }
        }
    }

    public LittleTileBox getSurroundingBox() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleTilePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleTileBox(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public LittleTileVec getMinVec() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleTilePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleTileVec(minX, minY, minZ);
    }

    public LittleTileSize getSize() {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (LittleTilePreview preview : this.allPreviews()) {
            minX = Math.min(minX, preview.box.minX);
            minY = Math.min(minY, preview.box.minY);
            minZ = Math.min(minZ, preview.box.minZ);
            maxX = Math.max(maxX, preview.box.maxX);
            maxY = Math.max(maxY, preview.box.maxY);
            maxZ = Math.max(maxZ, preview.box.maxZ);
        }
        return new LittleTileSize(maxX - minX, maxY - minY, maxZ - minZ);
    }

    public static void advancedScale(LittlePreviews previews, int from, int to) {
        previews.advancedScale(from, to);
    }
}

