/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.preview;

import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleAbsolutePreviews
extends LittlePreviews {
    public BlockPos pos;

    public LittleAbsolutePreviews(BlockPos pos, LittleGridContext context) {
        super(context);
        this.pos = pos;
    }

    protected LittleAbsolutePreviews(LittleAbsolutePreviews previews) {
        super(previews);
        this.pos = previews.pos;
    }

    @Override
    public boolean isAbsolute() {
        return true;
    }

    @Override
    public BlockPos getBlockPos() {
        return this.pos;
    }

    @Override
    public LittleAbsolutePreviews copy() {
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(this.pos, this.context);
        previews.previews.addAll(this.previews);
        previews.children.addAll(this.children);
        return previews;
    }

    @Override
    public LittleTilePreview addPreview(BlockPos pos, LittleTilePreview preview, LittleGridContext context) {
        if (this.context != context) {
            if (this.context.size > context.size) {
                preview.convertTo(context, this.context);
            } else {
                this.convertTo(context);
            }
        }
        preview.box.add(new LittleTileVec(context, (Vec3i)pos.func_177973_b((Vec3i)this.pos)));
        this.previews.add(preview);
        return preview;
    }

    @Override
    public LittleTilePreview addTile(LittleTile tile) {
        LittleTilePreview preview = this.getPreview(tile);
        preview.box.add(new LittleTileVec(this.context, (Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)this.pos)));
        this.previews.add(preview);
        return preview;
    }

    @Override
    public LittleTilePreview addTile(LittleTile tile, LittleTileVec offset) {
        LittleTilePreview preview = this.getPreview(tile);
        preview.box.add(new LittleTileVec(this.context, (Vec3i)tile.te.func_174877_v().func_177973_b((Vec3i)this.pos)));
        preview.box.add(offset);
        this.previews.add(preview);
        return preview;
    }
}

