/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles.combine;

import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.combine.AdvancedCombiner;
import com.creativemd.littletiles.common.tiles.combine.StructureCombiner;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import java.util.List;

public class BasicCombiner {
    protected List<LittleTileBox> boxes;
    protected int i;
    protected int j;
    protected boolean modified;

    public static void combineBoxes(List<LittleTileBox> boxes) {
        new BasicCombiner(boxes).combine();
    }

    public static void combineTiles(List<LittleTile> tiles) {
        new AdvancedCombiner<LittleTile>(tiles).combine();
    }

    public static void combineTiles(List<LittleTile> tiles, LittleStructure structure) {
        new StructureCombiner(tiles, structure).combine();
    }

    public static void combinePreviews(List<LittleTilePreview> previews) {
        new AdvancedCombiner<LittleTilePreview>(previews).combine();
    }

    public BasicCombiner(List<LittleTileBox> boxes) {
        this.boxes = boxes;
    }

    public void set(List<LittleTileBox> boxes) {
        if (this.getClass() != BasicCombiner.class) {
            throw new RuntimeException("Illegal action! Boxes cannot be set for advanced combiners!");
        }
        this.boxes = boxes;
    }

    public List<LittleTileBox> getBoxes() {
        return this.boxes;
    }

    public void combine() {
        this.modified = true;
        while (this.modified) {
            this.modified = false;
            this.i = 0;
            while (this.i < this.boxes.size()) {
                this.j = 0;
                while (this.j < this.boxes.size()) {
                    LittleTileBox box;
                    if (this.i != this.j && (box = this.boxes.get(this.i).combineBoxes(this.boxes.get(this.j), this)) != null) {
                        this.boxes.set(this.i, box);
                        this.boxes.remove(this.j);
                        this.modified = true;
                        if (this.i <= this.j) continue;
                        --this.i;
                        continue;
                    }
                    ++this.j;
                }
                ++this.i;
            }
        }
        this.boxes = null;
    }

    public boolean cutOut(LittleTileBox searching) {
        boolean intersects = false;
        for (LittleTileBox box : this.boxes) {
            if (searching.getClass() != box.getClass()) continue;
            if (box.containsBox(searching)) {
                List<LittleTileBox> cutOut = box.cutOut(searching);
                if (cutOut != null) {
                    this.boxes.addAll(cutOut);
                }
                this.removeBox(box);
                return true;
            }
            if (!LittleTileBox.intersectsWith(box, searching)) continue;
            intersects = true;
            break;
        }
        if (intersects) {
            LittleTileSize size = searching.getSize();
            boolean[][][] filled = new boolean[size.sizeX][size.sizeY][size.sizeZ];
            for (LittleTileBox box : this.boxes) {
                if (!LittleTileBox.intersectsWith(box, searching) || searching.getClass() != box.getClass()) continue;
                box.fillInSpace(searching, filled);
            }
            for (int x = 0; x < filled.length; ++x) {
                for (int y = 0; y < filled[x].length; ++y) {
                    for (int z = 0; z < filled[x][y].length; ++z) {
                        if (filled[x][y][z]) continue;
                        return false;
                    }
                }
            }
            int i = 0;
            while (i < this.boxes.size()) {
                LittleTileBox box = this.boxes.get(i);
                if (LittleTileBox.intersectsWith(box, searching) && searching.getClass() == box.getClass()) {
                    List<LittleTileBox> cutOut = box.cutOut(searching);
                    if (cutOut != null) {
                        this.boxes.addAll(cutOut);
                    }
                    this.removeBox(box);
                    continue;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public void removeBox(LittleTileBox box) {
        int index = this.boxes.indexOf(box);
        if (index != -1) {
            if (this.i > index) {
                --this.i;
            }
            if (this.j > index) {
                --this.j;
            }
            this.modified = true;
            this.removeBox(index);
        }
    }

    protected void removeBox(int index) {
        this.boxes.remove(index);
    }
}

