/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles;

import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileTE
extends LittleTileBlock {
    public boolean firstSended = false;
    private TileEntity tileEntity;
    private boolean isTileEntityLoaded = false;
    private static Field metadataField = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"blockMetadata", "field_145847_g"});

    public LittleTileTE() {
    }

    public LittleTileTE(Block block, int meta, TileEntity tileEntity) {
        super(block, meta);
        this.tileEntity = tileEntity;
        this.setMeta(meta);
    }

    public TileEntity getTileEntity() {
        if (!this.isTileEntityLoaded && this.tileEntity != null) {
            this.tileEntity.func_145834_a(this.te.func_145831_w());
            this.setTEMetadata(this.getMeta());
            this.isTileEntityLoaded = true;
        }
        return this.tileEntity;
    }

    public void setTileEntity(TileEntity tileEntity) {
        this.tileEntity = tileEntity;
    }

    protected void setTEMetadata(int meta) {
        try {
            metadataField.setInt(this.tileEntity, meta);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setMeta(int meta) {
        super.setMeta(meta);
        if (this.tileEntity != null) {
            this.setTEMetadata(meta);
        }
    }

    @Override
    public boolean supportsUpdatePacket() {
        return true;
    }

    @Override
    public NBTTagCompound getUpdateNBT() {
        this.tileEntity.func_145834_a(this.te.func_145831_w());
        return (NBTTagCompound)ReflectionHelper.getPrivateValue(SPacketUpdateTileEntity.class, (Object)this.getTileEntity().func_189518_D_(), (String[])new String[]{"nbt", "field_148860_e"});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void receivePacket(NBTTagCompound nbt, NetworkManager net) {
        this.tileEntity.onDataPacket(net, new SPacketUpdateTileEntity(this.tileEntity.func_174877_v(), this.getMeta(), nbt));
    }

    @Override
    public boolean canBeSplitted() {
        return false;
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        super.loadTileExtra(nbt);
        NBTTagCompound tileNBT = nbt.func_74775_l("tileEntity");
        if (tileNBT != null) {
            this.tileEntity = TileEntity.func_190200_a((World)this.te.func_145831_w(), (NBTTagCompound)tileNBT);
            this.setMeta(this.getMeta());
            this.tileEntity.func_145834_a(this.te.func_145831_w());
            this.tileEntity.func_174878_a(new BlockPos((Vec3i)this.te.func_174877_v()));
            this.isTileEntityLoaded = this.te.func_145831_w() != null;
        }
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        super.saveTileExtra(nbt);
        if (this.tileEntity != null) {
            NBTTagCompound tileNBT = new NBTTagCompound();
            this.tileEntity.func_189515_b(tileNBT);
            nbt.func_74782_a("tileEntity", (NBTBase)tileNBT);
        }
    }

    @Override
    public boolean shouldTick() {
        return true;
    }

    @Override
    public void updateEntity() {
        if (this.tileEntity != null) {
            if (this.tileEntity.func_145831_w() == null) {
                this.tileEntity.func_145834_a(this.te.func_145831_w());
                this.isTileEntityLoaded = true;
            }
            if (this.tileEntity instanceof ITickable) {
                ((ITickable)this.tileEntity).func_73660_a();
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderTick(double x, double y, double z, float partialTickTime) {
        if (this.tileEntity != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (this.te.func_145835_a(mc.field_71439_g.field_70165_t, mc.field_71439_g.field_70163_u, mc.field_71439_g.field_70161_v) < this.getTileEntity().func_145833_n()) {
                RenderHelper.func_74519_b();
                int i = this.te.func_145831_w().func_175626_b(this.te.func_174877_v(), 0);
                int j = i % 65536;
                int k = i / 65536;
                OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)j, (float)k);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                BlockPos blockpos = this.te.func_174877_v();
                this.renderTileEntity(x, y, z, partialTickTime);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderTileEntity(double x, double y, double z, float partialTickTime) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public double getMaxRenderDistanceSquared() {
        if (this.tileEntity != null) {
            return this.getTileEntity().func_145833_n();
        }
        return super.getMaxRenderDistanceSquared();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.tileEntity != null) {
            return this.getTileEntity().getRenderBoundingBox().func_72317_d(this.getContext().toVanillaGrid(this.box.minX), this.getContext().toVanillaGrid(this.box.minY), this.getContext().toVanillaGrid(this.box.minZ));
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void copyExtra(LittleTile tile) {
        super.copyExtra(tile);
        if (tile instanceof LittleTileTE) {
            LittleTileTE thisTile = (LittleTileTE)tile;
            thisTile.tileEntity = TileEntity.func_190200_a((World)this.te.func_145831_w(), (NBTTagCompound)this.getTileEntity().func_189515_b(new NBTTagCompound()));
            thisTile.isTileEntityLoaded = false;
        }
    }

    @Override
    protected boolean canSawResize(EnumFacing direction, EntityPlayer player) {
        return false;
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (super.canBeCombined(tile)) {
            return tile instanceof LittleTileTE && this.getTileEntity() == ((LittleTileTE)tile).getTileEntity();
        }
        return false;
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        return false;
    }
}

