/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.tiles;

import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.api.blocks.ISpecialBlockHandler;
import com.creativemd.littletiles.common.api.blocks.SpecialBlockHandler;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleTileBlock
extends LittleTile {
    private Block block;
    private int meta;
    private ISpecialBlockHandler handler;
    @SideOnly(value=Side.CLIENT)
    protected boolean translucent;
    protected IBlockState state = null;

    private void updateSpecialHandler() {
        if (!(this.block instanceof BlockAir)) {
            this.handler = SpecialBlockHandler.getSpecialBlockHandler(this.block, this.meta);
        }
        this.updateBlockState();
    }

    public boolean hasSpecialBlockHandler() {
        return this.handler != null;
    }

    protected void setBlock(String defaultName, Block block, int meta) {
        if (block == null || block instanceof BlockAir) {
            this.block = Blocks.field_150350_a;
            this.meta = meta;
            this.handler = new MissingBlockHandler(defaultName);
        } else {
            this.setBlock(block, meta);
        }
    }

    public void setBlock(Block block, int meta) {
        this.block = block;
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setMeta(int meta) {
        this.meta = meta;
        this.updateSpecialHandler();
    }

    public void setBlock(Block block) {
        this.block = block;
        this.updateSpecialHandler();
    }

    public Block getBlock() {
        return this.block;
    }

    public int getMeta() {
        return this.meta;
    }

    public IBlockState getBlockState() {
        if (this.state == null) {
            this.updateBlockState();
        }
        return this.state;
    }

    public void updateBlockState() {
        this.state = this.block.func_176203_a(this.meta);
        if (this.state == null) {
            this.state = this.block.func_176223_P();
        }
    }

    public LittleTileBlock(Block block, int meta) {
        this.setBlock(block, meta);
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.updateClient();
        }
    }

    public LittleTileBlock(Block block) {
        this(block, 0);
    }

    public LittleTileBlock() {
    }

    public void updateClient() {
        this.updateTranslucent();
    }

    @SideOnly(value=Side.CLIENT)
    public void updateTranslucent() {
        this.translucent = this.getBlockState().func_185895_e() || !this.getBlockState().func_185914_p() || this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.TRANSLUCENT) || this.block.canRenderInLayer(this.getBlockState(), BlockRenderLayer.CUTOUT);
    }

    @Override
    public void saveTileExtra(NBTTagCompound nbt) {
        super.saveTileExtra(nbt);
        nbt.func_74778_a("block", this.handler instanceof MissingBlockHandler ? ((MissingBlockHandler)this.handler).blockname : ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString());
        nbt.func_74768_a("meta", this.meta);
    }

    @Override
    public void loadTileExtra(NBTTagCompound nbt) {
        super.loadTileExtra(nbt);
        this.setBlock(nbt.func_74779_i("block"), Block.func_149684_b((String)nbt.func_74779_i("block")), nbt.func_74762_e("meta"));
        if (this.te.isClientSide()) {
            this.updateClient();
        }
    }

    @Override
    public void copyExtra(LittleTile tile) {
        super.copyExtra(tile);
        if (tile instanceof LittleTileBlock) {
            LittleTileBlock thisTile = (LittleTileBlock)tile;
            thisTile.handler = this.handler;
            thisTile.block = this.block;
            thisTile.meta = this.meta;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                thisTile.translucent = this.translucent;
            }
        }
    }

    @Override
    public boolean isIdenticalToNBT(NBTTagCompound nbt) {
        return super.isIdenticalToNBT(nbt) && ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.block)).toString().equals(nbt.func_74779_i("block")) && this.meta == nbt.func_74762_e("meta");
    }

    @Override
    public ItemStack getDrop() {
        return ItemBlockTiles.getStackFromPreview(this.getContext(), this.getPreviewTile());
    }

    @Override
    public List<LittleRenderingCube> getInternalRenderingCubes() {
        ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
        if (this.block != Blocks.field_180401_cv) {
            cubes.add(this.box.getRenderingCube(this.getContext(), this.block, this.meta));
        }
        return cubes;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean shouldBeRenderedInLayer(BlockRenderLayer layer) {
        if (FMLClientHandler.instance().hasOptifine() && this.block.canRenderInLayer(this.state, BlockRenderLayer.CUTOUT)) {
            return layer == BlockRenderLayer.CUTOUT_MIPPED;
        }
        try {
            return this.block.canRenderInLayer(this.getBlockState(), layer);
        }
        catch (Exception e) {
            try {
                return this.block.func_180664_k() == layer;
            }
            catch (Exception e2) {
                return layer == BlockRenderLayer.SOLID;
            }
        }
    }

    @Override
    public void onPlaced(EntityPlayer player, ItemStack stack, EnumFacing facing) {
        super.onPlaced(player, stack, facing);
        try {
            this.block.func_180633_a(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState(), (EntityLivingBase)player, stack);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public SoundType getSound() {
        return this.block.func_185467_w();
    }

    @Override
    public void randomDisplayTick(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.randomDisplayTick(this, stateIn, worldIn, pos, rand);
        } else {
            this.block.func_180655_c(this.getBlockState(), worldIn, pos, rand);
        }
        if (this.block == Blocks.field_180401_cv) {
            this.spawnBarrierParticles(pos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnBarrierParticles(BlockPos pos) {
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack itemstack = mc.field_71439_g.func_184614_ca();
        if (mc.field_71442_b.func_178889_l() == GameType.CREATIVE && !itemstack.func_190926_b() && itemstack.func_77973_b() == Item.func_150898_a((Block)Blocks.field_180401_cv)) {
            mc.field_71441_e.func_175688_a(EnumParticleTypes.BARRIER, (double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    @Override
    public void onTileExplodes(Explosion explosion) {
        if (this.hasSpecialBlockHandler()) {
            this.handler.onTileExplodes(this, explosion);
        }
    }

    @Override
    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (super.onBlockActivated(worldIn, pos, state, playerIn, hand, heldItem, side, hitX, hitY, hitZ, action)) {
            return true;
        }
        if (this.hasSpecialBlockHandler()) {
            return this.handler.onBlockActivated(this, worldIn, pos, this.getBlockState(), playerIn, hand, heldItem, side, hitX, hitY, hitZ);
        }
        return this.block.func_180639_a(worldIn, pos, this.getBlockState(), playerIn, hand, side, hitX, hitY, hitZ);
    }

    @Override
    public boolean canBeConvertedToVanilla() {
        if (!super.canBeConvertedToVanilla()) {
            return false;
        }
        if (this.hasSpecialBlockHandler()) {
            return this.handler.canBeConvertedToVanilla(this);
        }
        return true;
    }

    @Override
    public void place() {
        super.place();
        this.block.func_176213_c(this.te.func_145831_w(), this.te.func_174877_v(), this.getBlockState());
    }

    @Override
    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.glowing) {
            return super.getLightValue(state, world, pos);
        }
        return this.block.func_149750_m(this.getBlockState());
    }

    @Override
    public float getEnchantPowerBonus(World world, BlockPos pos) {
        return this.block.getEnchantPowerBonus(world, pos);
    }

    @Override
    public boolean canBeCombined(LittleTile tile) {
        if (super.canBeCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean doesProvideSolidFace(EnumFacing facing) {
        return super.doesProvideSolidFace(facing) && !this.translucent && this.block != Blocks.field_180401_cv;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean canBeRenderCombined(LittleTile tile) {
        if (super.canBeRenderCombined(tile) && tile instanceof LittleTileBlock) {
            return this.block == ((LittleTileBlock)tile).block && this.meta == ((LittleTileBlock)tile).meta && this.block != Blocks.field_180401_cv && ((LittleTileBlock)tile).block != Blocks.field_180401_cv || this.hasSpecialBlockHandler() && this.handler.canBeRenderCombined(this, (LittleTileBlock)tile);
        }
        return false;
    }

    @Override
    protected boolean canSawResize(EnumFacing facing, EntityPlayer player) {
        return true;
    }

    @Override
    public float getExplosionResistance() {
        return this.block.func_149638_a(null);
    }

    @Override
    public float getSlipperiness(Entity entity) {
        return this.block.getSlipperiness(this.getBlockState(), (IBlockAccess)this.te.func_145831_w(), this.te.func_174877_v(), entity);
    }

    @Override
    public boolean isMaterial(Material material) {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.isMaterial(this, material);
        }
        return material == this.block.func_149688_o(this.state);
    }

    @Override
    public boolean isLiquid() {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.isLiquid(this);
        }
        return this.getBlockState().func_185904_a().func_76224_d();
    }

    @Override
    public List<LittleTileBox> getCollisionBoxes() {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.getCollisionBoxes(this, super.getCollisionBoxes());
        }
        return super.getCollisionBoxes();
    }

    @Override
    public Vec3d modifyAcceleration(World worldIn, BlockPos pos, Entity entityIn, Vec3d motion) {
        if (this.hasSpecialBlockHandler()) {
            return this.handler.modifyAcceleration(this, entityIn, motion);
        }
        return super.modifyAcceleration(worldIn, pos, entityIn, motion);
    }

    @Override
    public LittleTilePreview getPreviewTile() {
        LittleTilePreview preview;
        if (this.hasSpecialBlockHandler() && (preview = this.handler.getPreview(this)) != null) {
            return preview;
        }
        return super.getPreviewTile();
    }

    @Override
    public boolean shouldCheckForCollision() {
        if (super.shouldCheckForCollision()) {
            return true;
        }
        if (this.hasSpecialBlockHandler()) {
            return this.handler.shouldCheckForCollision(this);
        }
        return false;
    }

    @Override
    public void onEntityCollidedWithBlock(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        super.onEntityCollidedWithBlock(worldIn, pos, state, entityIn);
        if (this.hasSpecialBlockHandler()) {
            this.handler.onEntityCollidedWithBlock(worldIn, this, pos, state, entityIn);
        }
    }

    public static class MissingBlockHandler
    implements ISpecialBlockHandler {
        public final String blockname;

        public MissingBlockHandler(String blockname) {
            this.blockname = blockname;
        }
    }
}

