/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure.type;

import com.creativemd.creativecore.common.gui.GuiControl;
import com.creativemd.creativecore.common.gui.container.GuiParent;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTabStateButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.entity.DoorController;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.registry.LittleStructureType;
import com.creativemd.littletiles.common.structure.relative.LTStructureAnnotation;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.relative.StructureRelative;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTileRelativeAxis;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviewsStructure;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.utils.animation.AnimationKey;
import com.creativemd.littletiles.common.utils.animation.AnimationState;
import com.creativemd.littletiles.common.utils.animation.AnimationTimeline;
import com.creativemd.littletiles.common.utils.animation.ValueTimeline;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleAxisDoor
extends LittleDoorBase {
    public AxisDoorRotation doorRotation;
    public EnumFacing.Axis axis;
    @LTStructureAnnotation(color=-65536)
    public StructureRelative axisCenter;
    private static List<Class<? extends AxisDoorRotation>> rotationTypes = new ArrayList<Class<? extends AxisDoorRotation>>();
    private static List<String> rotationTypeNames = new ArrayList<String>();

    public LittleAxisDoor(LittleStructureType type) {
        super(type);
    }

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.axis = EnumFacing.Axis.values()[nbt.func_74762_e("axis")];
        if (nbt.func_74764_b("ndirection")) {
            this.doorRotation = new PlayerOrientatedRotation();
            ((PlayerOrientatedRotation)this.doorRotation).normalAxis = EnumFacing.func_82600_a((int)nbt.func_74762_e("ndirection")).func_176740_k();
        } else {
            this.doorRotation = LittleAxisDoor.parseRotation(nbt);
        }
    }

    @Override
    protected void failedLoadingRelative(NBTTagCompound nbt, LittleStructureType.StructureTypeRelative relative) {
        if (relative.key.equals("axisCenter")) {
            LittleRelativeDoubledAxis doubledRelativeAxis;
            if (nbt.func_74764_b("ax")) {
                LittleTileVecContext vec = new LittleTileVecContext("a", nbt);
                if (this.getMainTile() != null) {
                    vec.sub(new LittleTileVecContext(this.getMainTile().getContext(), this.getMainTile().getMinVec()));
                }
                doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.context, vec.vec, new LittleTileVec(1, 1, 1));
            } else if (nbt.func_74764_b("av")) {
                LittleTileVecContext vec = new LittleTileVecContext("av", nbt);
                doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.context, vec.vec, new LittleTileVec(1, 1, 1));
            } else {
                doubledRelativeAxis = new LittleRelativeDoubledAxis("avec", nbt);
            }
            this.axisCenter = new StructureRelative(StructureAbsolute.convertAxisToBox(doubledRelativeAxis.getNonDoubledVec(), doubledRelativeAxis.additional), doubledRelativeAxis.context);
        } else {
            super.failedLoadingRelative(nbt, relative);
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("axis", this.axis.ordinal());
        this.doorRotation.writeToNBT(nbt);
    }

    @Override
    public StructureAbsolute getAbsoluteAxis() {
        return new StructureAbsolute(this.lastMainTileVec != null ? this.lastMainTileVec : this.getMainTile().getAbsolutePos(), this.axisCenter);
    }

    @Override
    protected PlacePreviewTile getPlacePreview(StructureRelative relative, LittleStructureType.StructureTypeRelative type, LittlePreviews previews) {
        if (relative == this.axisCenter) {
            return new PlacePreviewTileRelativeAxis(relative.getBox(), previews, relative, type, this.axis);
        }
        return super.getPlacePreview(relative, type, previews);
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        super.onFlip(world, player, stack, context, axis, doubledCenter);
        this.doorRotation.flip(this, axis);
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        super.onRotate(world, player, stack, context, rotation, doubledCenter);
        this.axis = RotationUtils.rotate((EnumFacing.Axis)this.axis, (Rotation)rotation);
        this.doorRotation.rotate(this, rotation);
    }

    @Override
    public boolean tryToPlacePreviews(World world, EntityPlayer player, UUID uuid, StructureAbsolute absolute) {
        Rotation rotation;
        LittleAbsolutePreviewsStructure previews = this.getAbsolutePreviews(this.getMainTile().te.func_174877_v());
        Rotation rotation2 = rotation = player != null ? this.doorRotation.getRotation(player, this, absolute) : this.doorRotation.getDefaultRotation(this, absolute);
        if (this.tryToPlacePreviews(world, player, previews.copy(), rotation, uuid, absolute)) {
            return true;
        }
        return this.doorRotation.tryOpposite() && this.tryToPlacePreviews(world, player, previews, rotation.getOpposite(), uuid, absolute);
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, LittleAbsolutePreviewsStructure previews, Rotation rotation, UUID uuid, StructureAbsolute absolute) {
        LittleAxisDoor newDoor = (LittleAxisDoor)previews.getStructure();
        if (newDoor.axisCenter.getContext().size > previews.context.size) {
            previews.convertTo(newDoor.axisCenter.getContext());
        } else if (newDoor.axisCenter.getContext().size < previews.context.size) {
            newDoor.axisCenter.convertTo(previews.context);
        }
        if (this.doorRotation.shouldRotatePreviews(this)) {
            previews.rotatePreviews(world, player, null, rotation, newDoor.axisCenter.getDoubledCenterVec());
        }
        return this.place(world, player, previews, this.doorRotation.createController(rotation, this), uuid, absolute);
    }

    protected static AxisDoorRotation parseRotation(NBTTagCompound nbt) {
        int index = nbt.func_74762_e("rot-type");
        if (index >= 0 && index < rotationTypes.size()) {
            Class<? extends AxisDoorRotation> rotationType = rotationTypes.get(index);
            try {
                AxisDoorRotation rotation = rotationType.getConstructor(new Class[0]).newInstance(new Object[0]);
                rotation.readFromNBT(nbt);
                return rotation;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Invalid axis door rotation found index: " + index);
    }

    protected static AxisDoorRotation createRotation(int index) {
        if (index >= 0 && index < rotationTypes.size()) {
            Class<? extends AxisDoorRotation> rotationType = rotationTypes.get(index);
            try {
                return rotationType.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        throw new RuntimeException("Invalid axis door rotation found index: " + index);
    }

    static {
        rotationTypes.add(PlayerOrientatedRotation.class);
        rotationTypeNames.add("orientated");
        rotationTypes.add(FixedRotation.class);
        rotationTypeNames.add("fixed");
    }

    public static class FixedRotation
    extends AxisDoorRotation {
        public double degree;

        @Override
        protected void writeToNBTCore(NBTTagCompound nbt) {
            nbt.func_74780_a("degree", this.degree);
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.degree = nbt.func_74769_h("degree");
        }

        @Override
        protected void rotate(LittleAxisDoor door, Rotation rotation) {
            this.degree = Rotation.getRotation((EnumFacing.Axis)door.axis, (boolean)(this.degree > 0.0 ? true : false)).clockwise ? Math.abs(this.degree) : -Math.abs(this.degree);
        }

        @Override
        protected void flip(LittleAxisDoor door, EnumFacing.Axis axis) {
            if (door.axis != axis) {
                this.degree = -this.degree;
            }
        }

        @Override
        protected boolean tryOpposite() {
            return false;
        }

        @Override
        protected Rotation getRotation(EntityPlayer player, LittleAxisDoor door, StructureAbsolute absolute) {
            return this.getDefaultRotation(door, absolute);
        }

        @Override
        protected Rotation getDefaultRotation(LittleAxisDoor door, StructureAbsolute absolute) {
            return Rotation.getRotation((EnumFacing.Axis)door.axis, (this.degree > 0.0 ? 1 : 0) != 0);
        }

        @Override
        protected DoorController createController(Rotation rotation, LittleAxisDoor door) {
            return new DoorController(new AnimationState().set(AnimationKey.getRotation(door.axis), this.degree), door.stayAnimated ? null : Boolean.valueOf(false), door.duration);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void onSelected(GuiTileViewer viewer, GuiParent parent) {
            viewer.visibleNormalAxis = false;
            if (this.degree == 0.0) {
                this.degree = 90.0;
            }
            parent.addControl((GuiControl)new GuiTextfield("degree", "" + this.degree, 0, 0, 30, 12).setFloatOnly());
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void parseGui(GuiTileViewer viewer, GuiParent parent) {
            float degree;
            try {
                degree = Float.parseFloat(((GuiTextfield)parent.get((String)"degree")).text);
            }
            catch (NumberFormatException e) {
                degree = 0.0f;
            }
            this.degree = degree;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldUpdateTimeline(GuiControl control) {
            return control.is(new String[]{"degree"});
        }

        @Override
        protected boolean shouldRotatePreviews(LittleAxisDoor door) {
            return false;
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int duration, AnimationKey key) {
            timeline.duration = duration * 2;
            timeline.values.add((Object)key, (Object)new ValueTimeline.LinearTimeline().addPoint(0, 0.0).addPoint(duration, this.degree).addPoint(duration * 2, 0.0));
        }
    }

    public static class PlayerOrientatedRotation
    extends AxisDoorRotation {
        public EnumFacing.Axis normalAxis;

        @Override
        protected void writeToNBTCore(NBTTagCompound nbt) {
            nbt.func_74768_a("normal", this.normalAxis.ordinal());
        }

        @Override
        protected void readFromNBT(NBTTagCompound nbt) {
            this.normalAxis = EnumFacing.Axis.values()[nbt.func_74762_e("normal")];
        }

        @Override
        protected void rotate(LittleAxisDoor door, Rotation rotation) {
            this.normalAxis = RotationUtils.rotate((EnumFacing.Axis)this.normalAxis, (Rotation)rotation);
        }

        @Override
        protected void flip(LittleAxisDoor door, EnumFacing.Axis axis) {
        }

        @Override
        protected boolean tryOpposite() {
            return true;
        }

        @Override
        protected Rotation getRotation(EntityPlayer player, LittleAxisDoor door, StructureAbsolute absolute) {
            boolean clockwise;
            Vector3d axisVec = absolute.getCenter();
            Vec3d playerVec = player.func_174791_d();
            double playerRotation = MathHelper.func_76142_g((float)player.field_70177_z);
            EnumFacing.Axis third = RotationUtils.getDifferentAxis((EnumFacing.Axis)door.axis, (EnumFacing.Axis)this.normalAxis);
            boolean toTheSide = RotationUtils.get((EnumFacing.Axis)third, (Vec3d)playerVec) <= RotationUtils.get((EnumFacing.Axis)third, (Tuple3d)axisVec);
            switch (third) {
                case X: {
                    clockwise = !(playerRotation <= -90.0) && !(playerRotation >= 90.0);
                    break;
                }
                case Y: {
                    clockwise = player.field_70125_A <= 0.0f;
                    break;
                }
                case Z: {
                    clockwise = playerRotation > 0.0 && playerRotation <= 180.0;
                    break;
                }
                default: {
                    clockwise = false;
                }
            }
            return Rotation.getRotation((EnumFacing.Axis)door.axis, (toTheSide == clockwise ? 1 : 0) != 0);
        }

        @Override
        protected Rotation getDefaultRotation(LittleAxisDoor door, StructureAbsolute absolute) {
            return Rotation.getRotation((EnumFacing.Axis)door.axis, (boolean)true);
        }

        @Override
        protected DoorController createController(Rotation rotation, LittleAxisDoor door) {
            if (door.stayAnimated) {
                return new DoorController(new AnimationState(), new AnimationState().set(AnimationKey.getRotation(rotation.axis), rotation.clockwise ? 90.0 : -90.0), null, door.duration);
            }
            return new DoorController(new AnimationState().set(AnimationKey.getRotation(rotation.axis), rotation.clockwise ? -90.0 : 90.0), new AnimationState(), true, door.duration);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void onSelected(final GuiTileViewer viewer, GuiParent parent) {
            parent.addControl((GuiControl)new GuiButton("swap normal", 0, 0){

                public void onClicked(int x, int y, int button) {
                    viewer.changeNormalAxis();
                }
            });
            if (this.normalAxis != null) {
                viewer.setNormalAxis(this.normalAxis);
            }
            viewer.visibleNormalAxis = true;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        protected void parseGui(GuiTileViewer viewer, GuiParent parent) {
            this.normalAxis = viewer.getNormalAxis();
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public boolean shouldUpdateTimeline(GuiControl control) {
            return false;
        }

        @Override
        protected boolean shouldRotatePreviews(LittleAxisDoor door) {
            return !door.stayAnimated;
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline, int duration, AnimationKey key) {
            timeline.values.add((Object)key, (Object)new ValueTimeline.LinearTimeline().addPoint(0, 0.0).addPoint(duration, 90.0));
        }
    }

    public static abstract class AxisDoorRotation {
        protected abstract void writeToNBTCore(NBTTagCompound var1);

        public void writeToNBT(NBTTagCompound nbt) {
            nbt.func_74768_a("rot-type", rotationTypes.indexOf(this.getClass()));
            this.writeToNBTCore(nbt);
        }

        protected abstract void readFromNBT(NBTTagCompound var1);

        protected abstract void rotate(LittleAxisDoor var1, Rotation var2);

        protected abstract void flip(LittleAxisDoor var1, EnumFacing.Axis var2);

        protected abstract boolean tryOpposite();

        protected abstract Rotation getRotation(EntityPlayer var1, LittleAxisDoor var2, StructureAbsolute var3);

        protected abstract Rotation getDefaultRotation(LittleAxisDoor var1, StructureAbsolute var2);

        protected abstract boolean shouldRotatePreviews(LittleAxisDoor var1);

        protected abstract DoorController createController(Rotation var1, LittleAxisDoor var2);

        @SideOnly(value=Side.CLIENT)
        public abstract boolean shouldUpdateTimeline(GuiControl var1);

        @SideOnly(value=Side.CLIENT)
        protected abstract void onSelected(GuiTileViewer var1, GuiParent var2);

        @SideOnly(value=Side.CLIENT)
        protected abstract void parseGui(GuiTileViewer var1, GuiParent var2);

        public abstract void populateTimeline(AnimationTimeline var1, int var2, AnimationKey var3);
    }

    public static class LittleAxisDoorParser
    extends LittleDoorBase.LittleDoorBaseParser {
        public LittleAxisDoorParser(GuiParent parent, AnimationGuiHandler handler) {
            super(parent, handler);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleAxisDoor parseStructure(int duration, boolean stayAnimated) {
            LittleAxisDoor door = this.createStructure(LittleAxisDoor.class);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            door.axisCenter = new StructureRelative(viewer.getBox(), viewer.getAxisContext());
            door.axis = viewer.getAxis();
            GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
            door.doorRotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            door.doorRotation.parseGui(viewer, (GuiParent)typePanel);
            door.duration = duration;
            door.stayAnimated = stayAnimated;
            return door;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(LittlePreviews previews, LittleStructure structure) {
            AxisDoorRotation doorRotation;
            LittleGridContext stackContext;
            LittleAxisDoor door = null;
            if (structure instanceof LittleAxisDoor) {
                door = (LittleAxisDoor)structure;
            }
            LittleGridContext axisContext = stackContext = previews.context;
            final GuiTileViewer viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, stackContext);
            this.parent.addControl((GuiControl)viewer);
            boolean even = false;
            if (door != null) {
                even = door.axisCenter.isEven();
                viewer.setEven(even);
                axisContext = door.axisCenter.getContext();
                viewer.setViewAxis(door.axis);
                door.axisCenter.convertToSmallest();
                viewer.setAxis(door.axisCenter.getBox(), axisContext);
                doorRotation = door.doorRotation;
            } else {
                viewer.setEven(false);
                viewer.setAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), viewer.context);
                doorRotation = new PlayerOrientatedRotation();
            }
            viewer.visibleAxis = true;
            this.parent.addControl((GuiControl)new GuiTabStateButton("doorRotation", rotationTypes.indexOf(doorRotation.getClass()), 110, 0, 12, rotationTypeNames.toArray(new String[0])));
            GuiPanel typePanel = new GuiPanel("typePanel", 110, 20, 80, 40);
            this.parent.addControl((GuiControl)typePanel);
            this.parent.addControl(new GuiIconButton("reset view", 20, 107, 8){

                public void onClicked(int x, int y, int button) {
                    viewer.offsetX.set(0.0);
                    viewer.offsetY.set(0.0);
                    viewer.scale.set(40.0);
                }
            }.setCustomTooltip(new String[]{"reset view"}));
            this.parent.addControl(new GuiIconButton("change view", 40, 107, 7){

                public void onClicked(int x, int y, int button) {
                    switch (viewer.getAxis()) {
                        case X: {
                            viewer.setViewAxis(EnumFacing.Axis.Y);
                            break;
                        }
                        case Y: {
                            viewer.setViewAxis(EnumFacing.Axis.Z);
                            break;
                        }
                        case Z: {
                            viewer.setViewAxis(EnumFacing.Axis.X);
                            break;
                        }
                    }
                    this.updateTimeline();
                }
            }.setCustomTooltip(new String[]{"change view"}));
            this.parent.addControl(new GuiIconButton("flip view", 60, 107, 4){

                public void onClicked(int x, int y, int button) {
                    viewer.setViewDirection(viewer.getViewDirection().func_176734_d());
                }
            }.setCustomTooltip(new String[]{"flip view"}));
            this.parent.addControl((GuiControl)new GuiIconButton("up", 124, 83, 1){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("right", 141, 100, 0){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(GuiScreen.func_146271_m() ? viewer.context.size : 1);
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("left", 107, 100, 2){

                public void onClicked(int x, int y, int button) {
                    viewer.moveX(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.addControl((GuiControl)new GuiIconButton("down", 124, 100, 3){

                public void onClicked(int x, int y, int button) {
                    viewer.moveY(-(GuiScreen.func_146271_m() ? viewer.context.size : 1));
                }
            });
            this.parent.controls.add(new GuiCheckBox("even", 147, 80, even));
            GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(axisContext + ""), 170, 100, 20, 12, LittleGridContext.getNames().toArray(new String[0]));
            this.parent.controls.add(contextBox);
            doorRotation.onSelected(viewer, (GuiParent)typePanel);
            super.createControls(previews, structure);
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onAxisChanged(GuiTileViewer.GuiTileViewerAxisChangedEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source;
            this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), viewer.getBox().copy(), viewer.getAxisContext()));
        }

        @Override
        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onChanged(GuiControlChangedEvent event) {
            super.onChanged(event);
            AxisDoorRotation rotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            if (rotation.shouldUpdateTimeline((GuiControl)event.source)) {
                this.updateTimeline();
            } else if (event.source.is(new String[]{"doorRotation"})) {
                GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
                typePanel.controls.clear();
                rotation.onSelected((GuiTileViewer)this.parent.get("tileviewer"), (GuiParent)typePanel);
                this.updateTimeline();
            } else if (event.source.is(new String[]{"grid"})) {
                LittleGridContext context;
                GuiStateButton contextBox = (GuiStateButton)event.source;
                try {
                    context = LittleGridContext.get(Integer.parseInt(contextBox.caption));
                }
                catch (NumberFormatException e) {
                    context = LittleGridContext.get();
                }
                GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
                LittleTileBox box = viewer.getBox();
                box.convertTo(viewer.getAxisContext(), context);
                box.maxX = viewer.isEven() ? box.minX + 2 : box.minX + 1;
                box.maxY = viewer.isEven() ? box.minY + 2 : box.minY + 1;
                box.maxZ = viewer.isEven() ? box.minZ + 2 : box.minZ + 1;
                viewer.setAxis(box, context);
            }
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            if (event.source.is(new String[]{"even"})) {
                viewer.setEven(((GuiCheckBox)event.source).value);
            }
        }

        @Override
        public void populateTimeline(AnimationTimeline timeline) {
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            GuiPanel typePanel = (GuiPanel)this.parent.get("typePanel");
            AxisDoorRotation doorRotation = LittleAxisDoor.createRotation(((GuiTabStateButton)this.parent.get("doorRotation")).getState());
            doorRotation.parseGui(viewer, (GuiParent)typePanel);
            doorRotation.populateTimeline(timeline, timeline.duration, AnimationKey.getRotation(viewer.getAxis()));
        }

        @Override
        public void onLoaded(AnimationPreview animationPreview) {
            super.onLoaded(animationPreview);
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            this.onAxisChanged(new GuiTileViewer.GuiTileViewerAxisChangedEvent((GuiControl)viewer));
        }
    }

    @Deprecated
    public static class LittleRelativeDoubledAxis
    extends LittleTileVecContext {
        public LittleTileVec additional;

        public LittleRelativeDoubledAxis(LittleGridContext context, LittleTileVec vec, LittleTileVec additional) {
            super(context, vec);
            this.additional = additional;
        }

        public LittleRelativeDoubledAxis(String name, NBTTagCompound nbt) {
            super(name, nbt);
        }

        @Override
        protected void loadFromNBT(String name, NBTTagCompound nbt) {
            int[] array = nbt.func_74759_k(name);
            if (array.length == 3) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get();
                this.additional = new LittleTileVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 4) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleTileVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 7) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleTileVec(array[4], array[5], array[6]);
            } else {
                throw new InvalidParameterException("No valid coords given " + nbt);
            }
        }

        public LittleTileVecContext getNonDoubledVec() {
            return new LittleTileVecContext(this.context, this.vec.copy());
        }

        public LittleTileVec getRotationVec() {
            LittleTileVec vec = this.vec.copy();
            vec.scale(2);
            vec.add(this.additional);
            return vec;
        }

        @Override
        public LittleRelativeDoubledAxis copy() {
            return new LittleRelativeDoubledAxis(this.context, this.vec.copy(), this.additional.copy());
        }

        @Override
        public void convertTo(LittleGridContext to) {
            LittleTileVec newVec = this.getRotationVec();
            newVec.convertTo(this.context, to);
            super.convertTo(to);
            this.additional = new LittleTileVec(newVec.x % 2, newVec.y % 2, newVec.z % 2);
            this.vec = newVec;
            this.vec.x /= 2;
            this.vec.y /= 2;
            this.vec.z /= 2;
        }

        @Override
        public void convertToSmallest() {
            if (this.isEven()) {
                super.convertToSmallest();
            }
        }

        public int getSmallestContext() {
            if (this.isEven()) {
                return this.vec.getSmallestContext(this.context);
            }
            return this.context.size;
        }

        @Override
        public boolean equals(Object paramObject) {
            if (paramObject instanceof LittleRelativeDoubledAxis) {
                return super.equals(paramObject) && this.additional.equals(((LittleRelativeDoubledAxis)paramObject).additional);
            }
            return false;
        }

        public boolean isEven() {
            return this.additional.x % 2 == 0;
        }

        @Override
        public void writeToNBT(String name, NBTTagCompound nbt) {
            nbt.func_74783_a(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.context.size, this.additional.x, this.additional.y, this.additional.z});
        }

        @Override
        public String toString() {
            return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.context.size + ",additional:" + this.additional + "]";
        }
    }
}

