/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.gui.GuiControl;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiIDButton;
import com.creativemd.creativecore.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.gui.controls.GuiDirectionIndicator;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.packet.LittleSlidingDoorPacket;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.transformation.SlidingDoorTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleSlidingDoor
extends LittleDoorBase {
    public EnumFacing moveDirection;
    public int moveDistance;
    public LittleGridContext moveContext;
    public LittleTilePos placedAxis;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        this.moveDistance = nbt.func_74762_e("distance");
        this.moveDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("direction"));
        this.moveContext = LittleGridContext.get(nbt);
        if (nbt.func_74764_b("placedAxis")) {
            this.placedAxis = new LittleTilePos("placedAxis", nbt);
        }
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        nbt.func_74768_a("distance", this.moveDistance);
        nbt.func_74768_a("direction", this.moveDirection.func_176745_a());
        this.moveContext.set(nbt);
        if (this.placedAxis != null) {
            this.placedAxis.writeToNBT("placedAxis", nbt);
        }
    }

    @Override
    public boolean activate(World world, EntityPlayer player, Rotation rotation, BlockPos pos) {
        if (!this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]), true);
                return true;
            }
            UUID uuid = UUID.randomUUID();
            if (world.field_72995_K) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleSlidingDoorPacket(pos, player, uuid));
            }
            return this.interactWithDoor(world, pos, player, uuid);
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (world.field_72995_K && !this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]), true);
                return true;
            }
            UUID uuid = UUID.randomUUID();
            PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleSlidingDoorPacket(pos, player, uuid));
            this.interactWithDoor(world, pos, player, uuid);
            action.preventPacket = true;
        }
        return true;
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, BlockPos pos, UUID uuid) {
        LittleTileVec offset = new LittleTileVec(this.moveDirection);
        offset.scale(this.moveDistance);
        this.placedAxis = new LittleTilePos(pos, this.moveContext);
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(pos, this.moveContext);
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            previews.addTile(tile);
        }
        PlacePreviews defaultpreviews = new PlacePreviews(previews.context);
        if (this.moveContext != previews.context) {
            offset.convertTo(this.moveContext, previews.context);
        }
        for (LittleTilePreview preview : previews) {
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, offset));
        }
        LittleSlidingDoor structure = new LittleSlidingDoor();
        structure.placedAxis = new LittleTilePos(pos, new LittleTileVecContext(this.moveContext, LittleTileVec.ZERO));
        structure.duration = this.duration;
        structure.moveDirection = this.moveDirection.func_176734_d();
        structure.moveDistance = this.moveDistance;
        structure.moveContext = this.moveContext;
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        LittleTileVec moveVec = new LittleTileVec(this.moveDirection);
        moveVec.scale(this.moveDistance);
        LittleTilePos absolute = this.getAbsoluteAxisVec();
        absolute.add(new LittleTileVecContext(this.moveContext, moveVec));
        absolute.removeInternalBlockOffset();
        return this.place(world, structure, player, defaultpreviews, pos, new SlidingDoorTransformation(this.moveDirection, this.moveContext, this.moveDistance), uuid, absolute, this.getAdditionalAxisVec());
    }

    public boolean interactWithDoor(World world, BlockPos pos, EntityPlayer player, UUID uuid) {
        HashMapList tempTiles = new HashMapList(this.tiles);
        HashMap<TileEntityLittleTiles, LittleGridContext> tempContext = new HashMap<TileEntityLittleTiles, LittleGridContext>();
        for (TileEntityLittleTiles te : tempTiles.keySet()) {
            tempContext.put(te, te.getContext());
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = true;
            ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = false;
        }
        if (this.tryToPlacePreviews(world, player, pos, uuid)) {
            for (Map.Entry entry : tempTiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).updateTiles();
            }
            return true;
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).convertTo((LittleGridContext)tempContext.get(entry.getKey()));
            ((TileEntityLittleTiles)entry.getKey()).addTiles((Collection)entry.getValue());
        }
        return false;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        if (axis == this.moveDirection.func_176740_k()) {
            this.moveDirection = this.moveDirection.func_176734_d();
        }
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        this.moveDirection = RotationUtils.rotateFacing((EnumFacing)this.moveDirection, (Rotation)rotation);
    }

    @Override
    public LittleTilePos getAbsoluteAxisVec() {
        return this.placedAxis;
    }

    @Override
    public LittleTileVec getAdditionalAxisVec() {
        return LittleTileVec.ZERO;
    }

    @Override
    public LittleGridContext getMinContext() {
        return this.moveContext;
    }

    @Override
    public LittleDoorBase copyToPlaceDoor() {
        LittleSlidingDoor structure = new LittleSlidingDoor();
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        structure.moveDirection = this.moveDirection;
        structure.moveDistance = this.moveDistance;
        structure.moveContext = this.moveContext;
        structure.duration = this.duration;
        return structure;
    }

    public static class LittleSlidingDoorParser
    extends LittleDoorBase.LittleDoorBaseParser<LittleSlidingDoor> {
        public LittleSlidingDoorParser(String id, GuiParent parent) {
            super(id, parent);
        }

        @SideOnly(value=Side.CLIENT)
        @CustomEventSubscribe
        public void buttonClicked(GuiControlClickEvent event) {
            if (event.source.is(new String[]{"direction"})) {
                EnumFacing enumFacing = EnumFacing.func_82600_a((int)((GuiStateButton)event.source).getState());
            }
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            if (event.source.is(new String[]{"change view"})) {
                switch (viewer.axisDirection) {
                    case X: {
                        viewer.axisDirection = EnumFacing.Axis.Y;
                        break;
                    }
                    case Y: {
                        viewer.axisDirection = EnumFacing.Axis.Z;
                        break;
                    }
                    case Z: {
                        viewer.axisDirection = EnumFacing.Axis.X;
                        break;
                    }
                }
                viewer.updateViewDirection();
                viewer.updateNormalAxis();
            } else if (event.source.is(new String[]{"reset view"})) {
                viewer.offsetX = (SmoothValue)0.0f;
                viewer.offsetY = (SmoothValue)0.0f;
                viewer.scale = (SmoothValue)5.0f;
            } else if (event.source.is(new String[]{"flip view"})) {
                viewer.viewDirection = viewer.viewDirection.func_176734_d();
                viewer.baked = null;
            }
            GuiDirectionIndicator relativeDirection = (GuiDirectionIndicator)this.parent.get("relativeDirection");
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            LittleSlidingDoorParser.updateDirection(viewer, direction, relativeDirection);
        }

        public static void updateDirection(GuiTileViewer viewer, EnumFacing direction, GuiDirectionIndicator relativeDirection) {
            EnumFacing newDirection = EnumFacing.EAST;
            if (viewer.getXFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getXFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.EAST : EnumFacing.WEST;
            } else if (viewer.getYFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getYFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.DOWN : EnumFacing.UP;
            } else if (viewer.getZFacing().func_176740_k() == direction.func_176740_k()) {
                newDirection = viewer.getZFacing().func_176743_c() == direction.func_176743_c() ? EnumFacing.SOUTH : EnumFacing.NORTH;
            }
            relativeDirection.setDirection(newDirection);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            super.createControls(stack, structure);
            LittleSlidingDoor door = null;
            if (structure instanceof LittleSlidingDoor) {
                door = (LittleSlidingDoor)structure;
            }
            LittleTileSize size = LittleTilePreview.getSize(stack);
            int index = EnumFacing.UP.ordinal();
            if (door != null) {
                index = door.moveDirection.ordinal();
            }
            this.parent.addControl((GuiControl)new GuiStateButton("direction", index, 110, 30, 37, RotationUtils.getFacingNames()));
            GuiDirectionIndicator relativeDirection = new GuiDirectionIndicator("relativeDirection", 155, 30, EnumFacing.UP);
            this.parent.addControl((GuiControl)relativeDirection);
            int distance = size.getSizeOfAxis(EnumFacing.func_82600_a((int)index).func_176740_k());
            if (door != null) {
                distance = door.moveDistance;
            }
            this.parent.addControl((GuiControl)new GuiTextfield("distance", "" + distance, 110, 51, 60, 14).setNumbersOnly());
            this.parent.addControl((GuiControl)new GuiIDButton("reset view", 110, 75, 0));
            this.parent.addControl((GuiControl)new GuiIDButton("change view", 110, 95, 1));
            this.parent.addControl((GuiControl)new GuiIDButton("flip view", 110, 115, 1));
            GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, stack);
            tile.visibleAxis = false;
            tile.updateViewDirection();
            this.parent.addControl((GuiControl)tile);
            LittleSlidingDoorParser.updateDirection(tile, EnumFacing.func_82600_a((int)index), relativeDirection);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleSlidingDoor parseStructure(int duration) {
            EnumFacing direction = EnumFacing.func_82600_a((int)((GuiStateButton)this.parent.get("direction")).getState());
            GuiTextfield distance = (GuiTextfield)this.parent.get("distance");
            LittleSlidingDoor door = new LittleSlidingDoor();
            door.duration = duration;
            door.moveDirection = direction;
            door.moveDistance = Integer.parseInt(distance.text);
            door.moveContext = ((GuiTileViewer)this.parent.get((String)"tileviewer")).context;
            return door;
        }
    }
}

