/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.structure;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.creativecore.common.packet.PacketHandler;
import com.creativemd.creativecore.common.utils.math.Rotation;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.SmoothValue;
import com.creativemd.creativecore.common.utils.mc.ColorUtils;
import com.creativemd.creativecore.common.utils.type.HashMapList;
import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.gui.controls.gui.GuiIDButton;
import com.creativemd.creativecore.gui.event.gui.GuiControlClickEvent;
import com.creativemd.littletiles.client.tiles.LittleRenderingCube;
import com.creativemd.littletiles.common.action.block.LittleActionActivated;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.packet.LittleDoorInteractPacket;
import com.creativemd.littletiles.common.structure.LittleDoorBase;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.tileentity.TileEntityLittleTiles;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviewTile;
import com.creativemd.littletiles.common.tiles.place.PlacePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleAbsolutePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.tiles.vec.LittleTilePos;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVecContext;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.creativemd.littletiles.common.utils.placing.PlacementMode;
import com.creativemd.littletiles.common.utils.transformation.OrdinaryDoorTransformation;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoor
extends LittleDoorBase {
    public EnumFacing normalDirection;
    public EnumFacing.Axis axis;
    public LittleRelativeDoubledAxis doubledRelativeAxis;
    public LittleTilePos lastMainTileVec = null;

    @Override
    protected void loadFromNBTExtra(NBTTagCompound nbt) {
        super.loadFromNBTExtra(nbt);
        if (nbt.func_74764_b("ax")) {
            LittleTileVecContext vec = new LittleTileVecContext("a", nbt);
            if (this.getMainTile() != null) {
                vec.sub(new LittleTileVecContext(this.getMainTile().getContext(), this.getMainTile().getMinVec()));
            }
            this.doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.context, vec.vec, new LittleTileVec(1, 1, 1));
        } else if (nbt.func_74764_b("av")) {
            LittleTileVecContext vec = new LittleTileVecContext("av", nbt);
            this.doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.context, vec.vec, new LittleTileVec(1, 1, 1));
        } else {
            this.doubledRelativeAxis = new LittleRelativeDoubledAxis("avec", nbt);
        }
        this.axis = EnumFacing.Axis.values()[nbt.func_74762_e("axis")];
        this.normalDirection = EnumFacing.func_82600_a((int)nbt.func_74762_e("ndirection"));
    }

    @Override
    protected void writeToNBTExtra(NBTTagCompound nbt) {
        super.writeToNBTExtra(nbt);
        this.doubledRelativeAxis.writeToNBT("avec", nbt);
        nbt.func_74768_a("axis", this.axis.ordinal());
        nbt.func_74768_a("ndirection", this.normalDirection.func_176745_a());
    }

    @Override
    public LittleTilePos getAbsoluteAxisVec() {
        LittleTilePos pos = this.getMainTile().getAbsolutePos();
        pos.add(this.doubledRelativeAxis.getNonDoubledVec());
        return pos;
    }

    @Override
    public LittleTileVec getAdditionalAxisVec() {
        return this.doubledRelativeAxis.additional.copy();
    }

    public void moveStructure(EnumFacing facing) {
        this.doubledRelativeAxis.vec.add(facing);
    }

    @Override
    public void setMainTile(LittleTile tile) {
        LittleTilePos absolute = tile.getAbsolutePos();
        if (!(this.getMainTile() == null || this.lastMainTileVec != null && this.lastMainTileVec.equals(absolute))) {
            this.doubledRelativeAxis.add(this.lastMainTileVec.getRelative(absolute));
        }
        this.lastMainTileVec = absolute;
        super.setMainTile(tile);
    }

    @Override
    public LittleGridContext getMinContext() {
        this.doubledRelativeAxis.convertToSmallest();
        return this.doubledRelativeAxis.context;
    }

    public ArrayList<PlacePreviewTile> getSpecialTiles(LittleGridContext context) {
        if (context.size < this.doubledRelativeAxis.context.size) {
            throw new RuntimeException("Invalid context as it is smaller than the context of the axis");
        }
        ArrayList<PlacePreviewTile> boxes = new ArrayList<PlacePreviewTile>();
        this.doubledRelativeAxis.convertTo(context);
        boxes.add(new PlacePreviewTileAxis(new LittleTileBox(this.doubledRelativeAxis.vec.x, this.doubledRelativeAxis.vec.y, this.doubledRelativeAxis.vec.z, this.doubledRelativeAxis.vec.x + 1, this.doubledRelativeAxis.vec.y + 1, this.doubledRelativeAxis.vec.z + 1), null, this.axis, this.getAdditionalAxisVec()));
        this.doubledRelativeAxis.convertToSmallest();
        return boxes;
    }

    @Override
    public void onFlip(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, EnumFacing.Axis axis, LittleTileVec doubledCenter) {
        doubledCenter = doubledCenter.copy();
        if (context.size > this.doubledRelativeAxis.context.size) {
            this.doubledRelativeAxis.convertTo(context);
        } else {
            doubledCenter.convertTo(context, this.doubledRelativeAxis.context);
            context = this.doubledRelativeAxis.context;
        }
        LittleTileVec doubleddoubled = this.doubledRelativeAxis.vec.copy();
        doubleddoubled.scale(2);
        doubleddoubled.add(this.doubledRelativeAxis.additional);
        doubleddoubled.sub(doubledCenter);
        doubleddoubled.flip(axis);
        doubleddoubled.add(doubledCenter);
        this.doubledRelativeAxis = new LittleRelativeDoubledAxis(this.doubledRelativeAxis.context, new LittleTileVec(doubleddoubled.x / 2, doubleddoubled.y / 2, doubleddoubled.z / 2), new LittleTileVec(doubleddoubled.x % 2, doubleddoubled.y % 2, doubleddoubled.z % 2));
    }

    @Override
    public void onRotate(World world, EntityPlayer player, ItemStack stack, LittleGridContext context, Rotation rotation, LittleTileVec doubledCenter) {
        doubledCenter = doubledCenter.copy();
        if (context.size > this.doubledRelativeAxis.context.size) {
            this.doubledRelativeAxis.convertTo(context);
        } else {
            doubledCenter.convertTo(context, this.doubledRelativeAxis.context);
            context = this.doubledRelativeAxis.context;
        }
        LittleTileVec doubleddoubled = this.doubledRelativeAxis.vec.copy();
        doubleddoubled.scale(2);
        doubleddoubled.add(this.doubledRelativeAxis.additional);
        doubleddoubled.sub(doubledCenter);
        doubleddoubled.rotateVec(rotation);
        doubleddoubled.add(doubledCenter);
        this.doubledRelativeAxis = new LittleRelativeDoubledAxis(this.doubledRelativeAxis.context, new LittleTileVec(doubleddoubled.x / 2, doubleddoubled.y / 2, doubleddoubled.z / 2), new LittleTileVec(doubleddoubled.x % 2, doubleddoubled.y % 2, doubleddoubled.z % 2));
        this.axis = RotationUtils.rotateFacing((EnumFacing)RotationUtils.getFacing((EnumFacing.Axis)this.axis), (Rotation)rotation).func_176740_k();
        this.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (Rotation)rotation);
    }

    public boolean tryToPlacePreviews(World world, EntityPlayer player, BlockPos pos, Rotation direction, boolean inverse, UUID uuid, LittleAbsolutePreviews originalPreviews, LittleTilePos absoluteAxis, LittleTileVec additional) {
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(originalPreviews.pos, originalPreviews.context);
        for (Iterator<PlacePreviewTile> preview : originalPreviews) {
            previews.addWithoutCheckingPreview(((LittleTilePreview)((Object)preview)).copy());
        }
        PlacePreviews defaultpreviews = new PlacePreviews(previews.context);
        absoluteAxis.convertTo(previews.context);
        for (LittleTilePreview preview : previews) {
            preview.box.subOffset(absoluteAxis.contextVec.vec);
            preview.rotatePreview(direction, additional);
            defaultpreviews.add(preview.getPlaceableTile(preview.box, false, absoluteAxis.contextVec.vec));
        }
        for (PlacePreviewTile placePreview : this.getAdditionalPreviews(defaultpreviews)) {
            placePreview.box.addOffset(absoluteAxis.contextVec.vec);
            defaultpreviews.add(placePreview);
        }
        LittleDoor structure = new LittleDoor();
        structure.doubledRelativeAxis = new LittleRelativeDoubledAxis(LittleGridContext.getMin(), LittleTileVec.ZERO, LittleTileVec.ZERO);
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        structure.axis = this.axis;
        structure.normalDirection = RotationUtils.rotateFacing((EnumFacing)this.normalDirection, (Rotation)direction);
        structure.duration = this.duration;
        return this.place(world, structure, player, defaultpreviews, absoluteAxis.pos, new OrdinaryDoorTransformation(direction), uuid, absoluteAxis, additional);
    }

    @Override
    public Rotation getDefaultRotation() {
        return Rotation.getRotation((EnumFacing.Axis)this.axis, (boolean)true);
    }

    @Override
    public boolean activate(World world, @Nullable EntityPlayer player, @Nullable Rotation rotation, BlockPos pos) {
        if (this.axis != null && !this.isWaitingForApprove) {
            if (!this.hasLoaded()) {
                player.func_146105_b((ITextComponent)new TextComponentTranslation("Cannot interact with door! Not all tiles are loaded!", new Object[0]), true);
                return false;
            }
            if (rotation == null) {
                double playerRotation = MathHelper.func_76142_g((float)player.field_70177_z);
                boolean rotX = playerRotation <= -90.0 || playerRotation >= 90.0;
                boolean rotY = player.field_70125_A > 0.0f;
                boolean rotZ = playerRotation > 0.0 && playerRotation <= 180.0;
                block0 : switch (this.axis) {
                    case X: {
                        rotation = Rotation.X_CLOCKWISE;
                        switch (this.normalDirection) {
                            case UP: {
                                if (rotY) break block0;
                                rotation = Rotation.X_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case DOWN: {
                                if (!rotY) break block0;
                                rotation = Rotation.X_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case SOUTH: {
                                if (rotX) break block0;
                                rotation = Rotation.X_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case NORTH: {
                                if (!rotX) break block0;
                                rotation = Rotation.X_COUNTER_CLOCKWISE;
                                break block0;
                            }
                        }
                        break;
                    }
                    case Y: {
                        rotation = Rotation.Y_CLOCKWISE;
                        switch (this.normalDirection) {
                            case EAST: {
                                if (!rotX) break block0;
                                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case WEST: {
                                if (rotX) break block0;
                                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case SOUTH: {
                                if (rotZ) break block0;
                                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case NORTH: {
                                if (!rotZ) break block0;
                                rotation = Rotation.Y_COUNTER_CLOCKWISE;
                                break block0;
                            }
                        }
                        break;
                    }
                    case Z: {
                        rotation = Rotation.Z_CLOCKWISE;
                        switch (this.normalDirection) {
                            case EAST: {
                                if (!rotZ) break block0;
                                rotation = Rotation.Z_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case WEST: {
                                if (rotZ) break block0;
                                rotation = Rotation.Z_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case UP: {
                                if (rotY) break block0;
                                rotation = Rotation.Z_COUNTER_CLOCKWISE;
                                break block0;
                            }
                            case DOWN: {
                                if (!rotY) break block0;
                                rotation = Rotation.Z_COUNTER_CLOCKWISE;
                                break block0;
                            }
                        }
                        break;
                    }
                }
            }
            boolean inverse = false;
            switch (this.axis) {
                case X: {
                    inverse = rotation == Rotation.X_CLOCKWISE;
                    break;
                }
                case Y: {
                    inverse = rotation == Rotation.Y_CLOCKWISE;
                    break;
                }
                case Z: {
                    inverse = rotation == Rotation.Z_CLOCKWISE;
                    break;
                }
            }
            UUID uuid = UUID.randomUUID();
            if (world.field_72995_K) {
                PacketHandler.sendPacketToServer((CreativeCorePacket)new LittleDoorInteractPacket(pos, player, rotation, inverse, uuid));
            }
            this.interactWithDoor(world, player, rotation, inverse, uuid);
            return true;
        }
        return false;
    }

    @Override
    public boolean onBlockActivated(World world, LittleTile tile, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ, LittleActionActivated action) {
        if (world.field_72995_K) {
            this.activate(world, player, null, pos);
            action.preventPacket = true;
        }
        return true;
    }

    public boolean interactWithDoor(World world, EntityPlayer player, Rotation rotation, boolean inverse, UUID uuid) {
        this.LoadList();
        LittleTilePos axisPoint = this.getAbsoluteAxisVec();
        LittleTileVec additional = this.getAdditionalAxisVec();
        axisPoint.removeInternalBlockOffset();
        BlockPos main = axisPoint.pos;
        HashMapList tempTiles = new HashMapList(this.tiles);
        HashMap<TileEntityLittleTiles, LittleGridContext> tempContext = new HashMap<TileEntityLittleTiles, LittleGridContext>();
        for (TileEntityLittleTiles te : tempTiles.keySet()) {
            tempContext.put(te, te.getContext());
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = true;
            ((TileEntityLittleTiles)entry.getKey()).removeTiles((Collection)entry.getValue());
            ((TileEntityLittleTiles)entry.getKey()).preventUpdate = false;
        }
        LittleAbsolutePreviews previews = new LittleAbsolutePreviews(axisPoint.pos, this.getMinContext());
        Iterator<LittleTile> iterator = this.getTiles();
        while (iterator.hasNext()) {
            LittleTile tile = iterator.next();
            previews.addTile(tile);
        }
        if (this.tryToPlacePreviews(world, player, main, rotation, !inverse, uuid, previews, axisPoint, additional) || this.tryToPlacePreviews(world, player, main, rotation.getOpposite(), inverse, uuid, previews, axisPoint, additional)) {
            for (Map.Entry entry : tempTiles.entrySet()) {
                ((TileEntityLittleTiles)entry.getKey()).updateTiles();
            }
            return true;
        }
        for (Map.Entry entry : tempTiles.entrySet()) {
            ((TileEntityLittleTiles)entry.getKey()).convertTo((LittleGridContext)tempContext.get(entry.getKey()));
            ((TileEntityLittleTiles)entry.getKey()).addTiles((Collection)entry.getValue());
        }
        return false;
    }

    public void updateNormalDirection() {
        switch (this.axis) {
            case X: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.Z);
                break;
            }
            case Y: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.X);
                break;
            }
            case Z: {
                this.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)EnumFacing.Axis.Y);
                break;
            }
        }
    }

    public void writeToNBTPreview(NBTTagCompound nbt, BlockPos newCenter) {
        LittleRelativeDoubledAxis axisPointBackup = this.doubledRelativeAxis.copy();
        LittleTileVecContext vec = new LittleTilePos(this.getMainTile().te.func_174877_v(), axisPointBackup.context).getRelative(new LittleTilePos(newCenter, axisPointBackup.context));
        this.doubledRelativeAxis.add(vec);
        vec = new LittleTileVecContext(this.getMainTile().getContext(), this.getMainTile().getMinVec());
        this.doubledRelativeAxis.add(vec);
        super.writeToNBTPreview(nbt, newCenter);
        this.doubledRelativeAxis = axisPointBackup;
    }

    @Override
    public LittleDoorBase copyToPlaceDoor() {
        LittleDoor structure = new LittleDoor();
        structure.doubledRelativeAxis = new LittleRelativeDoubledAxis(LittleGridContext.getMin(), LittleTileVec.ZERO, LittleTileVec.ZERO);
        structure.setTiles((HashMapList<TileEntityLittleTiles, LittleTile>)new HashMapList());
        structure.axis = this.axis;
        structure.normalDirection = this.normalDirection;
        structure.duration = this.duration;
        return structure;
    }

    @Override
    public List<PlacePreviewTile> getAdditionalPreviews(PlacePreviews previews) {
        ArrayList<PlacePreviewTile> additional = new ArrayList<PlacePreviewTile>();
        LittleTileBox box = new LittleTileBox(0, 0, 0, 1, 1, 1);
        additional.add(new PlacePreviewTileAxis(box, null, this.axis, this.getAdditionalAxisVec()));
        return additional;
    }

    public static class LittleDoorParser
    extends LittleDoorBase.LittleDoorBaseParser<LittleDoor> {
        public LittleDoorParser(String id, GuiParent parent) {
            super(id, parent);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public LittleDoor parseStructure(int duration) {
            LittleDoor door = new LittleDoor();
            GuiTileViewer viewer = (GuiTileViewer)this.parent.get("tileviewer");
            door.doubledRelativeAxis = new LittleRelativeDoubledAxis(viewer.context, new LittleTileVec(viewer.axisX / 2, viewer.axisY / 2, viewer.axisZ / 2), new LittleTileVec(viewer.axisX % 2, viewer.axisY % 2, viewer.axisZ % 2));
            door.axis = viewer.axisDirection;
            door.normalDirection = RotationUtils.getFacing((EnumFacing.Axis)viewer.normalAxis);
            door.duration = duration;
            return door;
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void createControls(ItemStack stack, LittleStructure structure) {
            super.createControls(stack, structure);
            LittleDoor door = null;
            if (structure instanceof LittleDoor) {
                door = (LittleDoor)structure;
            }
            GuiTileViewer tile = new GuiTileViewer("tileviewer", 0, 30, 100, 100, stack);
            boolean even = false;
            if (door != null) {
                tile.axisDirection = door.axis;
                tile.axisX = door.doubledRelativeAxis.vec.x * 2;
                tile.axisY = door.doubledRelativeAxis.vec.y * 2;
                tile.axisZ = door.doubledRelativeAxis.vec.z * 2;
                tile.normalAxis = door.normalDirection.func_176740_k();
                even = door.doubledRelativeAxis.isEven();
                tile.setEven(even);
            } else {
                tile.setEven(false);
            }
            tile.visibleAxis = true;
            tile.updateViewDirection();
            this.parent.controls.add(tile);
            this.parent.controls.add(new GuiIDButton("reset view", 109, 25, 0));
            this.parent.controls.add(new GuiIDButton("flip view", 109, 45, 1));
            this.parent.controls.add(new GuiIDButton("swap axis", 109, 5, 2));
            this.parent.controls.add(new GuiIDButton("swap normal", 109, 65, 3));
            this.parent.controls.add(new GuiButton("up", "<-", 125, 86, 14){

                public void onClicked(int x, int y, int button) {
                }
            }.setRotation(90.0f));
            this.parent.controls.add(new GuiIDButton("->", 146, 107, 4));
            this.parent.controls.add(new GuiIDButton("<-", 107, 107, 5));
            this.parent.controls.add(new GuiButton("down", "<-", 125, 107, 14){

                public void onClicked(int x, int y, int button) {
                }
            }.setRotation(-90.0f));
            this.parent.controls.add(new GuiCheckBox("even", 107, 124, even));
        }

        @CustomEventSubscribe
        @SideOnly(value=Side.CLIENT)
        public void onButtonClicked(GuiControlClickEvent event) {
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            if (event.source.is(new String[]{"swap axis"})) {
                EnumFacing.Axis axis = null;
                switch (viewer.axisDirection) {
                    case X: {
                        axis = EnumFacing.Axis.Y;
                        break;
                    }
                    case Y: {
                        axis = EnumFacing.Axis.Z;
                        break;
                    }
                    case Z: {
                        axis = EnumFacing.Axis.X;
                        break;
                    }
                }
                viewer.axisDirection = axis;
                viewer.updateViewDirection();
                viewer.updateNormalAxis();
            } else if (event.source.is(new String[]{"reset view"})) {
                viewer.offsetX = (SmoothValue)0.0f;
                viewer.offsetY = (SmoothValue)0.0f;
                viewer.scale = (SmoothValue)5.0f;
            } else if (event.source.is(new String[]{"flip view"})) {
                viewer.viewDirection = viewer.viewDirection.func_176734_d();
                viewer.baked = null;
            } else if (event.source instanceof GuiButton) {
                int amount;
                int n = amount = GuiScreen.func_146271_m() ? 2 * viewer.context.size : 2;
                if (event.source.is(new String[]{"<-"})) {
                    if (viewer.axisDirection == EnumFacing.Axis.X) {
                        viewer.axisZ += amount;
                    } else {
                        viewer.axisX -= amount;
                    }
                }
                if (event.source.is(new String[]{"->"})) {
                    if (viewer.axisDirection == EnumFacing.Axis.X) {
                        viewer.axisZ -= amount;
                    } else {
                        viewer.axisX += amount;
                    }
                }
                if (event.source.is(new String[]{"up"})) {
                    if (viewer.axisDirection == EnumFacing.Axis.Y) {
                        viewer.axisZ -= amount;
                    } else {
                        viewer.axisY += amount;
                    }
                }
                if (event.source.is(new String[]{"down"})) {
                    if (viewer.axisDirection == EnumFacing.Axis.Y) {
                        viewer.axisZ += amount;
                    } else {
                        viewer.axisY -= amount;
                    }
                } else if (event.source.is(new String[]{"swap normal"})) {
                    viewer.changeNormalAxis();
                }
            } else if (event.source.is(new String[]{"even"})) {
                viewer.setEven(((GuiCheckBox)event.source).value);
            }
        }
    }

    public static class PlacePreviewTileAxis
    extends PlacePreviewTile {
        public static int red = ColorUtils.VecToInt((Vec3d)new Vec3d(1.0, 0.0, 0.0));
        public EnumFacing.Axis axis;
        public LittleTileVec additionalOffset;

        public PlacePreviewTileAxis(LittleTileBox box, LittleTilePreview preview, EnumFacing.Axis axis, LittleTileVec additionalOffset) {
            super(box, preview);
            this.axis = axis;
            this.additionalOffset = additionalOffset;
        }

        @Override
        public boolean needsCollisionTest() {
            return false;
        }

        @Override
        public PlacePreviewTile copy() {
            return new PlacePreviewTileAxis(this.box.copy(), null, this.axis, this.additionalOffset.copy());
        }

        @Override
        public List<LittleRenderingCube> getPreviews(LittleGridContext context) {
            ArrayList<LittleRenderingCube> cubes = new ArrayList<LittleRenderingCube>();
            LittleTileBox preview = this.box.copy();
            int max = 40 * context.size;
            int min = -max;
            switch (this.axis) {
                case X: {
                    preview.minX = min;
                    preview.maxX = max;
                    break;
                }
                case Y: {
                    preview.minY = min;
                    preview.maxY = max;
                    break;
                }
                case Z: {
                    preview.minZ = min;
                    preview.maxZ = max;
                    break;
                }
            }
            LittleRenderingCube cube = preview.getRenderingCube(context, null, 0);
            cube.sub(new Vec3d(context.gridMCLength / 2.0, context.gridMCLength / 2.0, context.gridMCLength / 2.0));
            cube.add(this.additionalOffset.getVec(context).func_186678_a(0.5));
            cube.color = red;
            cubes.add(cube);
            return cubes;
        }

        public List<LittleTile> placeTile(EntityPlayer player, ItemStack stack, BlockPos pos, LittleGridContext context, TileEntityLittleTiles teLT, LittleStructure structure, List<LittleTile> unplaceableTiles, List<LittleTile> removedTiles, PlacementMode mode, EnumFacing facing, boolean requiresCollisionTest) {
            if (structure instanceof LittleDoor) {
                LittleDoor door = (LittleDoor)structure;
                LittleTilePos absolute = new LittleTilePos(pos, context, this.box.getMinVec());
                if (door.getMainTile() == null) {
                    door.selectMainTile();
                }
                LittleTileVecContext vec = absolute.getRelative(door.getMainTile().getAbsolutePos());
                door.doubledRelativeAxis = new LittleRelativeDoubledAxis(vec.context, vec.vec, this.additionalOffset.copy());
            }
            return Collections.EMPTY_LIST;
        }
    }

    public static class LittleRelativeDoubledAxis
    extends LittleTileVecContext {
        public LittleTileVec additional;

        public LittleRelativeDoubledAxis(LittleGridContext context, LittleTileVec vec, LittleTileVec additional) {
            super(context, vec);
            this.additional = additional;
        }

        public LittleRelativeDoubledAxis(String name, NBTTagCompound nbt) {
            super(name, nbt);
        }

        @Override
        protected void loadFromNBT(String name, NBTTagCompound nbt) {
            int[] array = nbt.func_74759_k(name);
            if (array.length == 3) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get();
                this.additional = new LittleTileVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 4) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleTileVec(this.vec.x % 2, this.vec.y % 2, this.vec.z % 2);
                this.vec.x /= 2;
                this.vec.y /= 2;
                this.vec.z /= 2;
            } else if (array.length == 7) {
                this.vec = new LittleTileVec(array[0], array[1], array[2]);
                this.context = LittleGridContext.get(array[3]);
                this.additional = new LittleTileVec(array[4], array[5], array[6]);
            } else {
                throw new InvalidParameterException("No valid coords given " + nbt);
            }
        }

        public LittleTileVecContext getNonDoubledVec() {
            return new LittleTileVecContext(this.context, this.vec);
        }

        public LittleTileVec getRotationVec() {
            LittleTileVec vec = this.vec.copy();
            vec.scale(2);
            vec.add(this.additional);
            return vec;
        }

        @Override
        public LittleRelativeDoubledAxis copy() {
            return new LittleRelativeDoubledAxis(this.context, this.vec.copy(), this.additional.copy());
        }

        @Override
        public void convertTo(LittleGridContext to) {
            LittleTileVec newVec = this.getRotationVec();
            newVec.convertTo(this.context, to);
            super.convertTo(to);
            this.additional = new LittleTileVec(newVec.x % 2, newVec.y % 2, newVec.z % 2);
            this.vec = newVec;
            this.vec.x /= 2;
            this.vec.y /= 2;
            this.vec.z /= 2;
        }

        @Override
        public void convertToSmallest() {
            if (this.isEven()) {
                super.convertToSmallest();
            }
        }

        @Override
        public boolean equals(Object paramObject) {
            if (paramObject instanceof LittleRelativeDoubledAxis) {
                return super.equals(paramObject) && this.additional.equals(((LittleRelativeDoubledAxis)paramObject).additional);
            }
            return false;
        }

        public boolean isEven() {
            return this.additional.x % 2 == 0;
        }

        @Override
        public void writeToNBT(String name, NBTTagCompound nbt) {
            nbt.func_74783_a(name, new int[]{this.vec.x, this.vec.y, this.vec.z, this.context.size, this.additional.x, this.additional.y, this.additional.z});
        }

        @Override
        public String toString() {
            return "[" + this.vec.x + "," + this.vec.y + "," + this.vec.z + ",grid:" + this.context.size + ",additional:" + this.additional + "]";
        }
    }
}

