/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.common.action.LittleAction;
import com.creativemd.littletiles.common.action.LittleActionException;
import com.creativemd.littletiles.common.structure.type.LittleDoorBase;
import com.creativemd.littletiles.common.tiles.LittleTile;
import com.creativemd.littletiles.common.tiles.vec.LittleTileIdentifierAbsolute;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LittleDoorPacket
extends CreativeCorePacket {
    public LittleTileIdentifierAbsolute coord;
    public UUID uuid;

    public LittleDoorPacket(LittleTile tile, UUID uuid) {
        this.coord = new LittleTileIdentifierAbsolute(tile);
        this.uuid = uuid;
    }

    public LittleDoorPacket() {
    }

    public void writeBytes(ByteBuf buf) {
        LittleAction.writeAbsoluteCoord(this.coord, buf);
        LittleDoorPacket.writeString((ByteBuf)buf, (String)this.uuid.toString());
    }

    public void readBytes(ByteBuf buf) {
        this.coord = LittleAction.readAbsoluteCoord(buf);
        this.uuid = UUID.fromString(LittleDoorPacket.readString((ByteBuf)buf));
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
        try {
            LittleTile tile = LittleAction.getTile(player.field_70170_p, this.coord);
            if (tile.isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) instanceof LittleDoorBase) {
                ((LittleDoorBase)tile.connection.getStructureWithoutLoading()).openDoor(player.field_70170_p, player, this.uuid);
            }
        }
        catch (LittleActionException e) {
            e.printStackTrace();
        }
    }

    public void executeServer(EntityPlayer player) {
        try {
            LittleTile tile = LittleAction.getTile(player.field_70170_p, this.coord);
            if (tile.isConnectedToStructure() && tile.connection.getStructure(tile.te.func_145831_w()) instanceof LittleDoorBase) {
                ((LittleDoorBase)tile.connection.getStructureWithoutLoading()).openDoor(player.field_70170_p, player, this.uuid);
            }
        }
        catch (LittleActionException e) {
            e.printStackTrace();
        }
    }
}

