/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui.dialogs;

import com.creativemd.creativecore.common.gui.container.SubGui;
import com.creativemd.creativecore.common.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiCheckBox;
import com.creativemd.creativecore.common.gui.controls.gui.GuiIconButton;
import com.creativemd.creativecore.common.gui.controls.gui.GuiStateButton;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.creativecore.common.gui.event.gui.GuiControlClickEvent;
import com.creativemd.creativecore.common.gui.mc.ContainerSub;
import com.creativemd.creativecore.common.gui.premade.SubContainerEmpty;
import com.creativemd.littletiles.common.entity.AnimationPreview;
import com.creativemd.littletiles.common.gui.controls.GuiTileViewer;
import com.creativemd.littletiles.common.gui.controls.IAnimationControl;
import com.creativemd.littletiles.common.structure.relative.StructureAbsolute;
import com.creativemd.littletiles.common.structure.type.LittleAdvancedDoor;
import com.creativemd.littletiles.common.tiles.vec.LittleTileBox;
import com.creativemd.littletiles.common.utils.animation.AnimationGuiHandler;
import com.creativemd.littletiles.common.utils.grid.LittleGridContext;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SubGuiDialogAxis
extends SubGui {
    public final GuiAxisButton activator;
    public final AnimationGuiHandler handler;

    public SubGuiDialogAxis(GuiAxisButton activator, AnimationGuiHandler handler) {
        super(160, 130);
        this.activator = activator;
        this.handler = handler;
    }

    public void createControls() {
        this.controls.add(this.activator.viewer);
        this.controls.add(new GuiIconButton("reset view", 20, 107, 8){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.offsetX.set(0.0);
                SubGuiDialogAxis.this.activator.viewer.offsetY.set(0.0);
                SubGuiDialogAxis.this.activator.viewer.scale.set(40.0);
            }
        }.setCustomTooltip(new String[]{"reset view"}));
        this.controls.add(new GuiIconButton("change view", 40, 107, 7){

            public void onClicked(int x, int y, int button) {
                switch (SubGuiDialogAxis.this.activator.viewer.getAxis()) {
                    case X: {
                        SubGuiDialogAxis.this.activator.viewer.setViewAxis(EnumFacing.Axis.Y);
                        break;
                    }
                    case Y: {
                        SubGuiDialogAxis.this.activator.viewer.setViewAxis(EnumFacing.Axis.Z);
                        break;
                    }
                    case Z: {
                        SubGuiDialogAxis.this.activator.viewer.setViewAxis(EnumFacing.Axis.X);
                        break;
                    }
                }
            }
        }.setCustomTooltip(new String[]{"change view"}));
        this.controls.add(new GuiIconButton("flip view", 60, 107, 4){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.setViewDirection(SubGuiDialogAxis.this.activator.viewer.getViewDirection().func_176734_d());
            }
        }.setCustomTooltip(new String[]{"flip view"}));
        this.controls.add(new GuiIconButton("up", 124, 33, 1){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.moveY(GuiScreen.func_146271_m() ? SubGuiDialogAxis.this.activator.viewer.context.size : 1);
            }
        });
        this.controls.add(new GuiIconButton("right", 141, 50, 0){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.moveX(GuiScreen.func_146271_m() ? SubGuiDialogAxis.this.activator.viewer.context.size : 1);
            }
        });
        this.controls.add(new GuiIconButton("left", 107, 50, 2){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.moveX(-(GuiScreen.func_146271_m() ? SubGuiDialogAxis.this.activator.viewer.context.size : 1));
            }
        });
        this.controls.add(new GuiIconButton("down", 124, 50, 3){

            public void onClicked(int x, int y, int button) {
                SubGuiDialogAxis.this.activator.viewer.moveY(-(GuiScreen.func_146271_m() ? SubGuiDialogAxis.this.activator.viewer.context.size : 1));
            }
        });
        this.controls.add(new GuiCheckBox("even", 107, 0, this.activator.viewer.isEven()));
        GuiStateButton contextBox = new GuiStateButton("grid", LittleGridContext.getNames().indexOf(this.activator.viewer.getAxisContext() + ""), 107, 80, 20, 12, LittleGridContext.getNames().toArray(new String[0]));
        this.controls.add(contextBox);
        this.controls.add(new GuiButton("close", 125, 110){

            public void onClicked(int x, int y, int button) {
                this.onClosed();
                SubGuiDialogAxis.this.gui.removeLayer((SubGui)SubGuiDialogAxis.this);
            }
        });
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onAxisChanged(GuiTileViewer.GuiTileViewerAxisChangedEvent event) {
        GuiTileViewer viewer = (GuiTileViewer)event.source;
        this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), viewer.getBox().copy(), viewer.getAxisContext()));
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onButtonClicked(GuiControlClickEvent event) {
        GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
        if (event.source.is(new String[]{"even"})) {
            viewer.setEven(((GuiCheckBox)event.source).value);
        }
    }

    @CustomEventSubscribe
    @SideOnly(value=Side.CLIENT)
    public void onStateChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"grid"})) {
            LittleGridContext context;
            GuiStateButton contextBox = (GuiStateButton)event.source;
            try {
                context = LittleGridContext.get(Integer.parseInt(contextBox.caption));
            }
            catch (NumberFormatException e) {
                context = LittleGridContext.get();
            }
            GuiTileViewer viewer = (GuiTileViewer)event.source.parent.get("tileviewer");
            LittleTileBox box = viewer.getBox();
            box.convertTo(viewer.getAxisContext(), context);
            box.maxX = viewer.isEven() ? box.minX + 2 : box.minX + 1;
            box.maxY = viewer.isEven() ? box.minY + 2 : box.minY + 1;
            box.maxZ = viewer.isEven() ? box.minZ + 2 : box.minZ + 1;
            viewer.setAxis(box, context);
        }
    }

    public static class GuiAxisButton
    extends GuiButton
    implements IAnimationControl {
        public GuiTileViewer viewer;
        public LittleAdvancedDoor door;
        public LittleGridContext stackContext;
        public AnimationGuiHandler handler;

        public GuiAxisButton(String name, String caption, int x, int y, int width, int height, LittleGridContext context, LittleAdvancedDoor door, AnimationGuiHandler handler) {
            super(name, caption, x, y, width, height);
            this.setEnabled(false);
            this.stackContext = context;
            this.door = door;
            this.handler = handler;
        }

        public void onClicked(int x, int y, int button) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("dialog", true);
            SubGuiDialogAxis dialog = new SubGuiDialogAxis(this, this.handler);
            dialog.gui = this.getParent().getOrigin().gui;
            dialog.gui.addLayer((SubGui)dialog);
            dialog.container = new SubContainerEmpty(this.getPlayer());
            ((ContainerSub)dialog.gui.field_147002_h).layers.add(dialog.container);
            dialog.onOpened();
            dialog.gui.resize();
        }

        @Override
        public void onLoaded(AnimationPreview animationPreview) {
            LittleGridContext axisContext = this.stackContext;
            this.viewer = new GuiTileViewer("tileviewer", 0, 0, 100, 100, this.stackContext);
            boolean even = false;
            if (this.door != null) {
                even = this.door.axisCenter.isEven();
                this.viewer.setEven(even);
                axisContext = this.door.axisCenter.getContext();
                this.door.axisCenter.convertToSmallest();
                this.viewer.setAxis(this.door.axisCenter.getBox(), axisContext);
            } else {
                this.viewer.setEven(false);
                this.viewer.setAxis(new LittleTileBox(0, 0, 0, 1, 1, 1), this.viewer.context);
            }
            this.viewer.visibleAxis = true;
            this.viewer.onLoaded(animationPreview);
            this.setEnabled(true);
            this.handler.setCenter(new StructureAbsolute(new BlockPos(0, 75, 0), this.viewer.getBox().copy(), this.viewer.getAxisContext()));
        }
    }
}

