/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.gui;

import com.creativemd.creativecore.gui.container.GuiParent;
import com.creativemd.creativecore.gui.controls.gui.GuiButton;
import com.creativemd.creativecore.gui.controls.gui.GuiComboBox;
import com.creativemd.creativecore.gui.controls.gui.GuiLabel;
import com.creativemd.creativecore.gui.controls.gui.GuiPanel;
import com.creativemd.creativecore.gui.controls.gui.GuiTextfield;
import com.creativemd.creativecore.gui.event.gui.GuiControlChangedEvent;
import com.creativemd.littletiles.common.gui.configure.SubGuiConfigure;
import com.creativemd.littletiles.common.gui.controls.GuiAnimationViewer;
import com.creativemd.littletiles.common.structure.LittleStructure;
import com.creativemd.littletiles.common.structure.LittleStructureGuiParser;
import com.creativemd.littletiles.common.structure.LittleStructureRegistry;
import com.creativemd.littletiles.common.tiles.preview.LittlePreviews;
import com.creativemd.littletiles.common.tiles.preview.LittleTilePreview;
import com.n247s.api.eventapi.eventsystem.CustomEventSubscribe;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class SubGuiRecipeAdvancedStructure
extends SubGuiConfigure {
    public LittleStructure structure;
    public LittleStructureGuiParser parser;

    public SubGuiRecipeAdvancedStructure(ItemStack stack) {
        super(350, 200, stack);
    }

    @Override
    public void saveConfiguration() {
    }

    public void createControls() {
        this.controls.add(new GuiButton("clear", SubGuiRecipeAdvancedStructure.translate((String)"selection.clear"), 105, 176, 38){

            public void onClicked(int x, int y, int button) {
                SubGuiRecipeAdvancedStructure.this.openYesNoDialog(1.translate((String)"selection.dialog.clear"));
            }
        });
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("none");
        lines.addAll(LittleStructureRegistry.getStructureTypeNames());
        this.controls.add(new GuiLabel("type:", 2, 7));
        GuiComboBox comboBox = new GuiComboBox("types", 32, 5, 70, lines);
        LittlePreviews previews = LittleTilePreview.getPreview(this.stack);
        LittleStructure structure = previews.getStructure();
        if (structure != null) {
            this.structure = structure;
            comboBox.index = lines.indexOf(structure.structureID);
            if (comboBox.index == -1) {
                comboBox.index = 0;
            } else {
                comboBox.caption = structure.structureID;
            }
        }
        this.controls.add(new GuiAnimationViewer("renderer", 208, 30, 136, 135, this.stack));
        this.controls.add(new GuiPanel("panel", 0, 30, 200, 135));
        this.controls.add(new GuiLabel("tiles", previews.totalSize() + " tile(s)", 110, 7));
        this.controls.add(comboBox);
        this.controls.add(new GuiButton("save", 150, 176, 40){

            public void onClicked(int x, int y, int button) {
                if (SubGuiRecipeAdvancedStructure.this.parser != null) {
                    GuiTextfield textfield = (GuiTextfield)SubGuiRecipeAdvancedStructure.this.get("name");
                    Object structure = SubGuiRecipeAdvancedStructure.this.parser.parseStructure(SubGuiRecipeAdvancedStructure.this.stack);
                    if (structure != null) {
                        ((LittleStructure)structure).name = textfield.text.isEmpty() ? null : textfield.text;
                        NBTTagCompound structureNBT = new NBTTagCompound();
                        ((LittleStructure)structure).writeToNBT(structureNBT);
                        SubGuiRecipeAdvancedStructure.this.stack.func_77978_p().func_74782_a("structure", (NBTBase)structureNBT);
                    } else {
                        SubGuiRecipeAdvancedStructure.this.stack.func_77978_p().func_82580_o("structure");
                    }
                } else {
                    SubGuiRecipeAdvancedStructure.this.stack.func_77978_p().func_82580_o("structure");
                }
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74757_a("set_structure", true);
                nbt.func_74782_a("stack", (NBTBase)SubGuiRecipeAdvancedStructure.this.stack.func_77978_p());
                SubGuiRecipeAdvancedStructure.this.sendPacketToServer(nbt);
                SubGuiRecipeAdvancedStructure.this.closeGui();
            }
        });
        this.controls.add(new GuiLabel("name:", 0, 179));
        this.controls.add(new GuiTextfield("name", structure != null && structure.name != null ? structure.name : "", 32, 176, 65, 14));
        this.onChanged();
    }

    public void onChanged() {
        LittleStructureRegistry.LittleStructureEntry entry;
        LittleStructure saved;
        GuiPanel panel = (GuiPanel)this.get("panel");
        panel.controls.clear();
        String id = ((GuiComboBox)this.get((String)"types")).caption;
        if (this.parser != null) {
            this.removeListener(this.parser);
        }
        if ((saved = this.structure) != null && !saved.structureID.equals(id)) {
            saved = null;
        }
        if ((entry = LittleStructureRegistry.getStructureEntry(id)) != null) {
            this.parser = entry.createParser((GuiParent)panel);
            if (this.parser != null) {
                this.parser.createControls(this.stack, saved);
                panel.refreshControls();
                this.addListener(this.parser);
            }
        } else {
            this.parser = null;
        }
        this.get("name").setEnabled(this.parser != null);
    }

    @CustomEventSubscribe
    public void onComboChange(GuiControlChangedEvent event) {
        if (event.source.is(new String[]{"types"})) {
            this.onChanged();
        }
    }

    public void onDialogClosed(String text, String[] buttons, String clicked) {
        if (clicked.equalsIgnoreCase("yes")) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74757_a("clear_content", true);
            this.sendPacketToServer(nbt);
        }
    }

    public void receiveContainerPacket(NBTTagCompound nbt) {
        this.stack.func_77982_d(nbt);
    }
}

