/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.api.blocks;

import com.creativemd.littletiles.common.api.blocks.ISpecialBlockHandler;
import com.creativemd.littletiles.common.api.blocks.SpecialBlockHandler;
import com.creativemd.littletiles.common.entity.EntitySizedTNTPrimed;
import com.creativemd.littletiles.common.tiles.LittleTileBlock;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.LittleTileVec;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTNT;
import net.minecraft.block.BlockWorkbench;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IInteractionObject;
import net.minecraft.world.World;

public class DefaultBlockHandler {
    public static void initVanillaBlockHandlers() {
        SpecialBlockHandler.registerSpecialHandler(BlockTNT.class, new ISpecialBlockHandler(){

            @Override
            public boolean onBlockActivated(LittleTileBlock tile, World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
                if (heldItem != null && (heldItem.func_77973_b() == Items.field_151033_d || heldItem.func_77973_b() == Items.field_151059_bz)) {
                    if (!worldIn.field_72995_K) {
                        this.explodeTile(tile, (EntityLivingBase)playerIn, false);
                    }
                    tile.destroy();
                    if (heldItem.func_77973_b() == Items.field_151033_d) {
                        heldItem.func_77972_a(1, (EntityLivingBase)playerIn);
                    } else if (!playerIn.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
                return false;
            }

            @Override
            public void onTileExplodes(LittleTileBlock tile, Explosion explosion) {
                this.explodeTile(tile, explosion.func_94613_c(), true);
            }

            public void explodeTile(LittleTileBlock tile, EntityLivingBase entity, boolean randomFuse) {
                BlockPos pos = tile.te.func_174877_v();
                LittleTileSize size = tile.box.getSize();
                LittleTileVec min = tile.box.getMinVec();
                EntitySizedTNTPrimed entitytntprimed = new EntitySizedTNTPrimed(tile.te.func_145831_w(), (double)pos.func_177958_n() + min.getPosX(tile.getContext()) + size.getPosX(tile.getContext()) / 2.0, (double)pos.func_177956_o() + min.getPosY(tile.getContext()) + size.getPosY(tile.getContext()) / 2.0, (double)pos.func_177952_p() + min.getPosZ(tile.getContext()) + size.getPosZ(tile.getContext()) / 2.0, entity, tile.getContext(), size);
                if (randomFuse) {
                    entitytntprimed.func_184534_a((short)(tile.te.func_145831_w().field_73012_v.nextInt(entitytntprimed.func_184536_l() / 4) + entitytntprimed.func_184536_l() / 8));
                }
                tile.te.func_145831_w().func_72838_d((Entity)entitytntprimed);
                tile.te.func_145831_w().func_184148_a((EntityPlayer)null, entitytntprimed.field_70165_t, entitytntprimed.field_70163_u, entitytntprimed.field_70161_v, SoundEvents.field_187904_gd, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        });
        SpecialBlockHandler.registerSpecialHandler(Blocks.field_150462_ai, new ISpecialBlockHandler(){

            @Override
            public boolean onBlockActivated(LittleTileBlock tile, final World worldIn, final BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, @Nullable ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
                if (worldIn.field_72995_K) {
                    return true;
                }
                playerIn.func_180468_a((IInteractionObject)new BlockWorkbench.InterfaceCraftingTable(worldIn, pos){

                    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
                        return new ContainerWorkbench(playerInventory, worldIn, pos){

                            public boolean func_75145_c(EntityPlayer playerIn) {
                                return true;
                            }
                        };
                    }
                });
                playerIn.func_71029_a(StatList.field_188062_ab);
                return true;
            }
        });
    }
}

