/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.client.tiles;

import com.creativemd.creativecore.common.utils.math.RotationUtils;
import com.creativemd.creativecore.common.utils.math.box.CubeObject;
import com.creativemd.creativecore.common.utils.math.vec.Ray2d;
import com.creativemd.littletiles.common.tiles.vec.LittleTileSize;
import com.creativemd.littletiles.common.tiles.vec.advanced.LittleSlice;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;
import net.minecraft.client.renderer.EnumFaceDirection;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class LittleDynamicCube {
    public CubeObject defaultCube;
    public LittleSlice slice;
    public EnumFacing preferedSide;
    public Ray2d line;

    public LittleDynamicCube(CubeObject defaultCube, LittleSlice slice, LittleTileSize size) {
        this.defaultCube = defaultCube;
        this.slice = slice;
        EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)slice.axis);
        EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)slice.axis);
        this.line = new Ray2d(one, two, new Vector3d((double)defaultCube.getValueOfFacing(slice.start.x), (double)defaultCube.getValueOfFacing(slice.start.y), (double)defaultCube.getValueOfFacing(slice.start.z)), (double)(defaultCube.getSize(one) * (float)slice.getDirectionScale(one)), (double)(defaultCube.getSize(two) * (float)slice.getDirectionScale(two)));
        this.preferedSide = slice.getPreferedSide(defaultCube.getSize());
    }

    public Vector3f sliceVector(EnumFacing facing, Vector3f vec, BlockPos pos) {
        if (facing.func_176740_k() == this.slice.axis) {
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst((EnumFacing.Axis)this.slice.axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond((EnumFacing.Axis)this.slice.axis);
            float value = this.slice.isFacingPositive(two) ? Math.min(RotationUtils.get((EnumFacing.Axis)two, (Tuple3f)vec), (float)this.line.get(one, (double)(RotationUtils.get((EnumFacing.Axis)one, (Tuple3f)vec) + (float)RotationUtils.get((EnumFacing.Axis)one, (Vec3i)pos))) - (float)RotationUtils.get((EnumFacing.Axis)two, (Vec3i)pos)) : Math.max(RotationUtils.get((EnumFacing.Axis)two, (Tuple3f)vec), (float)this.line.get(one, (double)(RotationUtils.get((EnumFacing.Axis)one, (Tuple3f)vec) + (float)RotationUtils.get((EnumFacing.Axis)one, (Vec3i)pos))) - (float)RotationUtils.get((EnumFacing.Axis)two, (Vec3i)pos));
            if (value >= this.defaultCube.getMin(two) && value < this.defaultCube.getMax(two)) {
                RotationUtils.setValue((Tuple3f)vec, (float)value, (EnumFacing.Axis)two);
            } else {
                value = this.slice.isFacingPositive(one) ? Math.min(RotationUtils.get((EnumFacing.Axis)one, (Tuple3f)vec), (float)this.line.get(two, (double)(RotationUtils.get((EnumFacing.Axis)two, (Tuple3f)vec) + (float)RotationUtils.get((EnumFacing.Axis)two, (Vec3i)pos))) - (float)RotationUtils.get((EnumFacing.Axis)one, (Vec3i)pos)) : Math.max(RotationUtils.get((EnumFacing.Axis)one, (Tuple3f)vec), (float)this.line.get(two, (double)(RotationUtils.get((EnumFacing.Axis)two, (Tuple3f)vec) + (float)RotationUtils.get((EnumFacing.Axis)two, (Vec3i)pos))) - (float)RotationUtils.get((EnumFacing.Axis)one, (Vec3i)pos));
                RotationUtils.setValue((Tuple3f)vec, (float)value, (EnumFacing.Axis)one);
            }
            return vec;
        }
        if (this.preferedSide != facing && this.slice.getEmptySide(facing.func_176740_k()) != facing) {
            return vec;
        }
        EnumFacing.Axis axis = facing.func_176740_k();
        EnumFacing.Axis different = RotationUtils.getDifferentAxis((EnumFacing.Axis)facing.func_176740_k(), (EnumFacing.Axis)this.slice.axis);
        float value = (float)this.line.get(different, (double)(RotationUtils.get((EnumFacing.Axis)different, (Tuple3f)vec) + (float)RotationUtils.get((EnumFacing.Axis)different, (Vec3i)pos))) - (float)RotationUtils.get((EnumFacing.Axis)axis, (Vec3i)pos);
        RotationUtils.setValue((Tuple3f)vec, (float)value, (EnumFacing.Axis)axis);
        return vec;
    }

    public Vector3f get(EnumFacing facing, EnumFaceDirection.VertexInformation info, Vector3f output) {
        output.set(this.defaultCube.getVertexInformationPosition(info.field_179184_a), this.defaultCube.getVertexInformationPosition(info.field_179182_b), this.defaultCube.getVertexInformationPosition(info.field_179183_c));
        this.sliceVector(facing, output, BlockPos.field_177992_a);
        return output;
    }
}

