/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.logic;

import java.util.Iterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import mcjty.xnet.blocks.cables.ConnectorBlock;
import mcjty.xnet.blocks.generic.CableColor;
import mcjty.xnet.blocks.generic.GenericCableBlock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ConnectorIterator
implements Iterator<BlockPos> {
    @Nonnull
    private final World world;
    @Nonnull
    private final BlockPos pos;
    private final boolean routing;
    private int facingIdx = 0;
    private BlockPos foundPos = null;

    Stream<BlockPos> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this, (long)EnumFacing.field_82609_l.length, 16), false);
    }

    ConnectorIterator(@Nonnull World world, @Nonnull BlockPos pos, boolean routing) {
        this.world = world;
        this.pos = pos;
        this.routing = routing;
        this.findNext();
    }

    private void findNext() {
        this.foundPos = null;
        while (this.facingIdx != -1) {
            CableColor color;
            IBlockState state;
            BlockPos connectorPos = this.pos.func_177972_a(EnumFacing.field_82609_l[this.facingIdx]);
            ++this.facingIdx;
            if (this.facingIdx >= EnumFacing.field_82609_l.length) {
                this.facingIdx = -1;
            }
            if (!((state = this.world.func_180495_p(connectorPos)).func_177230_c() instanceof ConnectorBlock) || (color = (CableColor)((Object)state.func_177229_b(GenericCableBlock.COLOR))) == CableColor.ROUTING != this.routing) continue;
            this.foundPos = connectorPos;
            return;
        }
    }

    @Override
    public boolean hasNext() {
        return this.foundPos != null;
    }

    @Override
    public BlockPos next() {
        BlockPos f = this.foundPos;
        this.findNext();
        return f;
    }
}

