/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsdim.blocks.absorbers;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import java.util.Set;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.varia.SoundTools;
import mcjty.rftoolsdim.config.DimletConstructionConfiguration;
import mcjty.rftoolsdim.config.Settings;
import mcjty.rftoolsdim.dimensions.dimlets.DimletKey;
import mcjty.rftoolsdim.dimensions.dimlets.KnownDimletConfiguration;
import mcjty.rftoolsdim.dimensions.dimlets.types.DimletType;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class MaterialAbsorberTileEntity
extends GenericTileEntity
implements ITickable {
    private static final int ABSORB_SPEED = 2;
    private int absorbing = 0;
    private IBlockState blockState = null;
    private int timer = 2;
    private Set<BlockPos> toscan = new HashSet<BlockPos>();

    public void func_73660_a() {
        if (this.func_145831_w().field_72995_K) {
            this.checkStateClient();
        } else {
            this.checkStateServer();
        }
    }

    private void checkStateClient() {
        if (this.absorbing > 0) {
            Random rand = this.func_145831_w().field_73012_v;
            double u = rand.nextFloat() * 2.0f - 1.0f;
            double v = (float)((double)(rand.nextFloat() * 2.0f) * Math.PI);
            double x = Math.sqrt(1.0 - u * u) * Math.cos(v);
            double y = Math.sqrt(1.0 - u * u) * Math.sin(v);
            double z = u;
            double r = 1.0;
            this.func_145831_w().func_175688_a(EnumParticleTypes.PORTAL, (double)((float)this.func_174877_v().func_177958_n() + 0.5f) + x * r, (double)((float)this.func_174877_v().func_177956_o() + 0.5f) + y * r, (double)((float)this.func_174877_v().func_177952_p() + 0.5f) + z * r, -x, -y, -z, new int[0]);
        }
    }

    private void checkBlock(BlockPos c, EnumFacing direction) {
        BlockPos c2 = c.func_177972_a(direction);
        if (this.blockMatches(c2)) {
            this.toscan.add(c2);
        }
    }

    private boolean blockMatches(BlockPos c) {
        return this.func_145831_w().func_180495_p(c).equals(this.blockState);
    }

    public int getAbsorbing() {
        return this.absorbing;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    private IBlockState isValidSourceBlock(BlockPos coordinate) {
        IBlockState state = this.func_145831_w().func_180495_p(coordinate);
        return this.isValidDimletBlock(state) ? state : null;
    }

    private void checkStateServer() {
        if (this.absorbing > 0 || this.blockState == null) {
            --this.timer;
            if (this.timer <= 0) {
                this.timer = 2;
                IBlockState b = this.isValidSourceBlock(this.func_174877_v().func_177977_b());
                if (b != null) {
                    if (this.blockState == null) {
                        this.absorbing = DimletConstructionConfiguration.maxBlockAbsorbtion;
                        if (b.func_177230_c() == Blocks.field_150439_ay) {
                            b = Blocks.field_150450_ax.func_176223_P();
                        }
                        if (Item.func_150898_a((Block)b.func_177230_c()) != null) {
                            this.blockState = b;
                            this.toscan.clear();
                        }
                    }
                    this.toscan.add(this.func_174877_v().func_177977_b());
                }
                if (!this.toscan.isEmpty()) {
                    int r = this.func_145831_w().field_73012_v.nextInt(this.toscan.size());
                    Iterator<BlockPos> iterator = this.toscan.iterator();
                    BlockPos c = null;
                    for (int i = 0; i <= r; ++i) {
                        c = iterator.next();
                    }
                    this.toscan.remove(c);
                    this.checkBlock(c, EnumFacing.DOWN);
                    this.checkBlock(c, EnumFacing.UP);
                    this.checkBlock(c, EnumFacing.EAST);
                    this.checkBlock(c, EnumFacing.WEST);
                    this.checkBlock(c, EnumFacing.SOUTH);
                    this.checkBlock(c, EnumFacing.NORTH);
                    if (this.blockMatches(c)) {
                        IBlockState oldState = this.func_145831_w().func_180495_p(c);
                        SoundTools.playSound((World)this.func_145831_w(), (SoundEvent)this.blockState.func_177230_c().getSoundType(oldState, this.func_145831_w(), c, null).func_185845_c(), (double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p(), (double)1.0, (double)1.0);
                        this.func_145831_w().func_175698_g(c);
                        --this.absorbing;
                        IBlockState newState = this.func_145831_w().func_180495_p(c);
                        this.func_145831_w().func_184138_a(c, oldState, newState, 3);
                    }
                }
            }
            this.markDirtyClient();
        }
    }

    private boolean isValidDimletBlock(IBlockState state) {
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        DimletKey key = new DimletKey(DimletType.DIMLET_MATERIAL, block.getRegistryName() + "@" + meta);
        Settings settings = KnownDimletConfiguration.getSettings(key);
        return settings != null && settings.isDimlet();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        int[] x = new int[this.toscan.size()];
        int[] y = new int[this.toscan.size()];
        int[] z = new int[this.toscan.size()];
        int i = 0;
        for (BlockPos c : this.toscan) {
            x[i] = c.func_177958_n();
            y[i] = c.func_177956_o();
            z[i] = c.func_177952_p();
            ++i;
        }
        tagCompound.func_74783_a("toscanx", x);
        tagCompound.func_74783_a("toscany", y);
        tagCompound.func_74783_a("toscanz", z);
        return tagCompound;
    }

    public void writeRestorableToNBT(NBTTagCompound tagCompound) {
        super.writeRestorableToNBT(tagCompound);
        tagCompound.func_74768_a("absorbing", this.absorbing);
        if (this.blockState != null) {
            String resourcePath = this.blockState.func_177230_c().getRegistryName().toString();
            tagCompound.func_74778_a("block", resourcePath);
            int meta = this.blockState.func_177230_c().func_176201_c(this.blockState);
            tagCompound.func_74768_a("meta", meta);
        }
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        super.func_145839_a(tagCompound);
        int[] x = tagCompound.func_74759_k("toscanx");
        int[] y = tagCompound.func_74759_k("toscany");
        int[] z = tagCompound.func_74759_k("toscanz");
        this.toscan.clear();
        for (int i = 0; i < x.length; ++i) {
            this.toscan.add(new BlockPos(x[i], y[i], z[i]));
        }
    }

    public void readRestorableFromNBT(NBTTagCompound tagCompound) {
        super.readRestorableFromNBT(tagCompound);
        this.absorbing = tagCompound.func_74762_e("absorbing");
        if (tagCompound.func_74764_b("block")) {
            Block block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(tagCompound.func_74779_i("block")));
            int meta = tagCompound.func_74762_e("meta");
            this.blockState = block.func_176203_a(meta);
        } else {
            this.blockState = null;
        }
    }
}

