/*
 * Decompiled with CFR 0.152.
 */
package com.expensivekoala.refined_avaritia.item;

import com.expensivekoala.refined_avaritia.RefinedAvaritia;
import com.expensivekoala.refined_avaritia.Registry;
import com.expensivekoala.refined_avaritia.util.ExtremePattern;
import com.expensivekoala.refined_avaritia.util.RecipeType;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPattern;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternContainer;
import com.raoulvdberge.refinedstorage.api.autocrafting.ICraftingPatternProvider;
import com.raoulvdberge.refinedstorage.apiimpl.API;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemExtremePattern
extends Item
implements ICraftingPatternProvider {
    private static Map<ItemStack, ExtremePattern> PATTERN_CACHE = new HashMap<ItemStack, ExtremePattern>();
    private static final String NBT_SLOT = "Input_%d";
    private static final String NBT_OREDICT = "Oredict";
    public static final String NBT_TYPE = "Type";

    public ItemExtremePattern() {
        this.setRegistryName("refined_avaritia", "extreme_pattern");
        this.func_77637_a(RefinedAvaritia.instance.tab);
    }

    public String func_77658_a() {
        return "item.refined_avaritia:extreme_pattern";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    public static ExtremePattern getPatternFromCache(World world, ItemStack stack) {
        if (!PATTERN_CACHE.containsKey(stack)) {
            PATTERN_CACHE.put(stack, new ExtremePattern(world, null, stack));
        }
        return PATTERN_CACHE.get(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!stack.func_77942_o()) {
            return;
        }
        ExtremePattern pattern = ItemExtremePattern.getPatternFromCache(worldIn, stack);
        if (pattern.isValid()) {
            if (GuiScreen.func_146272_n()) {
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.inputs", (Object[])new Object[0]) + TextFormatting.RESET);
                ItemExtremePattern.combineItems(tooltip, true, pattern.getInputs().stream().map(i -> i.size() > 0 ? (ItemStack)i.get(0) : ItemStack.field_190927_a).collect(Collectors.toList()));
                tooltip.add(TextFormatting.YELLOW + I18n.func_135052_a((String)"misc.refinedstorage:pattern.outputs", (Object[])new Object[0]) + TextFormatting.RESET);
            }
            ItemExtremePattern.combineItems(tooltip, true, (List<ItemStack>)pattern.getOutputs());
            if (ItemExtremePattern.isOredict(stack)) {
                tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"misc.refinedstorage:pattern.oredict", (Object[])new Object[0]) + TextFormatting.RESET);
            }
        } else {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"misc.refinedstorage:pattern.invalid", (Object[])new Object[0]) + TextFormatting.RESET);
        }
    }

    public static void setSlot(ItemStack pattern, int slot, ItemStack stack) {
        if (stack.func_190916_E() < 0) {
            stack.func_190920_e(1);
        }
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74782_a(String.format(NBT_SLOT, slot), (NBTBase)stack.serializeNBT());
    }

    public static ItemStack getSlot(ItemStack pattern, int slot) {
        String id = String.format(NBT_SLOT, slot);
        String idLegacy = String.format("Slot_%d", slot);
        if (!pattern.func_77942_o()) {
            return ItemStack.field_190927_a;
        }
        if (!pattern.func_77978_p().func_74764_b(idLegacy) && !pattern.func_77978_p().func_74764_b(id)) {
            return ItemStack.field_190927_a;
        }
        if (pattern.func_77978_p().func_74764_b(idLegacy)) {
            return new ItemStack(pattern.func_77978_p().func_74775_l(idLegacy));
        }
        return new ItemStack(pattern.func_77978_p().func_74775_l(id));
    }

    public static boolean isOredict(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_OREDICT) && pattern.func_77978_p().func_74767_n(NBT_OREDICT);
    }

    public static void setOredict(ItemStack pattern, boolean oredict) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74757_a(NBT_OREDICT, oredict);
    }

    public static void setType(ItemStack pattern, RecipeType type) {
        if (!pattern.func_77942_o()) {
            pattern.func_77982_d(new NBTTagCompound());
        }
        pattern.func_77978_p().func_74768_a(NBT_TYPE, type.ordinal());
    }

    public static RecipeType getType(ItemStack pattern) {
        return pattern.func_77942_o() && pattern.func_77978_p().func_74764_b(NBT_TYPE) ? RecipeType.values()[pattern.func_77978_p().func_74762_e(NBT_TYPE)] : null;
    }

    public static void combineItems(List<String> tooltip, boolean displayAmount, List<ItemStack> stacks) {
        HashSet<Integer> combinedIndices = new HashSet<Integer>();
        for (int i = 0; i < stacks.size(); ++i) {
            if (stacks.get(i).func_190926_b() || combinedIndices.contains(i)) continue;
            ItemStack stack = stacks.get(i);
            String data = stack.func_82833_r();
            int amount = stack.func_190916_E();
            for (int j = i + 1; j < stacks.size(); ++j) {
                if (!API.instance().getComparer().isEqual(stack, stacks.get(j))) continue;
                amount += stacks.get(j).func_190916_E();
                combinedIndices.add(j);
            }
            data = TextFormatting.GRAY + (displayAmount ? String.valueOf(amount) + "x " : "") + data;
            tooltip.add(data);
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)new ItemStack((Item)Registry.PATTERN, playerIn.func_184586_b(handIn).func_190916_E()));
        }
        if (!worldIn.field_72995_K && playerIn.func_184586_b(handIn).func_77942_o()) {
            ItemStack stack;
            ItemExtremePattern.setOredict(stack, !ItemExtremePattern.isOredict(stack = playerIn.func_184586_b(handIn)));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)playerIn.func_184586_b(handIn));
    }

    @Nonnull
    public ICraftingPattern create(World world, ItemStack stack, ICraftingPatternContainer container) {
        return new ExtremePattern(world, container, stack);
    }
}

