/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.world;

import com.creativemd.creativecore.common.utils.math.vec.IVecOrigin;
import com.creativemd.creativecore.common.world.ChunkProviderFake;
import com.creativemd.creativecore.common.world.IFakeWorld;
import com.creativemd.creativecore.common.world.SaveHandlerFake;
import com.creativemd.creativecore.common.world.WorldFakeServer;
import javax.vecmath.Vector3d;
import net.minecraft.entity.Entity;
import net.minecraft.profiler.Profiler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.storage.ISaveHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class WorldFake
extends World
implements IFakeWorld {
    public Entity parent;
    public final World parentWorld;
    public IVecOrigin origin;
    @SideOnly(value=Side.CLIENT)
    public boolean shouldRender;

    public static WorldFake createFakeWorld(World world) {
        if (world instanceof WorldServer) {
            return new WorldFakeServer((WorldServer)world);
        }
        return new WorldFake(world);
    }

    protected WorldFake(World world) {
        super((ISaveHandler)new SaveHandlerFake(world.func_72912_H()), world.func_72912_H(), world.field_73011_w, new Profiler(), world.field_72995_K);
        this.field_73020_y = this.func_72970_h();
        this.parentWorld = world;
    }

    public MinecraftServer func_73046_m() {
        return this.parentWorld.func_73046_m();
    }

    protected IChunkProvider func_72970_h() {
        return new ChunkProviderFake(this, this.field_73019_z.func_75763_a(this.field_73011_w), this.field_73011_w.func_186060_c());
    }

    protected boolean func_175680_a(int x, int z, boolean allowEmpty) {
        return ((ChunkProviderFake)this.func_72863_F()).chunkExists(x, z);
    }

    public void func_175688_a(EnumParticleTypes particleType, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e(), xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    public void func_190523_a(int p_190523_1_, double p_190523_2_, double p_190523_4_, double p_190523_6_, double p_190523_8_, double p_190523_10_, double p_190523_12_, int ... p_190523_14_) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            Vector3d pos = new Vector3d(p_190523_2_, p_190523_4_, p_190523_6_);
            this.origin.transformPointToWorld(pos);
            ((IWorldEventListener)this.field_73021_x.get(i)).func_190570_a(p_190523_1_, false, true, pos.x, pos.y, pos.z, p_190523_8_, p_190523_10_, p_190523_12_, p_190523_14_);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_175682_a(EnumParticleTypes particleType, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        this.spawnParticle(particleType.func_179348_c(), particleType.func_179344_e() || ignoreRange, xCoord, yCoord, zCoord, xSpeed, ySpeed, zSpeed, parameters);
    }

    private void spawnParticle(int particleID, boolean ignoreRange, double xCoord, double yCoord, double zCoord, double xSpeed, double ySpeed, double zSpeed, int ... parameters) {
        for (int i = 0; i < this.field_73021_x.size(); ++i) {
            Vector3d pos = new Vector3d(xCoord, yCoord, zCoord);
            this.origin.transformPointToWorld(pos);
            ((IWorldEventListener)this.field_73021_x.get(i)).func_180442_a(particleID, ignoreRange, pos.x, pos.y, pos.z, xSpeed, ySpeed, zSpeed, parameters);
        }
    }

    @Override
    public IVecOrigin getOrigin() {
        return this.origin;
    }

    @Override
    public void setOrigin(IVecOrigin origin) {
        this.origin = origin;
    }
}

