/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.common.utils.math;

import com.creativemd.creativecore.common.collision.CreativeAxisAlignedBB;
import com.creativemd.creativecore.common.utils.math.BoxUtils;
import com.creativemd.creativecore.common.utils.math.MatrixUtils;
import com.creativemd.creativecore.common.utils.math.RotationUtils;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class CollidingPlane {
    public final CreativeAxisAlignedBB bb;
    public final EnumFacing.Axis axis;
    public final PlaneCache cache;
    protected final Vector3d origin;
    protected final Vector3d normal;
    public static final int accuracySteps = 10;
    private static BoxUtils.BoxCorner[][] planesForAxis = new BoxUtils.BoxCorner[][]{{BoxUtils.BoxCorner.EUS, BoxUtils.BoxCorner.EDN, BoxUtils.BoxCorner.WUS, BoxUtils.BoxCorner.WDN}, {BoxUtils.BoxCorner.EDS, BoxUtils.BoxCorner.EUN, BoxUtils.BoxCorner.WDS, BoxUtils.BoxCorner.WUN}, {BoxUtils.BoxCorner.EUS, BoxUtils.BoxCorner.WUN, BoxUtils.BoxCorner.EDS, BoxUtils.BoxCorner.WDN}, {BoxUtils.BoxCorner.EUN, BoxUtils.BoxCorner.WUS, BoxUtils.BoxCorner.EDN, BoxUtils.BoxCorner.WDS}, {BoxUtils.BoxCorner.EUS, BoxUtils.BoxCorner.WDS, BoxUtils.BoxCorner.EUN, BoxUtils.BoxCorner.WDN}, {BoxUtils.BoxCorner.WUS, BoxUtils.BoxCorner.EDS, BoxUtils.BoxCorner.WUN, BoxUtils.BoxCorner.EDN}};
    private static EnumFacing[][] faceCache;

    public CollidingPlane(CreativeAxisAlignedBB bb, EnumFacing.Axis axis, PlaneCache cache, Vector3d[] corners, BoxUtils.BoxCorner[] planeCorners) {
        this.bb = bb;
        this.axis = axis;
        this.cache = cache;
        this.origin = corners[planeCorners[0].ordinal()];
        Vector3d first = corners[planeCorners[1].ordinal()];
        Vector3d second = corners[planeCorners[2].ordinal()];
        first.sub((Tuple3d)this.origin);
        second.sub((Tuple3d)this.origin);
        this.normal = new Vector3d(first.y * second.z - first.z * second.y, first.z * second.x - first.x * second.z, first.x * second.y - first.y * second.x);
    }

    public Boolean isInFront(Vector3d vec) {
        double scalar = (vec.x - this.origin.x) * this.normal.x + (vec.y - this.origin.y) * this.normal.y + (vec.z - this.origin.z) * this.normal.z;
        if (scalar > 0.0) {
            return true;
        }
        if (scalar < 0.0) {
            return false;
        }
        return null;
    }

    public Double binarySearch(@Nullable Double value, AxisAlignedBB toCheck, double checkRadiusSquared, Vector3d center, MatrixUtils.MatrixLookupTable table) {
        if (table.isSimple) {
            Double t = this.searchBetweenSimple(value, toCheck, center, new Vector3d(center), new Vector3d(), 0.0, 1.0, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            return null;
        }
        if (table.hasOneRotation && !table.hasTranslation) {
            Vector3d start = new Vector3d(center);
            Vector3d temp = new Vector3d();
            int halfRotations = table.getNumberOfHalfRotations();
            double halfRotationSize = 1.0 / (double)halfRotations;
            Double t = this.searchBetweenSimple(value, toCheck, center, start, temp, 0.0, halfRotationSize, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            start.set((Tuple3d)center);
            table.transformInverted(start, halfRotationSize);
            t = this.searchBetweenSimple(value, toCheck, center, new Vector3d(center), temp, halfRotationSize, halfRotationSize * 2.0, table, 0);
            if (t != null && this.intersects(toCheck, checkRadiusSquared, center, t, table)) {
                return t;
            }
            return null;
        }
        Vector3d start = new Vector3d(center);
        Vector3d temp = new Vector3d();
        int halfRotations = table.getNumberOfHalfRotations();
        double halfRotationSize = 1.0 / (double)halfRotations;
        for (int i = 0; i < halfRotations; ++i) {
            double startT = halfRotationSize * (double)i;
            double endT = halfRotationSize * (double)(i + 1);
            if (startT != 0.0) {
                start.set((Tuple3d)center);
                table.transformInverted(start, startT);
            }
            if (value <= startT) {
                return null;
            }
            Double t = this.searchBetweenSimple(value, toCheck, center, start, temp, startT, endT, table, 0);
            if (t == null || !this.intersects(toCheck, checkRadiusSquared, center, t, table)) continue;
            return t;
        }
        return null;
    }

    protected Double searchBetweenSimple(@Nullable Double value, AxisAlignedBB toCheck, Vector3d center, Vector3d start, Vector3d temp, double startT, double endT, MatrixUtils.MatrixLookupTable table, int steps) {
        if (value != null && value < startT) {
            return null;
        }
        Boolean beforeFront = this.isInFront(start);
        if (beforeFront == null) {
            return startT;
        }
        temp.set((Tuple3d)center);
        table.transformInverted(temp, endT);
        Boolean afterFront = this.isInFront(temp);
        if (afterFront == null) {
            return endT;
        }
        if (beforeFront != afterFront) {
            if (steps < 10) {
                ++steps;
                double halfT = (startT + endT) / 2.0;
                temp.set((Tuple3d)center);
                table.transformInverted(temp, halfT);
                Boolean halfFront = this.isInFront(temp);
                if (halfFront == null) {
                    return halfT;
                }
                if (beforeFront != halfFront) {
                    return this.searchBetweenSimple(value, toCheck, center, start, temp, startT, halfT, table, steps);
                }
                return this.searchBetweenSimple(value, toCheck, center, temp, start, halfT, endT, table, steps);
            }
            return startT;
        }
        return null;
    }

    public boolean intersects(AxisAlignedBB toCheck, double checkRadiusSquared, Vector3d center, double t, MatrixUtils.MatrixLookupTable table) {
        if (this.bb.contains(center)) {
            return true;
        }
        Vector3d temp = new Vector3d(center);
        temp.sub((Tuple3d)this.cache.center);
        if (temp.lengthSquared() >= checkRadiusSquared + this.cache.radiusSquared) {
            return false;
        }
        Matrix4d matrix = table.getInverted(t);
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double minZ = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        double maxZ = -1.7976931348623157E308;
        for (int i = 0; i < BoxUtils.BoxCorner.values().length; ++i) {
            Vector3d corner = BoxUtils.BoxCorner.values()[i].getVector(toCheck);
            corner.sub((Tuple3d)table.origin.translation());
            corner.sub((Tuple3d)table.rotationCenter);
            table.origin.rotationInv().transform((Tuple3d)corner);
            corner.add((Tuple3d)table.rotationCenter);
            MatrixUtils.MatrixLookupTable.transform(matrix, table.rotationCenter, corner);
            if (this.bb.contains(corner)) {
                return true;
            }
            minX = Math.min(minX, corner.x);
            minY = Math.min(minY, corner.y);
            minZ = Math.min(minZ, corner.z);
            maxX = Math.max(maxX, corner.x);
            maxY = Math.max(maxY, corner.y);
            maxZ = Math.max(maxZ, corner.z);
        }
        return this.bb.func_186668_a(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public static CollidingPlane[] getPlanes(CreativeAxisAlignedBB box, PlaneCache cache, MatrixUtils.MatrixLookupTable table) {
        Vector3d[] corners = BoxUtils.getCorners(box);
        boolean needsX = table.hasRotX;
        boolean needsY = table.hasRotY;
        boolean needsZ = table.hasRotZ;
        if (table.hasX && !needsY && !needsZ) {
            needsY = true;
        }
        if (table.hasY && !needsX && !needsZ) {
            needsX = true;
        }
        if (table.hasZ && !needsX && !needsY) {
            needsX = true;
        }
        CollidingPlane[] planes = new CollidingPlane[(needsX ? 2 : 0) + (needsY ? 2 : 0) + (needsZ ? 2 : 0)];
        int index = 0;
        if (needsX) {
            CollidingPlane.setPlane(corners, planes, box, cache, EnumFacing.Axis.X, index);
            index += 2;
        }
        if (needsY) {
            CollidingPlane.setPlane(corners, planes, box, cache, EnumFacing.Axis.Y, index);
            index += 2;
        }
        if (needsZ) {
            CollidingPlane.setPlane(corners, planes, box, cache, EnumFacing.Axis.Z, index);
            index += 2;
        }
        return planes;
    }

    private static void setPlane(Vector3d[] corners, CollidingPlane[] planes, CreativeAxisAlignedBB box, PlaneCache cache, EnumFacing.Axis axis, int index) {
        planes[index] = new CollidingPlane(box, axis, cache, corners, planesForAxis[axis.ordinal() * 2]);
        planes[index + 1] = new CollidingPlane(box, axis, cache, corners, planesForAxis[axis.ordinal() * 2 + 1]);
    }

    private static EnumFacing getFacing(CollidingPlane first, CollidingPlane second, Vector3d relativeVec) {
        Boolean firstInFront = first.isInFront(relativeVec);
        if (firstInFront == null) {
            return null;
        }
        Boolean secondInFront = second.isInFront(relativeVec);
        if (secondInFront == null) {
            return null;
        }
        int index = firstInFront.booleanValue() ? (secondInFront.booleanValue() ? 3 : 1) : (secondInFront != false ? 2 : 0);
        return faceCache[first.axis.ordinal()][index];
    }

    public static EnumFacing getDirection(CollidingPlane[] planes, Vector3d origin, Vector3d center) {
        EnumFacing facing = CollidingPlane.getFacing(planes[0], planes[1], center);
        if (facing == null) {
            return null;
        }
        if (planes.length == 2 || facing.func_176740_k() == EnumFacing.Axis.X) {
            return facing;
        }
        if (planes[2].axis == facing.func_176740_k()) {
            return CollidingPlane.getFacing(planes[2], planes[3], center);
        }
        if (planes.length > 4 && planes[4].axis == facing.func_176740_k()) {
            return CollidingPlane.getFacing(planes[4], planes[5], center);
        }
        return facing;
    }

    private static void buildCache() {
        AxisAlignedBB box = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        faceCache = new EnumFacing[3][];
        for (int i = 0; i < EnumFacing.Axis.values().length; ++i) {
            Vector3d[] corners = BoxUtils.getCorners(box);
            EnumFacing.Axis axis = EnumFacing.Axis.values()[i];
            EnumFacing.Axis one = RotationUtils.getDifferentAxisFirst(axis);
            EnumFacing.Axis two = RotationUtils.getDifferentAxisSecond(axis);
            CollidingPlane[] planes = new CollidingPlane[2];
            CollidingPlane.setPlane(corners, planes, null, null, axis, 0);
            EnumFacing[] cache = new EnumFacing[4];
            for (int j = 0; j < cache.length; ++j) {
                EnumFacing facing;
                int oneDirection = -1;
                int twoDirection = -1;
                switch (j) {
                    case 1: {
                        oneDirection = 1;
                        break;
                    }
                    case 2: {
                        twoDirection = 1;
                        break;
                    }
                    case 3: {
                        oneDirection = 1;
                        twoDirection = 1;
                    }
                }
                Vector3d normalFirst = new Vector3d(planes[0].normal);
                normalFirst.scale((double)oneDirection);
                Vector3d normalSecond = new Vector3d(planes[1].normal);
                normalSecond.scale((double)twoDirection);
                if (RotationUtils.get(one, (Tuple3d)normalFirst) == RotationUtils.get(one, (Tuple3d)normalSecond)) {
                    facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(RotationUtils.get(one, (Tuple3d)normalFirst) > 0.0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)one);
                } else if (RotationUtils.get(two, (Tuple3d)normalFirst) == RotationUtils.get(two, (Tuple3d)normalSecond)) {
                    facing = EnumFacing.func_181076_a((EnumFacing.AxisDirection)(RotationUtils.get(two, (Tuple3d)normalFirst) > 0.0 ? EnumFacing.AxisDirection.POSITIVE : EnumFacing.AxisDirection.NEGATIVE), (EnumFacing.Axis)two);
                } else {
                    throw new RuntimeException("This cannot happen!");
                }
                cache[j] = facing;
            }
            CollidingPlane.faceCache[i] = cache;
        }
    }

    static {
        CollidingPlane.buildCache();
    }

    public static class PushCache {
        public CreativeAxisAlignedBB pushBox;
        public EnumFacing facing;
        public AxisAlignedBB entityBox;
    }

    public static class PlaneCache {
        public CollidingPlane[] planes;
        public final Vector3d center;
        public final double radiusSquared;

        public PlaneCache(AxisAlignedBB box) {
            this.radiusSquared = (box.field_72340_a * box.field_72336_d + box.field_72338_b * box.field_72337_e + box.field_72339_c * box.field_72334_f) * 0.5;
            this.center = new Vector3d(box.field_72340_a + (box.field_72336_d - box.field_72340_a) * 0.5, box.field_72338_b + (box.field_72337_e - box.field_72338_b) * 0.5, box.field_72339_c + (box.field_72334_f - box.field_72339_c) * 0.5);
        }

        public boolean isCached() {
            return this.planes != null;
        }

        public void reset() {
            this.planes = null;
        }
    }
}

