/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.creativecore.client.rendering.model;

import com.creativemd.creativecore.client.rendering.model.CreativeBakedQuad;
import com.creativemd.creativecore.client.rendering.model.CreativeConsumer;
import com.creativemd.creativecore.client.rendering.model.ICustomCachedCreativeRendered;
import com.creativemd.creativecore.client.rendering.model.QuadCache;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.pipeline.BlockInfo;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.LightUtil;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;
import net.minecraftforge.client.model.pipeline.VertexLighterFlat;
import net.minecraftforge.client.model.pipeline.VertexLighterSmoothAo;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class CreativeBakedQuadCaching
extends CreativeBakedQuad {
    public ICustomCachedCreativeRendered cacher;
    public List<BakedQuad> quads;
    public TileEntity te;
    public ItemStack stack;
    public BlockRenderLayer layer;

    public CreativeBakedQuadCaching(List<BakedQuad> quads, EnumFacing facing, ICustomCachedCreativeRendered cacher, TileEntity te, ItemStack stack, BlockRenderLayer layer) {
        super(facing);
        this.quads = quads;
        this.cacher = cacher;
        this.te = te;
        this.stack = stack;
        this.layer = layer;
    }

    @Override
    public void pipe(IVertexConsumer consumer) {
        if (consumer instanceof VertexLighterSmoothAo) {
            VertexLighterSmoothAo smooth = (VertexLighterSmoothAo)consumer;
            IVertexConsumer parent = (IVertexConsumer)ReflectionHelper.getPrivateValue(QuadGatheringTransformer.class, (Object)smooth, (String[])new String[]{"parent"});
            CreativeConsumer cc = CreativeConsumer.instance;
            QuadCache[] cached = this.cacher.getCustomCachedQuads(this.layer, this.field_178214_c, this.te, this.stack);
            if (cached != null) {
                CreativeConsumer.processCachedQuad(parent, cached);
            } else {
                BlockInfo info = (BlockInfo)ReflectionHelper.getPrivateValue(VertexLighterFlat.class, (Object)smooth, (String[])new String[]{"blockInfo"});
                cc = new CreativeConsumer(Minecraft.func_71410_x().func_184125_al());
                cc.setParent(parent);
                cc.blockInfo = info;
                cached = new QuadCache[this.quads.size()];
                for (int i = 0; i < this.quads.size(); ++i) {
                    BakedQuad quad = this.quads.get(i);
                    lastRenderedQuad = (CreativeBakedQuad)quad;
                    cc.state = ((CreativeBakedQuad)quad).cube.getBlockState();
                    cc.shouldOverrideColor = ((CreativeBakedQuad)quad).shouldOverrideColor;
                    try {
                        LightUtil.putBakedQuad((IVertexConsumer)cc, (BakedQuad)quad);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cc.state = null;
                    cached[i] = cc.lastCache;
                    lastRenderedQuad = null;
                }
                this.cacher.saveCachedQuads(cached, this.layer, this.field_178214_c, this.te, this.stack);
            }
        } else {
            super.pipe(consumer);
        }
    }
}

