/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.recipes.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class ShapelessRecipeBuilder {
    protected NonNullList<ItemStack[]> inputs = NonNullList.func_191196_a();
    protected NonNullList<Integer> stay = NonNullList.func_191196_a();
    protected Map<Integer, ItemStack> rets = new HashMap<Integer, ItemStack>();
    protected ItemStack output = ItemStack.field_190927_a;

    public static ShapelessRecipeBuilder builder() {
        return new ShapelessRecipeBuilder();
    }

    public ShapelessRecipeBuilder output(ItemStack stack) {
        this.output = stack.func_77946_l();
        return this;
    }

    public BuildableIngredient input() {
        return new BuildableIngredient(this);
    }

    public IRecipe build() {
        NonNullList ings = NonNullList.func_191197_a((int)this.inputs.size(), (Object)Ingredient.field_193370_a);
        NonNullList stay = NonNullList.func_191197_a((int)this.inputs.size(), (Object)Ingredient.field_193370_a);
        HashMap<Ingredient, ItemStack> returns = new HashMap<Ingredient, ItemStack>();
        for (int i = 0; i < ings.size(); ++i) {
            Ingredient ing = Ingredient.func_193369_a((ItemStack[])((ItemStack[])this.inputs.get(i)));
            ings.set(i, (Object)ing);
            if (!this.stay.contains((Object)i)) continue;
            stay.set(i, (Object)ing);
            if (!this.rets.containsKey(i)) continue;
            returns.put(ing, this.rets.get(i));
        }
        return this.bake((NonNullList<Ingredient>)ings, (NonNullList<Ingredient>)stay, returns);
    }

    protected IRecipe bake(NonNullList<Ingredient> ings, NonNullList<Ingredient> stay, Map<Ingredient, ItemStack> returns) {
        return new BakedShapelessRecipe(this, this.output, ings, stay, returns);
    }

    protected static class BakedShapelessRecipe
    extends ShapelessRecipes {
        private final ShapelessRecipeBuilder builder;
        private final NonNullList<Ingredient> stay;
        private final Map<Ingredient, ItemStack> returns;

        public BakedShapelessRecipe(ShapelessRecipeBuilder builder, ItemStack output, NonNullList<Ingredient> ingredients, NonNullList<Ingredient> stay, Map<Ingredient, ItemStack> returns) {
            super("", output, ingredients);
            this.returns = returns;
            this.builder = builder;
            this.stay = stay;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList its = super.func_179532_b(inv);
            block0: for (int i = 0; i < its.size(); ++i) {
                ItemStack it = inv.func_70301_a(i);
                for (Ingredient ing : this.stay) {
                    if (!ing.apply(it)) continue;
                    if (this.returns.containsKey(ing)) {
                        ItemStack ret = this.returns.get(ing);
                        if (ret == null) continue block0;
                        ret = ret.func_77946_l();
                        ret.func_190920_e(it.func_190916_E() * ret.func_190916_E());
                        its.set(i, (Object)ret);
                        continue block0;
                    }
                    its.set(i, (Object)it.func_77946_l());
                    continue block0;
                }
            }
            return its;
        }
    }

    public static class BuildableIngredient {
        final ShapelessRecipeBuilder builder;
        Collection<ItemStack> inputs = new ArrayList<ItemStack>();
        ItemStack returns;
        boolean stay;

        public BuildableIngredient(ShapelessRecipeBuilder builder) {
            this.builder = builder;
        }

        public BuildableIngredient addItem(ItemStack stack) {
            this.inputs.add(stack.func_77946_l());
            return this;
        }

        public BuildableIngredient addItems(Collection<ItemStack> stacks) {
            stacks.stream().filter(i -> i != null).forEach(this::addItem);
            return this;
        }

        public BuildableIngredient addOreDict(String od) {
            return this.addItems((Collection<ItemStack>)OreDictionary.getOres((String)od));
        }

        public BuildableIngredient stay() {
            this.stay = true;
            return this;
        }

        public BuildableIngredient withReturn(ItemStack it) {
            this.returns = it;
            return this;
        }

        public ShapelessRecipeBuilder build() {
            if (!this.inputs.isEmpty()) {
                if (this.stay || this.returns != null) {
                    int i = this.builder.inputs.size();
                    this.builder.stay.add((Object)i);
                    if (this.returns != null) {
                        this.builder.rets.put(i, this.returns);
                    }
                }
                this.builder.inputs.add((Object)this.inputs.toArray(new ItemStack[this.inputs.size()]));
            }
            return this.builder;
        }
    }
}

