/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.utils.inventory;

import com.zeitheron.hammercore.utils.InterItemStack;
import com.zeitheron.hammercore.utils.WorldUtil;
import com.zeitheron.hammercore.utils.inventory.IInventoryListener;
import com.zeitheron.hammercore.utils.inventory.ISlotPredicate;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;

public class InventoryDummy
implements IInventory {
    public IInventoryListener listener;
    public NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
    private final int[] allSlots;
    public int inventoryStackLimit = 64;
    public ISlotPredicate validSlots = (i, stack) -> true;
    public NBTTagCompound boundCompound = new NBTTagCompound();

    public InventoryDummy(int inventorySize, NBTTagCompound boundNBT) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.allSlots = new int[this.inventory.size()];
        for (int i2 = 0; i2 < this.allSlots.length; ++i2) {
            this.allSlots[i2] = i2;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryDummy(NBTTagCompound boundNBT, ItemStack ... items) {
        int i2;
        this.inventory = NonNullList.func_191197_a((int)items.length, (Object)ItemStack.field_190927_a);
        for (i2 = 0; i2 < items.length; ++i2) {
            this.inventory.set(i2, (Object)items[i2]);
        }
        this.allSlots = new int[items.length];
        for (i2 = 0; i2 < this.allSlots.length; ++i2) {
            this.allSlots[i2] = i2;
        }
        this.boundCompound = boundNBT;
    }

    public InventoryDummy(int inventorySize) {
        this.inventory = NonNullList.func_191197_a((int)inventorySize, (Object)ItemStack.field_190927_a);
        this.allSlots = new int[inventorySize];
        for (int i2 = 0; i2 < this.allSlots.length; ++i2) {
            this.allSlots[i2] = i2;
        }
    }

    public InventoryDummy(ItemStack ... items) {
        int i2;
        this.inventory = NonNullList.func_191197_a((int)items.length, (Object)ItemStack.field_190927_a);
        for (i2 = 0; i2 < items.length; ++i2) {
            this.inventory.set(i2, (Object)items[i2]);
        }
        this.allSlots = new int[items.length];
        for (i2 = 0; i2 < this.allSlots.length; ++i2) {
            this.allSlots[i2] = i2;
        }
    }

    public int[] getAllAvaliableSlots() {
        return this.allSlots;
    }

    public String func_70005_c_() {
        return "Dummy Inventory";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public ItemStack func_70301_a(int index) {
        try {
            return (ItemStack)this.inventory.get(index);
        }
        catch (Throwable throwable) {
            return InterItemStack.NULL_STACK;
        }
    }

    public ItemStack func_70298_a(int slot, int count) {
        try {
            if (!((ItemStack)this.inventory.get(slot)).func_190926_b()) {
                if (((ItemStack)this.inventory.get(slot)).func_190916_E() <= count) {
                    ItemStack is = (ItemStack)this.inventory.get(slot);
                    this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                    if (this.listener != null) {
                        this.listener.slotChange(count, (ItemStack)this.inventory.get(slot));
                    }
                    return is;
                }
                ItemStack is = ((ItemStack)this.inventory.get(slot)).func_77979_a(count);
                if (((ItemStack)this.inventory.get(slot)).func_190916_E() == 0) {
                    this.inventory.set(slot, (Object)ItemStack.field_190927_a);
                }
                if (this.listener != null) {
                    this.listener.slotChange(count, (ItemStack)this.inventory.get(slot));
                }
                return is;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return ItemStack.field_190927_a;
    }

    public void func_70299_a(int index, ItemStack stack) {
        try {
            this.inventory.set(index, (Object)stack);
            if (this.listener != null) {
                this.listener.slotChange(index, stack);
            }
            if (((ItemStack)this.inventory.get(index)).func_190916_E() > Math.min(((ItemStack)this.inventory.get(index)).func_77976_d(), this.func_70297_j_())) {
                ((ItemStack)this.inventory.get(index)).func_190920_e(Math.min(((ItemStack)this.inventory.get(index)).func_77976_d(), this.func_70297_j_()));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int func_70297_j_() {
        return this.inventoryStackLimit;
    }

    public void func_70296_d() {
        this.writeToNBT();
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return this.validSlots.test(index, stack);
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventory.clear();
        if (this.listener != null) {
            for (int i = 0; i < this.inventory.size(); ++i) {
                this.listener.slotChange(i, (ItemStack)this.inventory.get(i));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            nbt.func_74768_a("InvSize", this.inventory.size());
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.inventory);
        }
        return nbt;
    }

    public void writeToNBT() {
        this.writeToNBT(this.boundCompound);
    }

    public InventoryDummy readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.inventory = NonNullList.func_191197_a((int)nbt.func_74762_e("InvSize"), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.inventory);
        }
        return this;
    }

    public void readFromNBT() {
        this.readFromNBT(this.boundCompound);
    }

    public ItemStack func_70304_b(int slot) {
        ItemStack s = this.func_70301_a(slot);
        this.func_70299_a(slot, null);
        if (this.listener != null) {
            this.listener.slotChange(slot, null);
        }
        return s;
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    public boolean isUsableByPlayer(EntityPlayer player, BlockPos from) {
        return player.func_174818_b(from) <= 64.0;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return false;
    }

    public void drop(World world, BlockPos pos) {
        InventoryDummy.drop(this, world, pos);
    }

    public static void drop(IInventory inv, World world, BlockPos pos) {
        if (inv == null || world == null || pos == null) {
            return;
        }
        if (!world.field_72995_K) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack s = inv.func_70301_a(i);
                if (InterItemStack.isStackNull(s)) continue;
                WorldUtil.spawnItemStack(world, pos, s);
            }
        }
        inv.func_174888_l();
    }
}

