/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.p2p;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.net.p2p.ITask;
import com.zeitheron.hammercore.utils.NBTUtils;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class PacketSendTaskUUID
implements IPacket {
    private NBTTagCompound task;
    private String sender;
    private UUID[] receivers;

    public PacketSendTaskUUID(ITask task, UUID ... receivers) {
        this.task = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        task.writeToNBT(tag);
        this.task.func_74782_a("Data", (NBTBase)tag);
        this.task.func_74778_a("Class", task.getClass().getName());
        this.sender = "?";
        this.receivers = receivers;
    }

    public PacketSendTaskUUID() {
    }

    @Override
    public IPacket executeOnServer(PacketContext net) {
        this.sender = net.getSender().func_146103_bH().getName();
        for (UUID $receiver : this.receivers) {
            EntityPlayerMP receiver = net.server.func_184103_al().func_177451_a($receiver);
            if (receiver == null) continue;
            HCNet.INSTANCE.sendTo(this, receiver);
        }
        return null;
    }

    @Override
    public IPacket executeOnClient(PacketContext net) {
        try {
            ITask task = (ITask)Class.forName(this.task.func_74779_i("Class")).newInstance();
            task.readFromNBT(this.task.func_74775_l("Data"));
            task.execute(net);
        }
        catch (Throwable err) {
            err.printStackTrace();
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74782_a("Task", (NBTBase)this.task);
        nbt.func_74778_a("Sen", this.sender);
        NBTUtils.writeUUIDArrayToNBT("Rec", nbt, this.receivers);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.task = nbt.func_74775_l("Task");
        this.sender = nbt.func_74779_i("Sen");
        this.receivers = NBTUtils.readUUIDArrayFromNBT("Rec", nbt);
    }

    static {
        IPacket.handle(PacketSendTaskUUID.class, () -> new PacketSendTaskUUID());
    }
}

