/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net.internal;

import com.zeitheron.hammercore.net.IPacket;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.utils.WorldUtil;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;

@MainThreaded
public class PacketTeleportPlayer
implements IPacket {
    Vec3d target;
    Integer dimension;

    public PacketTeleportPlayer withTarget(Vec3d target) {
        this.target = target;
        return this;
    }

    public PacketTeleportPlayer withDimension(int dimension) {
        this.dimension = dimension;
        return this;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        IPacket.Helper.setVec3d(nbt, "Target", this.target);
        if (this.dimension != null) {
            nbt.func_74768_a("Dim", this.dimension.intValue());
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.target = IPacket.Helper.getVec3d(nbt, "Target");
        if (nbt.func_150297_b("Dim", 3)) {
            this.dimension = nbt.func_74762_e("Dim");
        }
    }

    @Override
    public IPacket executeOnServer(PacketContext net) {
        EntityPlayerMP mp = net.getSender();
        if (mp == null) {
            return null;
        }
        WorldUtil.teleportPlayer(mp, this.dimension != null ? this.dimension.intValue() : mp.field_70170_p.field_73011_w.getDimension(), this.target.field_72450_a, this.target.field_72448_b, this.target.field_72449_c);
        return null;
    }

    static {
        IPacket.handle(PacketTeleportPlayer.class, PacketTeleportPlayer::new);
    }
}

