/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.net;

import com.zeitheron.hammercore.net.HCNet;
import com.zeitheron.hammercore.net.MainThreaded;
import com.zeitheron.hammercore.net.PacketContext;
import com.zeitheron.hammercore.utils.NPEUtils;
import java.util.function.Supplier;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IPacket {
    default public void readFromNBT(NBTTagCompound nbt) {
    }

    default public void writeToNBT(NBTTagCompound nbt) {
    }

    default public IPacket execute(Side side, PacketContext ctx) {
        if (side == Side.CLIENT) {
            return this.executeOnClient(ctx);
        }
        return this.executeOnServer(ctx);
    }

    default public boolean refractSidedToUniversal() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    default public IPacket executeOnClient(PacketContext net) {
        return this.refractSidedToUniversal() ? this.execute(Side.CLIENT, net) : null;
    }

    default public IPacket executeOnServer(PacketContext net) {
        return this.refractSidedToUniversal() ? this.execute(Side.SERVER, net) : null;
    }

    default public boolean executeOnMainThread() {
        MainThreaded mt = this.getClass().getAnnotation(MainThreaded.class);
        if (mt == null) {
            mt = this.getClass().getDeclaredAnnotation(MainThreaded.class);
        }
        return mt != null && mt.value();
    }

    public static <T extends IPacket> void handle(Class<T> t, Supplier<T> nev) {
        HCNet.INSTANCE.handle(t, nev);
    }

    public static final class Helper {
        private Helper() {
            NPEUtils.noInstancesError();
        }

        public static Vec3d getVec3d(NBTTagCompound nbt, String key) {
            return new Vec3d((double)nbt.func_74760_g(key + "X"), (double)nbt.func_74760_g(key + "Y"), (double)nbt.func_74760_g(key + "Z"));
        }

        public static NBTTagCompound setVec3d(NBTTagCompound nbt, String key, Vec3d vec) {
            nbt.func_74776_a(key + "X", (float)vec.field_72450_a);
            nbt.func_74776_a(key + "Y", (float)vec.field_72448_b);
            nbt.func_74776_a(key + "Z", (float)vec.field_72449_c);
            return nbt;
        }
    }
}

