/*
 * Decompiled with CFR 0.152.
 */
package com.zeitheron.hammercore.client.witty;

import com.zeitheron.hammercore.lib.zlib.error.JSONException;
import com.zeitheron.hammercore.lib.zlib.io.IOUtils;
import com.zeitheron.hammercore.lib.zlib.json.JSONArray;
import com.zeitheron.hammercore.lib.zlib.json.JSONObject;
import com.zeitheron.hammercore.utils.ListUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;
import javax.annotation.Nullable;

public class DaylengthSplashes {
    public static final SimpleDateFormat DATE_PARSER = new SimpleDateFormat("dd.MM");
    public static final Random SELECT_RNG = new Random();
    private static final Map<Integer, List<String>> DAYLENGTH_SPLASHES = new HashMap<Integer, List<String>>();

    public static boolean addBirthdaySplash(String date, String splash) {
        try {
            Calendar c = new Calendar.Builder().setInstant(DATE_PARSER.parse(date)).setTimeZone(TimeZone.getDefault()).build();
            int doy = c.get(6);
            List<String> pos = DAYLENGTH_SPLASHES.get(doy);
            if (pos == null) {
                pos = new ArrayList<String>();
                DAYLENGTH_SPLASHES.put(doy, pos);
            }
            if (!pos.contains(splash)) {
                pos.add(splash);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Nullable
    public static String getDaylengthSplash() {
        List<String> potential = DAYLENGTH_SPLASHES.get(Calendar.getInstance().get(6));
        return potential != null ? ListUtils.random(potential, SELECT_RNG) : null;
    }

    static {
        try {
            JSONObject jobj = (JSONObject)IOUtils.downloadjsonOrLoadFromInternal("https://pastebin.com/raw/U8ZNkcLV", "/assets/hammercore/io/dlsplashes.json");
            for (String key : jobj.keySet()) {
                ArrayList<String> vals = new ArrayList<String>();
                Object v2 = jobj.opt(key);
                if (v2 instanceof String) {
                    vals.add((String)v2);
                }
                if (v2 instanceof JSONArray) {
                    JSONArray ja = (JSONArray)v2;
                    for (int i = 0; i < ja.length(); ++i) {
                        vals.add(ja.getString(i));
                    }
                }
                vals.forEach(v -> DaylengthSplashes.addBirthdaySplash(key, v));
            }
        }
        catch (JSONException | ClassCastException exception) {
            // empty catch block
        }
    }
}

