/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.function.IFunction;
import org.magicwerk.brownies.collections.helper.ArraysHelper;
import org.magicwerk.brownies.collections.primitive.ILongList;

public class LongGapList
extends ILongList {
    private static final boolean DEBUG_CHECK = false;
    private static final boolean DEBUG_TRACE = false;
    private static final boolean DEBUG_DUMP = false;
    private static long[] EMPTY_VALUES = new long[0];
    private static final LongGapList EMPTY = LongGapList.create().unmodifiableList();
    private static final long serialVersionUID = -4477005565661968383L;
    public static final int DEFAULT_CAPACITY = 10;
    private long[] values;
    private int size;
    private int start;
    private int end;
    private int gapSize;
    private int gapIndex;
    private int gapStart;

    public static LongGapList EMPTY() {
        return EMPTY;
    }

    public static LongGapList create() {
        return new LongGapList();
    }

    public static LongGapList create(Collection<Long> coll) {
        return new LongGapList(coll);
    }

    public static LongGapList create(long ... elems) {
        LongGapList list2 = new LongGapList();
        list2.init(elems);
        return list2;
    }

    private final int physIndex(int idx) {
        int physIdx = idx + this.start;
        if (idx >= this.gapIndex) {
            physIdx += this.gapSize;
        }
        if (physIdx >= this.values.length) {
            physIdx -= this.values.length;
        }
        return physIdx;
    }

    private int[] physIndex(int idx0, int idx1) {
        assert (idx0 >= 0 && idx1 <= this.size && idx0 <= idx1);
        if (idx0 == idx1) {
            return new int[0];
        }
        int pidx0 = this.physIndex(idx0);
        if (--idx1 == idx0) {
            return new int[]{pidx0, pidx0 + 1};
        }
        int pidx1 = this.physIndex(idx1);
        if (pidx0 < pidx1) {
            if (this.gapSize > 0 && pidx0 < this.gapStart && pidx1 > this.gapStart) {
                assert (pidx0 < this.gapStart);
                assert (this.gapStart + this.gapSize < pidx1 + 1);
                return new int[]{pidx0, this.gapStart, this.gapStart + this.gapSize, pidx1 + 1};
            }
            return new int[]{pidx0, pidx1 + 1};
        }
        assert (pidx0 > pidx1);
        assert (this.start != 0);
        if (this.gapSize > 0 && pidx1 > this.gapStart && this.gapStart > 0) {
            assert (pidx0 < this.values.length);
            assert (0 < this.gapStart);
            assert (this.gapStart + this.gapSize < pidx1 + 1);
            return new int[]{pidx0, this.values.length, 0, this.gapStart, this.gapStart + this.gapSize, pidx1 + 1};
        }
        if (this.gapSize > 0 && pidx0 < this.gapStart && this.gapStart + this.gapSize < this.values.length) {
            assert (pidx0 < this.gapStart);
            assert (this.gapStart + this.gapSize < this.values.length);
            assert (0 < pidx1 + 1);
            return new int[]{pidx0, this.gapStart, this.gapStart + this.gapSize, this.values.length, 0, pidx1 + 1};
        }
        assert (pidx0 < this.values.length);
        assert (0 < pidx1 + 1);
        int end = this.values.length;
        if (this.gapSize > 0 && this.gapStart > pidx0) {
            end = this.gapStart;
        }
        int start = 0;
        if (this.gapSize > 0 && (this.gapStart + this.gapSize) % this.values.length < pidx1 + 1) {
            start = (this.gapStart + this.gapSize) % this.values.length;
        }
        return new int[]{pidx0, end, start, pidx1 + 1};
    }

    @Override
    protected void doAssign(ILongList that) {
        LongGapList list2 = (LongGapList)that;
        this.values = list2.values;
        this.size = list2.size;
        this.start = list2.start;
        this.end = list2.end;
        this.gapSize = list2.gapSize;
        this.gapIndex = list2.gapIndex;
        this.gapStart = list2.gapStart;
    }

    protected LongGapList(boolean copy, LongGapList that) {
        if (copy) {
            this.doAssign(that);
        }
    }

    public LongGapList() {
        this.init();
    }

    public LongGapList(int capacity) {
        this.init(new long[capacity], 0);
    }

    public LongGapList(Collection<Long> coll) {
        this.init(coll);
    }

    public void init() {
        this.init(EMPTY_VALUES, 0);
    }

    public void init(Collection<Long> coll) {
        long[] array = LongGapList.toArray(coll);
        this.init(array, array.length);
    }

    public void init(long ... elems) {
        long[] array = (long[])elems.clone();
        this.init(array, array.length);
    }

    @Override
    public long getDefaultElem() {
        return 0L;
    }

    @Override
    public LongGapList copy() {
        return (LongGapList)super.copy();
    }

    @Override
    public void ensureCapacity(int minCapacity) {
        super.ensureCapacity(minCapacity);
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    public LongGapList unmodifiableList() {
        return new ImmutableLongGapList(this);
    }

    @Override
    protected void doClone(ILongList that) {
        this.init(that.toArray(), that.size());
    }

    private void normalize() {
        if (this.start == 0 && this.end == 0 && this.gapSize == 0 && this.gapStart == 0 && this.gapIndex == 0) {
            return;
        }
        this.init(this.toArray(), this.size());
    }

    void init(long[] values2, int size2) {
        this.values = values2;
        this.size = size2;
        this.start = 0;
        this.end = 0;
        this.gapSize = 0;
        this.gapStart = 0;
        this.gapIndex = 0;
    }

    @Override
    protected void doClear() {
        this.init(this.values, 0);
        for (int i = 0; i < this.values.length; ++i) {
            this.values[i] = 0L;
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return this.values.length;
    }

    @Override
    public long get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Invalid index: " + index + " (size: " + this.size() + ")");
        }
        return this.doGet(index);
    }

    @Override
    protected long doGet(int index) {
        assert (index >= 0 && index < this.size);
        int physIdx = index + this.start;
        if (index >= this.gapIndex) {
            physIdx += this.gapSize;
        }
        if (physIdx >= this.values.length) {
            physIdx -= this.values.length;
        }
        return this.values[physIdx];
    }

    @Override
    protected long doSet(int index, long elem) {
        assert (index >= 0 && index < this.size);
        int physIdx = this.physIndex(index);
        long oldElem = this.values[physIdx];
        this.values[physIdx] = elem;
        return oldElem;
    }

    @Override
    protected long doReSet(int index, long elem) {
        assert (index >= 0 && index < this.size);
        int physIdx = this.physIndex(index);
        long oldElem = this.values[physIdx];
        this.values[physIdx] = elem;
        return oldElem;
    }

    @Override
    public boolean add(long elem) {
        return this.doAdd(-1, elem);
    }

    @Override
    public void add(int index, long elem) {
        this.checkIndexAdd(index);
        this.doAdd(index, elem);
    }

    @Override
    public LongGapList getAll(int index, int len2) {
        return (LongGapList)super.getAll(index, len2);
    }

    @Override
    public LongGapList getAll(long elem) {
        return (LongGapList)super.getAll(elem);
    }

    public <R> GapList<R> mappedList(IFunction<Long, R> mapper) {
        return (GapList)super.mappedList(mapper);
    }

    @Override
    protected boolean doAdd(int index, long elem) {
        int physIdx;
        this.doEnsureCapacity(this.size + 1);
        if (index == -1) {
            index = this.size;
        }
        assert (index >= 0 && index <= this.size);
        if (index == this.size && (this.end != this.start || this.size == 0)) {
            physIdx = this.end++;
            if (this.end >= this.values.length) {
                this.end -= this.values.length;
            }
        } else if (index == 0 && (this.end != this.start || this.size == 0)) {
            --this.start;
            if (this.start < 0) {
                this.start += this.values.length;
            }
            physIdx = this.start;
            if (this.gapSize > 0) {
                ++this.gapIndex;
            }
        } else if (this.gapSize > 0 && index == this.gapIndex) {
            physIdx = this.gapStart + this.gapSize - 1;
            if (physIdx >= this.values.length) {
                physIdx -= this.values.length;
            }
            --this.gapSize;
        } else {
            physIdx = this.physIndex(index);
            if (this.gapSize == 0) {
                if (this.start < this.end && this.start > 0) {
                    assert (this.debugState() == 4);
                    int len1 = physIdx - this.start;
                    int len2 = this.end - physIdx;
                    if (len1 <= len2) {
                        this.moveData(this.start, 0, len1);
                        this.gapSize = this.start - 1;
                        this.gapStart = len1;
                        this.gapIndex = len1;
                        this.start = 0;
                        --physIdx;
                    } else {
                        this.moveData(physIdx, this.values.length - len2, len2);
                        this.gapSize = this.values.length - this.end - 1;
                        this.gapStart = physIdx + 1;
                        this.gapIndex = index + 1;
                        this.end = 0;
                    }
                } else if (physIdx < this.end) {
                    assert (this.debugState() == 2 || this.debugState() == 5);
                    int len2 = this.end - physIdx;
                    int rightSize = (this.start - this.end + this.values.length) % this.values.length;
                    this.moveData(physIdx, this.end + rightSize - len2, len2);
                    this.end = this.start;
                    this.gapSize = rightSize - 1;
                    this.gapStart = physIdx + 1;
                    this.gapIndex = index + 1;
                } else {
                    assert (this.debugState() == 3 || this.debugState() == 5);
                    assert (physIdx > this.end);
                    int len3 = physIdx - this.start;
                    int rightSize = this.start - this.end;
                    this.moveData(this.start, this.end, len3);
                    this.start -= rightSize;
                    this.end = this.start;
                    this.gapSize = rightSize - 1;
                    this.gapStart = this.start + len3;
                    this.gapIndex = index;
                    --physIdx;
                }
            } else {
                int dst;
                int src;
                boolean moveLeft;
                int gapEnd = (this.gapStart + this.gapSize - 1) % this.values.length + 1;
                if (gapEnd < this.gapStart) {
                    assert (this.debugState() == 9 || this.debugState() == 12);
                    int len1 = physIdx - gapEnd;
                    int len2 = this.gapStart - physIdx - 1;
                    moveLeft = len1 <= len2;
                } else {
                    assert (this.debugState() == 6 || this.debugState() == 7 || this.debugState() == 8 || this.debugState() == 9 || this.debugState() == 10 || this.debugState() == 11 || this.debugState() == 12 || this.debugState() == 13 || this.debugState() == 14 || this.debugState() == 15);
                    moveLeft = physIdx > this.gapStart;
                }
                if (moveLeft) {
                    src = this.gapStart + this.gapSize;
                    dst = this.gapStart;
                    int len4 = physIdx - gapEnd;
                    this.moveDataWithGap(src, dst, len4);
                    --physIdx;
                    --this.gapSize;
                    this.gapIndex = index;
                    this.gapStart += len4;
                    if (this.gapStart >= this.values.length) {
                        this.gapStart -= this.values.length;
                    }
                    if (index == 0) {
                        this.start = physIdx;
                        if ((this.gapStart + this.gapSize) % this.values.length == this.start) {
                            this.end = this.gapStart;
                            this.gapSize = 0;
                        }
                    }
                } else {
                    src = physIdx;
                    dst = physIdx + this.gapSize;
                    int len5 = this.gapStart - physIdx;
                    this.moveDataWithGap(src, dst, len5);
                    --this.gapSize;
                    this.gapStart = physIdx + 1;
                    this.gapIndex = index + 1;
                    if (index == 0) {
                        this.start = physIdx;
                        this.end = physIdx;
                    } else if (index == this.size && (this.gapStart + this.gapSize) % this.values.length == this.start) {
                        this.end = this.gapStart;
                        this.gapSize = 0;
                    }
                }
            }
        }
        this.values[physIdx] = elem;
        ++this.size;
        return true;
    }

    private void moveDataWithGap(int src, int dst, int len2) {
        if (src > this.values.length) {
            src -= this.values.length;
        }
        if (dst > this.values.length) {
            dst -= this.values.length;
        }
        assert (len2 >= 0);
        assert (src + len2 <= this.values.length);
        if (this.start >= src && this.start < src + len2) {
            this.start += dst - src;
            if (this.start >= this.values.length) {
                this.start -= this.values.length;
            }
        }
        if (this.end >= src && this.end < src + len2) {
            this.end += dst - src;
            if (this.end >= this.values.length) {
                this.end -= this.values.length;
            }
        }
        if (dst + len2 <= this.values.length) {
            this.moveData(src, dst, len2);
        } else {
            int len22 = dst + len2 - this.values.length;
            int len1 = len2 - len22;
            if (src > len22 || len22 >= dst) {
                this.moveData(src + len1, 0, len22);
                this.moveData(src, dst, len1);
            } else {
                this.moveData(src, dst, len1);
                this.moveData(src + len1, 0, len22);
            }
        }
    }

    private void moveData(int src, int dst, int len2) {
        int end;
        int start;
        System.arraycopy(this.values, src, this.values, dst, len2);
        if (src <= dst) {
            start = src;
            end = dst < src + len2 ? dst : src + len2;
        } else {
            start = src > dst + len2 ? src : dst + len2;
            end = src + len2;
        }
        assert (end - start <= len2);
        for (int i = start; i < end; ++i) {
            this.values[i] = 0L;
        }
    }

    @Override
    public long remove(int index) {
        this.checkIndex(index);
        return this.doRemove(index);
    }

    @Override
    protected long doRemove(int index) {
        int physIdx;
        if (index == this.size - 1) {
            --this.end;
            if (this.end < 0) {
                this.end += this.values.length;
            }
            physIdx = this.end;
            if (this.gapSize > 0 && this.gapIndex == index) {
                this.end = this.gapStart;
                this.gapSize = 0;
            }
        } else if (index == 0) {
            physIdx = this.start++;
            if (this.start >= this.values.length) {
                this.start -= this.values.length;
            }
            if (this.gapSize > 0) {
                if (this.gapIndex == 1) {
                    this.start += this.gapSize;
                    if (this.start >= this.values.length) {
                        this.start -= this.values.length;
                    }
                    this.gapSize = 0;
                } else {
                    --this.gapIndex;
                }
            }
        } else {
            physIdx = this.physIndex(index);
            if (this.gapSize == 0) {
                this.gapIndex = index;
                this.gapStart = physIdx;
                this.gapSize = 1;
            } else if (index == this.gapIndex) {
                ++this.gapSize;
            } else if (index == this.gapIndex - 1) {
                --this.gapStart;
                if (this.gapStart < 0) {
                    this.gapStart += this.values.length;
                }
                ++this.gapSize;
                --this.gapIndex;
            } else {
                int dst;
                int src;
                int len2;
                int len1;
                assert (this.gapSize > 0);
                int gapEnd = (this.gapStart + this.gapSize - 1) % this.values.length + 1;
                boolean moveLeft = gapEnd < this.gapStart ? (len1 = physIdx - gapEnd) <= (len2 = this.gapStart - physIdx - 1) : physIdx > this.gapStart;
                if (moveLeft) {
                    src = this.gapStart + this.gapSize;
                    dst = this.gapStart;
                    int len3 = physIdx - gapEnd;
                    this.moveDataWithGap(src, dst, len3);
                    this.gapStart += len3;
                    if (this.gapStart >= this.values.length) {
                        this.gapStart -= this.values.length;
                    }
                    ++this.gapSize;
                } else {
                    src = physIdx + 1;
                    dst = physIdx + this.gapSize + 1;
                    int len4 = this.gapStart - physIdx - 1;
                    this.moveDataWithGap(src, dst, len4);
                    this.gapStart = physIdx;
                    ++this.gapSize;
                }
                this.gapIndex = index;
            }
        }
        long removed = this.values[physIdx];
        this.values[physIdx] = 0L;
        --this.size;
        return removed;
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        int oldCapacity = this.values.length;
        if (minCapacity <= oldCapacity) {
            return;
        }
        int newCapacity = oldCapacity * 3 / 2 + 1;
        if (newCapacity < (minCapacity = Math.max(10, minCapacity))) {
            newCapacity = minCapacity;
        }
        long[] newValues = new long[newCapacity];
        if (this.size != 0) {
            if (this.start == 0) {
                System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            } else if (this.start > 0) {
                int grow = newCapacity - this.values.length;
                newValues = new long[newCapacity];
                System.arraycopy(this.values, 0, newValues, 0, this.start);
                System.arraycopy(this.values, this.start, newValues, this.start + grow, this.values.length - this.start);
                if (this.gapStart > this.start && this.gapSize > 0) {
                    this.gapStart += grow;
                }
                if (this.end > this.start) {
                    this.end += grow;
                }
                this.start += grow;
            }
        }
        if (this.end == 0 && this.start == 0 && this.size != 0) {
            this.end = this.values.length;
        }
        this.values = newValues;
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.size < this.values.length) {
            this.init(this.toArray(), this.size);
        }
    }

    @Override
    protected void doGetAll(long[] array, int index, int len2) {
        int[] physIdx = this.physIndex(index, index + len2);
        int pos2 = 0;
        for (int i = 0; i < physIdx.length; i += 2) {
            int num = physIdx[i + 1] - physIdx[i];
            System.arraycopy(this.values, physIdx[i], array, pos2, num);
            pos2 += num;
        }
        assert (pos2 == len2);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        int size2 = this.size();
        oos.writeInt(size2);
        for (int i = 0; i < size2; ++i) {
            oos.writeLong(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        this.size = ois.readInt();
        this.values = new long[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.values[i] = ois.readLong();
        }
    }

    @Override
    public ILongList doCreate(int capacity) {
        if (capacity == -1) {
            capacity = 10;
        }
        return new LongGapList(capacity);
    }

    @Override
    protected void doRemoveAll(int index, int len2) {
        if (len2 == this.size()) {
            this.doModify();
            this.doClear();
        } else {
            for (int i = 0; i < len2; ++i) {
                this.doRemove(index);
            }
        }
    }

    @Override
    public void sort(int index, int len2) {
        this.checkRange(index, len2);
        this.normalize();
        ArraysHelper.sort(this.values, index, index + len2);
    }

    @Override
    public int binarySearch(int index, int len2, long key) {
        this.checkRange(index, len2);
        this.normalize();
        return ArraysHelper.binarySearch(this.values, index, index + len2, key);
    }

    private void debugCheck() {
        block23: {
            int i;
            block22: {
                if (this.values == null) {
                    assert (this.size == 0 && this.start == 0 && this.end == 0);
                    assert (this.gapSize == 0 && this.gapStart == 0 && this.gapIndex == 0);
                    return;
                }
                assert (this.size >= 0 && this.size <= this.values.length);
                assert (this.start >= 0 && (this.start < this.values.length || this.values.length == 0));
                assert (this.end >= 0 && (this.end < this.values.length || this.values.length == 0));
                assert (this.values.length == 0 || (this.start + this.size + this.gapSize) % this.values.length == this.end);
                assert (this.gapSize >= 0);
                if (this.gapSize > 0) {
                    assert (this.gapStart >= 0 && this.gapStart < this.values.length);
                    assert (this.gapIndex > 0 && this.gapIndex < this.size);
                    assert (this.gapStart != this.start && this.gapStart != this.end);
                    assert (this.physIndex(this.gapIndex) == (this.gapStart + this.gapSize) % this.values.length);
                }
                if (this.gapSize > 0) {
                    for (i = this.gapStart; i < this.gapStart + this.gapSize; ++i) {
                        int pos2 = i % this.values.length;
                        assert (this.values[pos2] == 0L);
                    }
                }
                if (this.start >= this.end) break block22;
                for (i = 0; i < this.start; ++i) {
                    assert (this.values[i] == 0L);
                }
                for (i = this.end; i < this.values.length; ++i) {
                    assert (this.values[i] == 0L);
                }
                break block23;
            }
            if (this.end >= this.start) break block23;
            for (i = this.end; i < this.start; ++i) {
                assert (this.values[i] == 0L);
            }
        }
    }

    private int debugState() {
        if (this.size == 0) {
            return 0;
        }
        if (this.size == this.values.length) {
            return 1;
        }
        if (this.gapSize == 0) {
            if (this.start == 0) {
                return 2;
            }
            if (this.end == 0) {
                return 3;
            }
            if (this.start < this.end) {
                return 4;
            }
            if (this.start > this.end) {
                return 5;
            }
        } else if (this.gapSize > 0) {
            if (this.start == this.end) {
                if (this.start == 0) {
                    return 6;
                }
                if (this.gapStart < this.start) {
                    return 7;
                }
                if (this.gapStart > this.start) {
                    int gapEnd = (this.gapStart + this.gapSize) % this.values.length;
                    if (gapEnd > this.gapStart) {
                        return 8;
                    }
                    if (gapEnd < this.gapStart) {
                        return 9;
                    }
                }
            } else if (this.start != this.end) {
                if (this.start == 0) {
                    return 10;
                }
                if (this.gapStart < this.start) {
                    return 14;
                }
                if (this.gapStart > this.start) {
                    int gapEnd = (this.gapStart + this.gapSize) % this.values.length;
                    if (gapEnd < this.gapStart) {
                        return 12;
                    }
                    if (this.end == 0) {
                        return 11;
                    }
                    if (this.end > this.start) {
                        return 13;
                    }
                    if (this.end < this.start) {
                        return 15;
                    }
                }
            }
        }
        assert (false);
        return -1;
    }

    private void debugDump() {
        this.debugLog("values: size= " + this.values.length + ", data= " + this.debugPrint(this.values));
        this.debugLog("size=" + this.size + ", start=" + this.start + ", end=" + this.end + ", gapStart=" + this.gapStart + ", gapSize=" + this.gapSize + ", gapIndex=" + this.gapIndex);
        this.debugLog(this.toString());
    }

    private String debugPrint(long[] values2) {
        StringBuilder buf = new StringBuilder();
        buf.append("[ ");
        for (int i = 0; i < values2.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(values2[i]);
        }
        buf.append(" ]");
        return buf.toString();
    }

    private void debugLog(String msg) {
    }

    protected static class ImmutableLongGapList
    extends LongGapList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableLongGapList(LongGapList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, long elem) {
            this.error();
            return false;
        }

        @Override
        protected long doSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doReSet(int index, long elem) {
            this.error();
            return 0L;
        }

        @Override
        protected long doRemove(int index) {
            this.error();
            return 0L;
        }

        @Override
        protected void doRemoveAll(int index, int len2) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }
}

