/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.GapList;
import org.magicwerk.brownies.collections.IList;
import org.magicwerk.brownies.collections.helper.MergeSort;

public class BigList<E>
extends IList<E> {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final BigList EMPTY = BigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private BlockNode<E> rootNode;
    private BlockNode<E> currNode;
    private int currBlockStart;
    private int currBlockEnd;
    private int currModify;

    public static <EE> BigList<EE> EMPTY() {
        return EMPTY;
    }

    protected BigList(boolean copy, BigList<E> that) {
        if (copy) {
            this.blockSize = that.blockSize;
            this.currBlockStart = that.currBlockStart;
            this.currBlockEnd = that.currBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static <E> BigList<E> create() {
        return new BigList<E>();
    }

    public static <E> BigList<E> create(Collection<? extends E> coll) {
        return new BigList<E>(coll);
    }

    public static <E> BigList<E> create(E ... elems) {
        BigList<E> list2 = new BigList<E>();
        for (E elem : elems) {
            list2.add(elem);
        }
        return list2;
    }

    public BigList() {
        this(1000);
    }

    public BigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public BigList(Collection<? extends E> coll) {
        if (coll instanceof BigList) {
            this.doAssign((BigList)coll);
            this.doClone((BigList)coll);
        } else {
            this.blockSize = 1000;
            this.addBlock(0, new Block());
            for (Object obj : coll.toArray()) {
                this.add(obj);
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private BigList(int blockSize, int firstBlockSize) {
        this.doInit(blockSize, firstBlockSize);
    }

    private void doInit(int blockSize, int firstBlockSize) {
        this.blockSize = blockSize;
        Block block = firstBlockSize <= 1 ? new Block() : new Block(firstBlockSize);
        this.addBlock(0, block);
    }

    @Override
    public BigList<E> copy() {
        return (BigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(IList<E> that) {
        BigList list2 = (BigList)that;
        this.blockSize = list2.blockSize;
        this.currBlockEnd = list2.currBlockEnd;
        this.currBlockStart = list2.currBlockStart;
        this.currNode = list2.currNode;
        this.rootNode = list2.rootNode;
        this.size = list2.size;
    }

    @Override
    protected void doClone(IList<E> that) {
        BigList bigList = (BigList)that;
        bigList.releaseBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private BlockNode<E> copy(BlockNode<E> node) {
        BlockNode newNode = ((BlockNode)node).min();
        int index = newNode.block.size();
        BlockNode newRoot = new BlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public E getDefaultElem() {
        return null;
    }

    protected void finalize() {
        BlockNode node = ((BlockNode)this.rootNode).min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected E doGet(int index) {
        int pos2 = this.getBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos2);
    }

    @Override
    protected E doSet(int index, E elem) {
        int pos2 = this.getBlockIndex(index, true, 0);
        Object oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    @Override
    protected E doReSet(int index, E elem) {
        int pos2 = this.getBlockIndex(index, true, 0);
        Object oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    private void releaseBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currBlockStart && (index < this.currBlockEnd || index == this.currBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    ((BlockNode)this.currNode).setBlock(new Block(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currBlockStart;
            }
            this.releaseBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currBlockEnd != this.size) {
                this.currNode = ((BlockNode)this.rootNode).max();
                this.currBlockEnd = this.size;
                this.currBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                BlockNode leftNode = ((BlockNode)this.currNode).getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currBlockStart != 0) {
                this.currNode = ((BlockNode)this.rootNode).min();
                this.currBlockEnd = this.currNode.block.size();
                this.currBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetBlock(index, modify);
        }
        assert (index >= this.currBlockStart && index <= this.currBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            ((BlockNode)this.currNode).setBlock(new Block(this.currNode.block));
        }
        return index - this.currBlockStart;
    }

    private boolean isOnlyRootBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                BlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currBlockEnd) {
                    if (modify == 0) break;
                    BlockNode leftNode = ((BlockNode)this.currNode).getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currBlockEnd) {
                    nextNode = ((BlockNode)this.currNode).getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = ((BlockNode)this.currNode).getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            BlockNode left = ((BlockNode)this.currNode).getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currBlockStart = this.currBlockEnd - this.currNode.block.size();
    }

    private void addBlock(int index, Block<E> obj) {
        if (this.rootNode == null) {
            this.rootNode = new BlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = ((BlockNode)this.rootNode).insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, E element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos2 = this.getBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos2, element);
            ++this.currBlockEnd;
        } else {
            Block newBlock = new Block(this.blockSize);
            if (index == this.size) {
                BlockNode lastNode;
                newBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addBlock(this.size + 1, newBlock);
                this.currNode = lastNode = ((BlockNode)this.currNode).next();
                this.currBlockStart = this.currBlockEnd++;
            } else if (index == 0) {
                BlockNode firstNode;
                newBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addBlock(1, newBlock);
                this.currNode = firstNode = ((BlockNode)this.currNode).previous();
                this.currBlockStart = 0;
                this.currBlockEnd = 1;
            } else {
                int nextBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextBlockLen;
                GapList.transferRemove(this.currNode.block, blockLen, nextBlockLen, newBlock, 0, 0);
                this.modify(this.currNode, -nextBlockLen - 1);
                this.addBlock(this.currBlockEnd - nextBlockLen, newBlock);
                if (pos2 < blockLen) {
                    this.currNode.block.doAdd(pos2, element);
                    this.currBlockEnd = this.currBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = ((BlockNode)this.currNode).next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos2 - blockLen, element);
                    this.currBlockStart += blockLen;
                    ++this.currBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(BlockNode<E> node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            BlockNode p;
            BlockNode leftNode = ((BlockNode)node).getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            BlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            BlockNode parent2;
            node.relPos += modify;
            BlockNode leftNode = ((BlockNode)node).getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent2 = node.parent) != null) {
                BlockNode p;
                assert (parent2.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent2.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent2;
                    if (parentLeft != pLeft) {
                        parent2.relPos = parent2.relPos > 0 ? (parent2.relPos += modify) : (parent2.relPos -= modify);
                    }
                    parent2 = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private BlockNode<E> doRemove(BlockNode<E> node) {
        BlockNode newNode;
        BlockNode p = node.parent;
        BlockNode n = newNode = ((BlockNode)node).removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            ((BlockNode)node).recalcHeight();
            newNode = ((BlockNode)node).balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, IList<? extends E> list2) {
        if (list2.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list2.size() == 1) {
            return this.doAdd(index, list2.get(0));
        }
        int addPos = this.getBlockIndex(index, true, 0);
        Block addBlock = this.currNode.block;
        int space = this.blockSize - addBlock.size();
        int addLen = list2.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list2);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                Block nextBlock = new Block(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextBlock.add(i, list2.get(done + i));
                }
                this.addBlock(this.size + (done += add), nextBlock);
                this.currNode = ((BlockNode)this.currNode).next();
            }
            this.size += addLen;
            this.currBlockEnd = this.size;
            this.currBlockStart = this.currBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                Block nextBlock = new Block(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextBlock.add(i, list2.get(addLen - done - add + i));
                }
                done += add;
                this.addBlock(0, nextBlock);
                this.currNode = ((BlockNode)this.currNode).previous();
            }
            this.size += addLen;
            this.currBlockStart = 0;
            this.currBlockEnd = this.currNode.block.size();
        } else {
            IList sublist;
            int add;
            GapList<E> list22 = GapList.create();
            list22.addAll(list2);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list22.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list22.size();
            int numBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list22.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numBlocks;
                this.size += add;
                this.currBlockEnd += add;
            } else if (has > should) {
                Block nextBlock = new Block(this.blockSize);
                int move = has - should;
                nextBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currBlockEnd -= move;
                should = numElems / --numBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                IList sublist2 = list22.getAll(0, add2);
                nextBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextBlock.size() == should);
                numElems -= should;
                --numBlocks;
                this.size += add2;
                this.addBlock(this.currBlockEnd, nextBlock);
                this.currNode = ((BlockNode)this.currNode).next();
                assert (this.currNode.block == nextBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currBlockStart = this.currBlockEnd;
                this.currBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numBlocks;
            }
            while (numBlocks > 0) {
                add = numElems / numBlocks;
                assert (add > 0);
                sublist = list22.getAll(listPos, add);
                listPos += add;
                Block nextBlock = new Block();
                nextBlock.addAll(sublist);
                assert (nextBlock.size() == add);
                numElems -= add;
                this.addBlock(this.currBlockEnd, nextBlock);
                this.currNode = ((BlockNode)this.currNode).next();
                assert (this.currNode.block == nextBlock);
                assert (this.currNode.block.size() == add);
                this.currBlockStart = this.currBlockEnd;
                this.currBlockEnd += add;
                this.size += add;
                --numBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currBlockStart = 0;
        this.currBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len2) {
        if (len2 == 0) {
            return;
        }
        if (index == 0 && len2 == this.size) {
            this.doClear();
            return;
        }
        if (len2 == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getBlockIndex(index, true, 0);
        BlockNode<E> startNode = this.currNode;
        int endPos = this.getBlockIndex(index + len2 - 1, true, 0);
        BlockNode<E> endNode = this.currNode;
        if (startNode == endNode) {
            this.getBlockIndex(index, true, -len2);
            this.currNode.block.remove(startPos, len2);
            if (this.currNode.block.isEmpty()) {
                BlockNode<E> oldCurrNode = this.currNode;
                this.releaseBlock();
                BlockNode<E> node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currBlockEnd -= len2;
                this.merge(this.currNode);
            }
            this.size -= len2;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len2 -= startLen;
            this.size -= startLen;
            while (len2 > 0) {
                this.currNode = null;
                this.getBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len2) {
                    this.modify(this.currNode, -s);
                    BlockNode<E> oldCurrNode = this.currNode;
                    this.releaseBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len2 -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len2);
                this.currNode.block.remove(0, len2);
                this.size -= len2;
                break;
            }
            this.releaseBlock();
            this.getBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(BlockNode<E> node) {
        if (node == null) {
            return;
        }
        int minBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minBlockSize) {
            return;
        }
        BlockNode<E> oldCurrNode = node;
        BlockNode leftNode = ((BlockNode)node).previous();
        if (leftNode != null && leftNode.block.size() < minBlockSize) {
            int len2 = node.block.size();
            int dstSize = leftNode.getBlock().size();
            for (int i = 0; i < len2; ++i) {
                leftNode.block.add(null);
            }
            GapList.transferCopy(node.block, 0, len2, leftNode.block, dstSize, len2);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len2);
            this.modify(oldCurrNode, -len2);
            this.releaseBlock();
            this.doRemove(oldCurrNode);
        } else {
            BlockNode rightNode = ((BlockNode)node).next();
            if (rightNode != null && rightNode.block.size() < minBlockSize) {
                int len3 = node.block.size();
                for (int i = 0; i < len3; ++i) {
                    rightNode.block.add(0, null);
                }
                GapList.transferCopy(node.block, 0, len3, rightNode.block, 0, len3);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len3);
                this.modify(oldCurrNode, -len3);
                this.releaseBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected E doRemove(int index) {
        int pos2 = this.getBlockIndex(index, true, -1);
        Object oldElem = this.currNode.block.doRemove(pos2);
        --this.currBlockEnd;
        int minBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootBlock()) {
                    BlockNode<E> oldCurrNode = this.currNode;
                    this.releaseBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public BigList<E> unmodifiableList() {
        return new ImmutableBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            BigList newList = new BigList(this.blockSize);
            BlockNode node = ((BlockNode)this.rootNode).min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected IList<E> doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new BigList<E>(this.blockSize);
        }
        return new BigList<E>(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len2, Comparator<? super E> comparator) {
        this.checkRange(index, len2);
        if (this.isOnlyRootBlock()) {
            this.rootNode.block.sort(index, len2, comparator);
        } else {
            MergeSort.sort(this, comparator, index, index + len2);
        }
    }

    @Override
    public <K> int binarySearch(int index, int len2, K key, Comparator<? super K> comparator) {
        this.checkRange(index, len2);
        if (this.isOnlyRootBlock()) {
            return this.rootNode.block.binarySearch(key, comparator);
        }
        return Collections.binarySearch(this, key, comparator);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size2 = this.size();
        oos.writeInt(size2);
        for (int i = 0; i < size2; ++i) {
            oos.writeObject(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size2 = ois.readInt();
        int firstBlockSize = size2 <= blockSize ? size2 : -1;
        this.doInit(blockSize, firstBlockSize);
        for (int i = 0; i < size2; ++i) {
            this.add(ois.readObject());
        }
    }

    private void checkNode(BlockNode<E> node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        BlockNode child = ((BlockNode)node).getLeftSubTree();
        assert (child == null || child.parent == node);
        child = ((BlockNode)node).getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(BlockNode<E> node) {
        BlockNode left = ((BlockNode)node).getLeftSubTree();
        BlockNode right = ((BlockNode)node).getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currBlockStart >= 0 && this.currBlockEnd <= this.size && this.currBlockStart <= this.currBlockEnd);
            assert (this.currBlockStart + this.currNode.block.size() == this.currBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        BlockNode<E> oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        BlockNode<E> node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        Block block = ((BlockNode)node).getBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = ((BlockNode)node).getBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = ((BlockNode)node).getBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    protected static class ImmutableBigList<E>
    extends BigList<E> {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableBigList(BigList<E> that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, E elem) {
            this.error();
            return false;
        }

        @Override
        protected E doSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E doReSet(int index, E elem) {
            this.error();
            return null;
        }

        @Override
        protected E doRemove(int index) {
            this.error();
            return null;
        }

        @Override
        protected void doRemoveAll(int index, int len2) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class BlockNode<E> {
        BlockNode<E> parent;
        BlockNode<E> left;
        boolean leftIsPrevious;
        BlockNode<E> right;
        boolean rightIsNext;
        int height;
        int relPos;
        Block<E> block;

        private BlockNode(BlockNode<E> parent2, int relPos, Block<E> block, BlockNode<E> rightFollower, BlockNode<E> leftFollower) {
            this.parent = parent2;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private Block<E> getBlock() {
            return this.block;
        }

        private void setBlock(Block<E> block) {
            this.block = block;
        }

        private BlockNode<E> next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return super.min();
        }

        private BlockNode<E> previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return super.max();
        }

        private BlockNode<E> insert(int index, Block<E> obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private BlockNode<E> insertOnLeft(int relIndex, Block<E> obj) {
            if (this.getLeftSubTree() == null) {
                int pos2 = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new BlockNode<E>(this, pos2, obj, this, this.left), null);
            } else {
                this.setLeft(super.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            BlockNode<E> ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private BlockNode<E> insertOnRight(int relIndex, Block<E> obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new BlockNode<E>(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(super.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            BlockNode<E> ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private BlockNode<E> getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private BlockNode<E> getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private BlockNode<E> max() {
            return this.getRightSubTree() == null ? this : super.max();
        }

        private BlockNode<E> min() {
            return this.getLeftSubTree() == null ? this : super.min();
        }

        private BlockNode<E> removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(super.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private BlockNode<E> removeMin(int size2) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(super.removeMin(size2), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size2;
            }
            this.recalcHeight();
            return this.balance();
        }

        private BlockNode<E> removeSelf() {
            BlockNode<E> p = this.parent;
            BlockNode<E> n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private BlockNode<E> doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                super.setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                super.setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                BlockNode<E> rightMin = super.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = super.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                BlockNode<E> leftMax = super.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                BlockNode<E> leftPrevious = this.left.left;
                this.left = super.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private BlockNode<E> balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (super.heightRightMinusLeft() > 0) {
                        this.setLeft(super.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (super.heightRightMinusLeft() < 0) {
                        this.setRight(super.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(BlockNode<E> node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(BlockNode<E> node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(BlockNode<E> node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private BlockNode<E> rotateLeft() {
            assert (!this.rightIsNext);
            BlockNode<E> newTop = this.right;
            BlockNode<E> movedNode = super.getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            BlockNode<E> p = this.parent;
            this.setRight(movedNode, newTop);
            super.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (super.getLeftSubTree() == null || super.getLeftSubTree().relPos < 0);
            assert (super.getRightSubTree() == null || super.getRightSubTree().relPos > 0);
            return newTop;
        }

        private BlockNode<E> rotateRight() {
            assert (!this.leftIsPrevious);
            BlockNode<E> newTop = this.left;
            BlockNode<E> movedNode = super.getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            BlockNode<E> p = this.parent;
            this.setLeft(movedNode, newTop);
            super.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (super.getLeftSubTree() == null || super.getLeftSubTree().relPos < 0);
            assert (super.getRightSubTree() == null || super.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(BlockNode<E> node, BlockNode<E> previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(BlockNode<E> node, BlockNode<E> next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "BlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class Block<T>
    extends GapList<T> {
        private AtomicInteger refCount = new AtomicInteger(1);

        public Block() {
        }

        public Block(int capacity) {
            super(capacity);
        }

        public Block(Block<T> that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public Block<T> ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }
}

