/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.huntingdim.item;

import java.util.List;
import javax.annotation.Nullable;
import net.darkhax.bookshelf.item.IColorfulItem;
import net.darkhax.bookshelf.lib.MCColor;
import net.darkhax.bookshelf.util.StackUtils;
import net.darkhax.bookshelf.util.WorldUtils;
import net.darkhax.huntingdim.HuntingDimension;
import net.darkhax.huntingdim.Messages;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemBiomeChanger
extends Item
implements IColorfulItem {
    public ItemBiomeChanger() {
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        Biome biome = ItemBiomeChanger.getBiomeForStack(stack);
        if (biome == null) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"tooltip.huntingdim.biome.invalid", (Object[])new Object[0]) + ItemBiomeChanger.getBiomeId(stack));
        } else {
            tooltip.add(ItemBiomeChanger.getBiomeForStack(stack).func_185359_l());
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        Biome stackBiome = ItemBiomeChanger.getBiomeForStack(stack);
        if (playerIn.func_70093_af()) {
            Biome biome = worldIn.func_180494_b(playerIn.func_180425_c());
            ItemBiomeChanger.setBiome(stack, biome);
            Messages.CHANGER_SET_SELF.sendMessage((ICommandSender)playerIn, biome.getRegistryName());
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (!WorldUtils.isDimension((World)worldIn, (DimensionType)HuntingDimension.dimensionType)) {
            Messages.CHANGER_INVALID_DIMENSION.sendMessage((ICommandSender)playerIn, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (stackBiome == null) {
            Messages.CHANGER_INVALID_BIOME.sendMessage((ICommandSender)playerIn, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (worldIn.func_180494_b(playerIn.func_180425_c()) == ItemBiomeChanger.getBiomeForStack(playerIn.func_184586_b(handIn))) {
            Messages.CHANGER_BIOME_EXISTS.sendMessage((ICommandSender)playerIn, new Object[0]);
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        WorldUtils.setBiomes((World)worldIn, (BlockPos)playerIn.func_180425_c(), (Biome)ItemBiomeChanger.getBiomeForStack(stack));
        stack.func_190918_g(1);
        Messages.CHANGER_SET_WORLD.sendMessage((ICommandSender)playerIn, stackBiome.getRegistryName());
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (Biome biome : Biome.field_185377_q) {
                if (biome.func_185363_b()) continue;
                items.add((Object)this.createFromBiome(biome));
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IItemColor getColorHandler() {
        return (stack, index) -> ItemBiomeChanger.getColorForStack(stack, true);
    }

    public ItemStack createFromBiome(Biome biome) {
        return ItemBiomeChanger.setBiome(new ItemStack((Item)this), biome);
    }

    public static ItemStack setBiome(ItemStack stack, Biome biome) {
        NBTTagCompound tag = StackUtils.prepareStackTag((ItemStack)stack);
        tag.func_74768_a("HeldBiome", Biome.func_185362_a((Biome)biome));
        return stack;
    }

    public static int getBiomeId(ItemStack stack) {
        NBTTagCompound tag = StackUtils.prepareStackTag((ItemStack)stack);
        return tag.func_74762_e("HeldBiome");
    }

    public static Biome getBiomeForStack(ItemStack stack) {
        return Biome.func_150568_d((int)ItemBiomeChanger.getBiomeId(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public static int getColorForStack(ItemStack stack, boolean isGrass) {
        Biome biome = ItemBiomeChanger.getBiomeForStack(stack);
        return biome == null ? MCColor.DYE_WHITE.getRGB() : (isGrass ? biome.func_180627_b(new BlockPos(0, 255, 0)) : biome.func_76731_a(biome.func_185353_n()));
    }
}

