/*
 * Decompiled with CFR 0.152.
 */
package magicbees.elec332.corerepack.compat.forestry.allele;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.elec332.corerepack.compat.forestry.EffectData;
import magicbees.elec332.corerepack.compat.forestry.allele.AlleleEffectThrottled;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;

public class AlleleEffectPotion
extends AlleleEffectThrottled {
    private final PotionEffect baseEffect;
    private boolean bypassesArmour;

    public AlleleEffectPotion(ResourceLocation rl, PotionEffect baseEffect) {
        super(rl);
        this.setThrottle(200);
        this.baseEffect = baseEffect;
    }

    public AlleleEffectPotion(String s, PotionEffect baseEffect) {
        super(s);
        this.setThrottle(200);
        this.baseEffect = baseEffect;
    }

    public AlleleEffectPotion(String uid, String unlocalizedName, PotionEffect baseEffect) {
        super(uid, unlocalizedName);
        this.setThrottle(200);
        this.baseEffect = baseEffect;
    }

    public AlleleEffectPotion setBypassesArmour() {
        this.bypassesArmour = true;
        return this;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        List<EntityLivingBase> entities = AlleleEffectPotion.getEntitiesInRange(genome, housing, EntityLivingBase.class);
        for (EntityLivingBase entityLivingBase : entities) {
            if (this.bypassesArmour) {
                entityLivingBase.func_70690_d(new PotionEffect(this.baseEffect));
                continue;
            }
            int armour = BeeManager.armorApiaristHelper.wearsItems(entityLivingBase, this.getUID(), true);
            PotionEffect effect = new PotionEffect(this.baseEffect.func_188419_a(), this.baseEffect.func_76459_b() / 60 * armour, this.baseEffect.func_76458_c(), false, this.baseEffect.func_188418_e());
            effect.setCurativeItems(this.baseEffect.getCurativeItems());
            entityLivingBase.func_70690_d(effect);
        }
        return storedData;
    }
}

