/*
 * Decompiled with CFR 0.152.
 */
package com.feed_the_beast.ftblib.client;

import com.feed_the_beast.ftblib.FTBLibConfig;
import com.feed_the_beast.ftblib.client.EnumSidebarButtonPlacement;
import com.feed_the_beast.ftblib.client.FTBLibClientConfig;
import com.feed_the_beast.ftblib.client.GuiClientConfig;
import com.feed_the_beast.ftblib.client.SidebarButton;
import com.feed_the_beast.ftblib.client.SidebarButtonGroup;
import com.feed_the_beast.ftblib.client.SidebarButtonManager;
import com.feed_the_beast.ftblib.events.client.CustomClickEvent;
import com.feed_the_beast.ftblib.lib.ClientATHelper;
import com.feed_the_beast.ftblib.lib.gui.GuiIcons;
import com.feed_the_beast.ftblib.lib.icon.AtlasSpriteIcon;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.icon.IconPresets;
import com.feed_the_beast.ftblib.lib.icon.IconRenderer;
import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.feed_the_beast.ftblib.lib.util.NBTUtils;
import com.feed_the_beast.ftblib.lib.util.SidedUtils;
import com.feed_the_beast.ftblib.lib.util.text_components.Notification;
import com.feed_the_beast.ftblib.net.MessageAdminPanelGui;
import com.feed_the_beast.ftblib.net.MessageMyTeamGui;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.gui.chat.IChatListener;
import net.minecraft.client.gui.inventory.GuiContainerCreative;
import net.minecraft.client.gui.inventory.GuiInventory;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.InventoryEffectRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.input.Keyboard;

@Mod.EventBusSubscriber(modid="ftblib", value={Side.CLIENT})
public class FTBLibClientEventHandler {
    private static Temp currentNotification;
    public static Rectangle lastDrawnArea;
    public static boolean shouldRenderIcons;
    private static final IChatListener CHAT_LISTENER;

    @SubscribeEvent
    public static void onConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        SidedUtils.UNIVERSE_UUID_CLIENT = null;
        currentNotification = null;
        Temp.MAP.clear();
        ClientATHelper.getChatListeners().get(ChatType.GAME_INFO).clear();
        ClientATHelper.getChatListeners().get(ChatType.GAME_INFO).add(CHAT_LISTENER);
    }

    @SubscribeEvent
    public static void onTooltip(ItemTooltipEvent event) {
        Set<String> ores;
        if (FTBLibClientConfig.item_ore_names && !(ores = InvUtils.getOreNames(null, event.getItemStack())).isEmpty()) {
            event.getToolTip().add(I18n.func_135052_a((String)"ftblib_client.general.item_ore_names.item_tooltip", (Object[])new Object[0]));
            for (String or : ores) {
                event.getToolTip().add("> " + or);
            }
        }
        if (FTBLibClientConfig.item_nbt && GuiScreen.func_146272_n()) {
            NBTTagCompound nbt;
            NBTTagCompound nBTTagCompound = nbt = GuiScreen.func_175283_s() ? event.getItemStack().func_77973_b().getNBTShareTag(event.getItemStack()) : event.getItemStack().func_77978_p();
            if (nbt != null) {
                event.getToolTip().add(NBTUtils.getColoredNBTString((NBTBase)nbt));
            }
        }
    }

    @SubscribeEvent
    public static void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (FTBLibClientEventHandler.areButtonsVisible(event.getGui())) {
            event.getButtonList().add(new GuiButtonSidebarGroup((InventoryEffectRenderer)event.getGui()));
        }
    }

    public static boolean areButtonsVisible(@Nullable GuiScreen gui) {
        return FTBLibClientConfig.action_buttons != EnumSidebarButtonPlacement.DISABLED && gui instanceof InventoryEffectRenderer && !SidebarButtonManager.INSTANCE.groups.isEmpty();
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (Minecraft.func_71410_x().field_71441_e == null) {
                currentNotification = null;
                Temp.MAP.clear();
            }
            if (currentNotification != null && FTBLibClientEventHandler.currentNotification.tick()) {
                currentNotification = null;
            }
            if (currentNotification == null && !Temp.MAP.isEmpty()) {
                currentNotification = new Temp((ITextComponent)Temp.MAP.values().iterator().next());
                Temp.MAP.remove(((Temp)FTBLibClientEventHandler.currentNotification).widget.id);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onGameOverlayRender(RenderGameOverlayEvent.Text event) {
        if (currentNotification != null && !FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(event.getResolution(), event.getPartialTicks());
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public static void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            if (shouldRenderIcons) {
                IconRenderer.render();
            }
        } else if (currentNotification != null && FTBLibClientEventHandler.currentNotification.isImportant()) {
            currentNotification.render(new ScaledResolution(Minecraft.func_71410_x()), event.renderTickTime);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179098_w();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onFrameStart(TickEvent.RenderTickEvent e) {
    }

    @SubscribeEvent
    public static void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        if (FTBLibClientConfig.debug_helper && !Minecraft.func_71410_x().field_71474_y.field_74330_P && Keyboard.isKeyDown((int)61)) {
            event.getLeft().add(I18n.func_135052_a((String)"debug.help.help", (Object[])new Object[0]));
        }
    }

    @SubscribeEvent
    public static void onBeforeTexturesStitched(TextureStitchEvent.Pre event) {
        block3: {
            try {
                for (Field field : GuiIcons.class.getDeclaredFields()) {
                    field.setAccessible(true);
                    Object o = field.get(null);
                    if (!(o instanceof AtlasSpriteIcon)) continue;
                    AtlasSpriteIcon a = (AtlasSpriteIcon)o;
                    event.getMap().func_174942_a(new ResourceLocation(a.name));
                    IconPresets.MAP.put(a.name, a);
                }
            }
            catch (Exception ex) {
                if (!FTBLibConfig.debugging.print_more_errors) break block3;
                ex.printStackTrace();
            }
        }
    }

    @SubscribeEvent
    public static void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("ftblib")) {
            switch (event.getID().func_110623_a()) {
                case "client_config_gui": {
                    new GuiClientConfig().openGui();
                    break;
                }
                case "my_team_gui": {
                    new MessageMyTeamGui().sendToServer();
                    break;
                }
                case "admin_panel_gui": {
                    new MessageAdminPanelGui().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }

    static {
        lastDrawnArea = new Rectangle();
        shouldRenderIcons = false;
        CHAT_LISTENER = (type, component) -> {
            if (type == ChatType.GAME_INFO) {
                if (component instanceof Notification || FTBLibClientConfig.replace_vanilla_status_messages) {
                    ResourceLocation id = component instanceof Notification ? ((Notification)component).getId() : Notification.VANILLA_STATUS;
                    Temp.MAP.remove(id);
                    if (currentNotification != null && ((Temp)FTBLibClientEventHandler.currentNotification).widget.id.equals((Object)id)) {
                        currentNotification = null;
                    }
                    Temp.MAP.put(id, component);
                } else {
                    Minecraft.func_71410_x().field_71456_v.func_110326_a(component.func_150254_d(), false);
                }
            }
        };
    }

    private static class GuiButtonSidebarGroup
    extends GuiButton {
        private final InventoryEffectRenderer gui;
        public final List<GuiButtonSidebar> buttons;
        private GuiButtonSidebar mouseOver;

        public GuiButtonSidebarGroup(InventoryEffectRenderer g) {
            super(495829, 0, 0, 0, 0, "");
            this.gui = g;
            this.buttons = new ArrayList<GuiButtonSidebar>();
        }

        public void func_191745_a(Minecraft mc, int mx, int my, float partialTicks) {
            this.buttons.clear();
            this.mouseOver = null;
            int ry = 0;
            boolean top = FTBLibClientConfig.action_buttons.top() || !this.gui.field_146297_k.field_71439_g.func_70651_bq().isEmpty() || this.gui instanceof GuiInventory && ((GuiInventory)this.gui).func_194310_f().func_191878_b();
            for (SidebarButtonGroup group : SidebarButtonManager.INSTANCE.groups) {
                int rx = 0;
                boolean addedAny = false;
                for (SidebarButton sidebarButton : group.getButtons()) {
                    if (!sidebarButton.isActuallyVisible()) continue;
                    this.buttons.add(new GuiButtonSidebar(rx, ry, sidebarButton));
                    ++rx;
                    addedAny = true;
                }
                if (!addedAny) continue;
                ++ry;
            }
            int guiLeft = this.gui.getGuiLeft();
            int guiTop = this.gui.getGuiTop();
            if (top) {
                for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                    guiButtonSidebar.x = 1 + guiButtonSidebar.buttonX * 17;
                    guiButtonSidebar.y = 1 + guiButtonSidebar.buttonY * 17;
                }
            } else {
                int offsetY = 8;
                if (this.gui instanceof GuiContainerCreative) {
                    offsetY = 6;
                }
                for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                    guiButtonSidebar.x = guiLeft - 18 - guiButtonSidebar.buttonY * 17;
                    guiButtonSidebar.y = guiTop + offsetY + guiButtonSidebar.buttonX * 17;
                }
            }
            this.field_146128_h = Integer.MAX_VALUE;
            this.field_146129_i = Integer.MAX_VALUE;
            int maxX = Integer.MIN_VALUE;
            int n = Integer.MIN_VALUE;
            for (GuiButtonSidebar guiButtonSidebar : this.buttons) {
                if (guiButtonSidebar.x >= 0 && guiButtonSidebar.y >= 0) {
                    int n2;
                    this.field_146128_h = Math.min(this.field_146128_h, guiButtonSidebar.x);
                    this.field_146129_i = Math.min(this.field_146129_i, guiButtonSidebar.y);
                    maxX = Math.max(maxX, guiButtonSidebar.x + 16);
                    n2 = Math.max(n2, guiButtonSidebar.y + 16);
                }
                if (mx < guiButtonSidebar.x || my < guiButtonSidebar.y || mx >= guiButtonSidebar.x + 16 || my >= guiButtonSidebar.y + 16) continue;
                this.mouseOver = guiButtonSidebar;
            }
            this.field_146128_h -= 2;
            this.field_146129_i -= 2;
            this.field_146120_f = (maxX += 2) - this.field_146128_h;
            this.field_146121_g = (var12_23 += 2) - this.field_146129_i;
            this.field_73735_i = 0.0f;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
            FontRenderer fontRenderer = mc.field_71466_p;
            GlStateManager.func_179147_l();
            GlStateManager.func_179112_b((int)770, (int)771);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            for (GuiButtonSidebar b : this.buttons) {
                String text;
                b.button.getIcon().draw(b.x, b.y, 16, 16, Color4I.WHITE);
                if (b == this.mouseOver) {
                    Color4I.WHITE.withAlpha(33).draw(b.x, b.y, 16, 16);
                }
                if (b.button.getCustomTextHandler() == null || (text = b.button.getCustomTextHandler().get()).isEmpty()) continue;
                int nw = fontRenderer.func_78256_a(text);
                int width = 16;
                Color4I.LIGHT_RED.draw(b.x + width - nw, b.y - 1, nw + 1, 9);
                fontRenderer.func_78276_b(text, b.x + width - nw + 1, b.y, -1);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (this.mouseOver != null) {
                int n3 = mx + 10;
                int my1 = Math.max(3, my - 9);
                ArrayList<String> list = new ArrayList<String>();
                list.add(I18n.func_135052_a((String)this.mouseOver.button.getLangKey(), (Object[])new Object[0]));
                if (this.mouseOver.button.getTooltipHandler() != null) {
                    this.mouseOver.button.getTooltipHandler().accept(list);
                }
                int tw = 0;
                for (String s : list) {
                    tw = Math.max(tw, fontRenderer.func_78256_a(s));
                }
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)500.0f);
                GlStateManager.func_179147_l();
                GlStateManager.func_179112_b((int)770, (int)771);
                Color4I.DARK_GRAY.draw(n3 - 3, my1 - 2, tw + 6, 2 + list.size() * 10);
                for (int i = 0; i < list.size(); ++i) {
                    fontRenderer.func_78276_b((String)list.get(i), n3, my1 + i * 10, -1);
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179121_F();
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            this.field_73735_i = 0.0f;
            lastDrawnArea = new Rectangle(this.field_146128_h, this.field_146129_i, this.field_146120_f, this.field_146121_g);
        }

        public boolean func_146116_c(Minecraft mc, int mx, int my) {
            if (super.func_146116_c(mc, mx, my)) {
                if (this.mouseOver != null) {
                    this.mouseOver.button.onClicked(GuiScreen.func_146272_n());
                }
                return true;
            }
            return false;
        }
    }

    private static class GuiButtonSidebar {
        public final int buttonX;
        public final int buttonY;
        public final SidebarButton button;
        public int x;
        public int y;

        public GuiButtonSidebar(int x, int y, SidebarButton b) {
            this.buttonX = x;
            this.buttonY = y;
            this.button = b;
        }
    }

    private static class Temp {
        private static final LinkedHashMap<ResourceLocation, ITextComponent> MAP = new LinkedHashMap();
        private long tick;
        private long endTick;
        private NotificationWidget widget;

        private Temp(ITextComponent n) {
            this.widget = new NotificationWidget(n, Minecraft.func_71410_x().field_71466_p);
            this.endTick = -1L;
            this.tick = -1L;
        }

        public void render(ScaledResolution screen, float partialTicks) {
            if (this.tick == -1L || this.tick >= this.endTick) {
                return;
            }
            int alpha = (int)Math.min(255.0f, ((float)(this.endTick - this.tick) - partialTicks) * 255.0f / 20.0f);
            if (alpha <= 2) {
                return;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)((int)((float)screen.func_78326_a() / 2.0f)), (float)((int)((float)screen.func_78328_b() - 67.0f)), (float)0.0f);
            GlStateManager.func_179097_i();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179140_f();
            GlStateManager.func_179147_l();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            int offy = -(this.widget.text.size() * 11) / 2;
            for (int i = 0; i < this.widget.text.size(); ++i) {
                String string = this.widget.text.get(i);
                this.widget.font.func_175063_a(string, (float)(-this.widget.font.func_78256_a(string)) / 2.0f, (float)(offy + i * 11), 0xFFFFFF | alpha << 24);
            }
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179126_j();
        }

        private boolean tick() {
            this.tick = Minecraft.func_71410_x().field_71441_e.func_82737_E();
            if (this.endTick == -1L) {
                this.endTick = this.tick + this.widget.timer;
            }
            return this.tick >= this.endTick || Math.min(255.0f, (float)(this.endTick - this.tick) * 255.0f / 20.0f) <= 2.0f;
        }

        private boolean isImportant() {
            return this.widget.notification instanceof Notification && ((Notification)this.widget.notification).isImportant();
        }
    }

    public static class NotificationWidget {
        public final ITextComponent notification;
        public final ResourceLocation id;
        public final List<String> text;
        public int width;
        public int height;
        public final FontRenderer font;
        public final long timer;

        public NotificationWidget(ITextComponent n, FontRenderer f) {
            this.notification = n;
            this.id = n instanceof Notification ? ((Notification)n).getId() : Notification.VANILLA_STATUS;
            this.width = 0;
            this.font = f;
            this.text = new ArrayList<String>();
            this.timer = n instanceof Notification ? ((Notification)n).getTimer().ticks() : 60L;
            for (String s : this.font.func_78271_c(this.notification.func_150254_d(), new ScaledResolution(Minecraft.func_71410_x()).func_78326_a())) {
                for (String line : s.split("\n")) {
                    if (line.isEmpty()) continue;
                    line = line.trim();
                    this.text.add(line);
                    this.width = Math.max(this.width, this.font.func_78256_a(line));
                }
            }
            this.width += 4;
            this.height = this.text.size() * 11;
            if (this.text.isEmpty()) {
                this.width = 20;
                this.height = 20;
            }
        }
    }
}

