/*
 * Decompiled with CFR 0.152.
 */
package nex.block;

import java.util.Random;
import lex.IModData;
import lex.block.BlockLibEx;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import nex.NetherEx;
import nex.block.BlockNetherrack;
import nex.init.NetherExBlocks;

public class BlockEnokiMushroomCap
extends BlockLibEx {
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)5);

    public BlockEnokiMushroomCap() {
        super((IModData)NetherEx.instance, "enoki_mushroom_cap", Material.field_151585_k);
        this.func_149672_a(SoundType.field_185848_a);
        this.func_149711_c(0.4f);
        this.func_149675_a(true);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        if (!this.canSurvive(world, pos)) {
            world.func_175655_b(pos, true);
        } else {
            int i;
            BlockPos blockpos = pos.func_177977_b();
            if (world.func_175623_d(blockpos) && blockpos.func_177956_o() > 0 && (i = ((Integer)state.func_177229_b((IProperty)AGE)).intValue()) < 5 && rand.nextInt(1) == 0) {
                boolean flag = false;
                boolean flag1 = false;
                Block block = world.func_180495_p(pos.func_177984_a()).func_177230_c();
                if (block == Blocks.field_150424_aL || block == NetherExBlocks.NETHERRACK) {
                    flag = true;
                } else if (block == NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                    int j = 1;
                    for (int k = 0; k < 4; ++k) {
                        Block block1 = world.func_180495_p(pos.func_177981_b(j + 1)).func_177230_c();
                        if (block1 != NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                            if (block1 != Blocks.field_150424_aL && block1 != NetherExBlocks.NETHERRACK) break;
                            flag1 = true;
                            break;
                        }
                        ++j;
                    }
                    int i1 = 4;
                    if (flag1) {
                        ++i1;
                    }
                    if (j < 2 || rand.nextInt(i1) >= j) {
                        flag = true;
                    }
                } else if (block == Blocks.field_150350_a) {
                    flag = true;
                }
                if (flag && BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockpos, null) && world.func_175623_d(pos.func_177979_c(2))) {
                    world.func_180501_a(pos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                    this.placeGrownCap(world, blockpos, i);
                } else if (i < 4) {
                    int l = rand.nextInt(4);
                    boolean flag2 = false;
                    if (flag1) {
                        ++l;
                    }
                    for (int j1 = 0; j1 < l; ++j1) {
                        EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                        BlockPos blockpos1 = pos.func_177972_a(facing);
                        if (!world.func_175623_d(blockpos1) || !world.func_175623_d(blockpos1.func_177984_a()) || !BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockpos1, facing.func_176734_d())) continue;
                        this.placeGrownCap(world, blockpos1, i + 1);
                        flag2 = true;
                    }
                    if (flag2) {
                        world.func_180501_a(pos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                    } else {
                        this.placeDeadCap(world, pos);
                    }
                } else if (i == 4) {
                    this.placeDeadCap(world, pos);
                }
            }
        }
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        return super.func_176196_c(world, pos) && this.canSurvive(world, pos);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (!this.canSurvive(world, pos)) {
            world.func_175684_a(pos, (Block)this, 1);
        }
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, te, stack);
        BlockEnokiMushroomCap.func_180635_a((World)world, (BlockPos)pos, (ItemStack)new ItemStack(Item.func_150898_a((Block)this)));
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)AGE);
    }

    public boolean canSurvive(World world, BlockPos pos) {
        IBlockState stateUp = world.func_180495_p(pos.func_177984_a());
        Block blockUp = stateUp.func_177230_c();
        if (blockUp != NetherExBlocks.ENOKI_MUSHROOM_STEM && stateUp != NetherExBlocks.NETHERRACK.func_176223_P().func_177226_a(BlockNetherrack.TYPE, (Comparable)((Object)BlockNetherrack.EnumType.LIVELY))) {
            if (stateUp.func_185904_a() == Material.field_151579_a) {
                int i = 0;
                for (EnumFacing facing : EnumFacing.Plane.HORIZONTAL) {
                    IBlockState stateSide = world.func_180495_p(pos.func_177972_a(facing));
                    Block blockSide = stateSide.func_177230_c();
                    if (blockSide == NetherExBlocks.ENOKI_MUSHROOM_STEM) {
                        ++i;
                        continue;
                    }
                    if (stateSide.func_185904_a() == Material.field_151579_a) continue;
                    return false;
                }
                return i == 1;
            }
            return false;
        }
        return true;
    }

    private static boolean areAllNeighborsEmpty(World world, BlockPos pos, EnumFacing facing) {
        for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
            if (enumFacing == facing || world.func_175623_d(pos.func_177972_a(enumFacing))) continue;
            return false;
        }
        return true;
    }

    public static void generatePlant(World world, BlockPos pos, Random rand, int x) {
        BlockPos newPos = !world.func_175623_d(pos) ? pos.func_177977_b() : pos;
        world.func_180501_a(newPos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
        BlockEnokiMushroomCap.growTreeRecursive(world, newPos, rand, newPos, x, 0);
    }

    private static void growTreeRecursive(World world, BlockPos pos, Random rand, BlockPos pos1, int x, int z) {
        int i = rand.nextInt(4) + 1;
        if (z == 0) {
            ++i;
        }
        for (int j = 0; j < i; ++j) {
            BlockPos blockpos = pos.func_177979_c(j + 1);
            if (!BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockpos, null)) {
                return;
            }
            world.func_180501_a(blockpos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
        }
        boolean flag = false;
        if (z < 4) {
            int l = rand.nextInt(4);
            if (z == 0) {
                ++l;
            }
            for (int k = 0; k < l; ++k) {
                EnumFacing facing = EnumFacing.Plane.HORIZONTAL.func_179518_a(rand);
                BlockPos blockPos = pos.func_177979_c(i).func_177972_a(facing);
                if (Math.abs(blockPos.func_177958_n() - pos1.func_177958_n()) >= x || Math.abs(blockPos.func_177952_p() - pos1.func_177952_p()) >= x || !world.func_175623_d(blockPos) || !world.func_175623_d(blockPos.func_177984_a()) || !BlockEnokiMushroomCap.areAllNeighborsEmpty(world, blockPos, facing.func_176734_d())) continue;
                flag = true;
                world.func_180501_a(blockPos, NetherExBlocks.ENOKI_MUSHROOM_STEM.func_176223_P(), 2);
                BlockEnokiMushroomCap.growTreeRecursive(world, blockPos, rand, pos1, x, z + 1);
            }
        }
        if (!flag) {
            world.func_180501_a(pos.func_177979_c(i), NetherExBlocks.ENOKI_MUSHROOM_CAP.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
        }
    }

    private void placeGrownCap(World world, BlockPos pos, int age) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(age)), 2);
        world.func_175718_b(1033, pos, 0);
    }

    private void placeDeadCap(World world, BlockPos pos) {
        world.func_180501_a(pos, this.func_176223_P().func_177226_a((IProperty)AGE, (Comparable)Integer.valueOf(5)), 2);
        world.func_175718_b(1034, pos, 0);
    }
}

