/*
 * Decompiled with CFR 0.152.
 */
package com.polipo.fishing;

import com.polipo.fishing.BlockNetDry;
import com.polipo.fishing.BlockStaticNetWet;
import com.polipo.fishing.FishingNet;
import com.polipo.fishing.TileEntityNet;
import java.util.EnumSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockDynamicLiquid;
import net.minecraft.block.BlockLiquid;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockDynamicNetWet
extends BlockDynamicLiquid
implements ITileEntityProvider {
    private int adjacentSourceBlocks;

    protected BlockDynamicNetWet() {
        super(Material.field_151586_h);
        this.setRegistryName(new ResourceLocation("giacomos_fishing_net", "netWet"));
        this.func_149663_c("netWet");
        this.func_149675_a(false);
    }

    public int func_149717_k(IBlockState state) {
        return 0;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_180634_a(World worldIn, BlockPos pos, IBlockState state, Entity entityIn) {
        entityIn.func_70110_aj();
    }

    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_176209_a(IBlockState state, boolean hitIfLiquid) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing side) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_176200_f(IBlockAccess worldIn, BlockPos pos) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.LIQUID;
    }

    private void placeStaticBlock(World worldIn, BlockPos pos, IBlockState currentState) {
        worldIn.func_180501_a(pos, FishingNet.netWetStatic.func_176223_P().func_177226_a((IProperty)field_176367_b, currentState.func_177229_b((IProperty)field_176367_b)), 2);
        worldIn.func_175684_a(pos, FishingNet.netWetStatic, FishingNet.netWetStatic.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        int i1;
        int i = (Integer)state.func_177229_b((IProperty)field_176367_b);
        int b0 = 1;
        if (this.field_149764_J == Material.field_151587_i && !worldIn.field_73011_w.func_177500_n()) {
            b0 = 2;
        }
        int j = this.func_149738_a(worldIn);
        if (i > 0) {
            int depthUp;
            int k = -100;
            this.adjacentSourceBlocks = 0;
            for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
                k = this.func_176371_a(worldIn, pos.func_177972_a(enumfacing), k);
            }
            int l = k + b0;
            if (l >= 8 || k < 0) {
                l = -1;
            }
            if ((depthUp = this.func_189542_i(worldIn.func_180495_p(pos.func_177984_a()))) >= 0) {
                i1 = depthUp;
                l = i1 >= 8 ? i1 : i1 + 8;
            }
            if (this.adjacentSourceBlocks >= 2 && this.field_149764_J == Material.field_151586_h) {
                IBlockState iblockstate2 = worldIn.func_180495_p(pos.func_177977_b());
                if (iblockstate2.func_185904_a().func_76220_a()) {
                    l = 0;
                } else if (iblockstate2.func_185904_a() == this.field_149764_J && (Integer)iblockstate2.func_177229_b((IProperty)field_176367_b) == 0) {
                    l = 0;
                }
            }
            if (this.field_149764_J == Material.field_151587_i && i < 8 && l < 8 && l > i && rand.nextInt(4) != 0) {
                j *= 4;
            }
            if (l == i) {
                this.placeStaticBlock(worldIn, pos, state);
            } else {
                i = l;
                if (l < 0) {
                    worldIn.func_180501_a(pos, FishingNet.netDry.func_176223_P(), 3);
                } else {
                    state = state.func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(l));
                    worldIn.func_180501_a(pos, state, 2);
                    worldIn.func_175684_a(pos, (Block)this, j);
                    worldIn.func_175685_c(pos, (Block)this, false);
                }
            }
        } else {
            this.placeStaticBlock(worldIn, pos, state);
        }
        IBlockState iblockstate1 = worldIn.func_180495_p(pos.func_177977_b());
        if (this.canFlowInto(worldIn, pos.func_177977_b(), iblockstate1)) {
            if (this.field_149764_J == Material.field_151587_i && worldIn.func_180495_p(pos.func_177977_b()).func_185904_a() == Material.field_151586_h) {
                worldIn.func_175656_a(pos.func_177977_b(), Blocks.field_150348_b.func_176223_P());
                this.func_180688_d(worldIn, pos.func_177977_b());
                return;
            }
            if (i >= 8) {
                this.tryFlowInto(worldIn, pos.func_177977_b(), iblockstate1, i);
            } else {
                this.tryFlowInto(worldIn, pos.func_177977_b(), iblockstate1, i + 8);
            }
        } else if (i >= 0 && (i == 0 || this.isBlocked(worldIn, pos.func_177977_b(), iblockstate1))) {
            Set set = this.getPossibleFlowDirections(worldIn, pos);
            i1 = i + b0;
            if (i >= 8) {
                i1 = 1;
            }
            if (i1 >= 8) {
                return;
            }
            for (EnumFacing enumfacing1 : set) {
                this.tryFlowInto(worldIn, pos.func_177972_a(enumfacing1), worldIn.func_180495_p(pos.func_177972_a(enumfacing1)), i1);
            }
        }
    }

    private void tryFlowInto(World worldIn, BlockPos pos, IBlockState state, int level) {
        if (this.canFlowInto(worldIn, pos, state)) {
            if (state.func_177230_c() != Blocks.field_150350_a) {
                if (this.field_149764_J == Material.field_151587_i) {
                    this.func_180688_d(worldIn, pos);
                } else {
                    state.func_177230_c().func_176226_b(worldIn, pos, state, 0);
                }
            }
            worldIn.func_180501_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
    }

    private int func_176374_a(World worldIn, BlockPos pos, int distance, EnumFacing calculateFlowCost) {
        int j = 1000;
        for (EnumFacing enumfacing1 : EnumFacing.Plane.HORIZONTAL) {
            int k;
            IBlockState iblockstate;
            BlockPos blockpos1;
            if (enumfacing1 == calculateFlowCost || this.isBlocked(worldIn, blockpos1 = pos.func_177972_a(enumfacing1), iblockstate = worldIn.func_180495_p(blockpos1)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            if (!this.isBlocked(worldIn, blockpos1.func_177977_b(), iblockstate)) {
                return distance;
            }
            if (distance >= 4 || (k = this.func_176374_a(worldIn, blockpos1, distance + 1, enumfacing1.func_176734_d())) >= j) continue;
            j = k;
        }
        return j;
    }

    private Set getPossibleFlowDirections(World worldIn, BlockPos pos) {
        int i = 1000;
        EnumSet<EnumFacing> enumset = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing enumfacing : EnumFacing.Plane.HORIZONTAL) {
            IBlockState iblockstate;
            BlockPos blockpos1 = pos.func_177972_a(enumfacing);
            if (this.isBlocked(worldIn, blockpos1, iblockstate = worldIn.func_180495_p(blockpos1)) || iblockstate.func_185904_a() == this.field_149764_J && (Integer)iblockstate.func_177229_b((IProperty)field_176367_b) <= 0) continue;
            int j = this.isBlocked(worldIn, blockpos1.func_177977_b(), worldIn.func_180495_p(blockpos1.func_177977_b())) ? this.func_176374_a(worldIn, blockpos1, 1, enumfacing.func_176734_d()) : 0;
            if (j < i) {
                enumset.clear();
            }
            if (j > i) continue;
            enumset.add(enumfacing);
            i = j;
        }
        return enumset;
    }

    private boolean isBlocked(World worldIn, BlockPos pos, IBlockState state) {
        Block block = state.func_177230_c();
        return !(block instanceof BlockDoor) && block != Blocks.field_150472_an && block != Blocks.field_150468_ap && block != Blocks.field_150436_aH ? (state.func_185904_a() == Material.field_151567_E ? true : state.func_185904_a().func_76230_c()) : true;
    }

    protected int func_176371_a(World worldIn, BlockPos pos, int currentMinLevel) {
        int i = this.func_189542_i(worldIn.func_180495_p(pos));
        if (i < 0) {
            return currentMinLevel;
        }
        if (i == 0) {
            ++this.adjacentSourceBlocks;
        }
        if (i >= 8) {
            i = 0;
        }
        return currentMinLevel >= 0 && i >= currentMinLevel ? currentMinLevel : i;
    }

    private boolean canFlowInto(World worldIn, BlockPos pos, IBlockState state) {
        Material material = state.func_185904_a();
        return material != this.field_149764_J && material != Material.field_151587_i && !this.isBlocked(worldIn, pos, state);
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityNet(worldIn.func_82737_E());
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        if (!this.func_176365_e(worldIn, pos, state)) {
            worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return null;
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    protected boolean func_149700_E() {
        return false;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return true;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        int level = (Integer)state.func_177229_b((IProperty)BlockLiquid.field_176367_b);
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof TileEntityNet && !world.field_72995_K) {
            if (!player.field_71075_bZ.field_75098_d) {
                TileEntityNet tileEntityNet = (TileEntityNet)tileEntity;
                tileEntityNet.dropItems(world, pos, player);
            }
            world.func_175713_t(pos);
            return world.func_180501_a(pos, Blocks.field_150358_i.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, (Comparable)Integer.valueOf(level)), 3);
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState newState = worldIn.func_180495_p(pos);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityNet) {
            if (!(newState.func_177230_c() instanceof BlockDynamicNetWet || newState.func_177230_c() instanceof BlockStaticNetWet || newState.func_177230_c() instanceof BlockNetDry)) {
                if (newState.func_177230_c() instanceof BlockLiquid && newState.func_185904_a() == Material.field_151586_h) {
                    worldIn.func_175656_a(pos, FishingNet.netWetDynamic.func_176223_P().func_177226_a((IProperty)BlockLiquid.field_176367_b, newState.func_177229_b((IProperty)BlockLiquid.field_176367_b)));
                } else {
                    ((TileEntityNet)tileEntity).dropItems(worldIn, pos);
                    super.func_180663_b(worldIn, pos, state);
                }
            }
        } else {
            super.func_180663_b(worldIn, pos, state);
        }
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)FishingNet.itemNet);
    }
}

