/*
 * Decompiled with CFR 0.152.
 */
package io.github.phantamanta44.mekores;

import io.github.phantamanta44.mekores.MekOres;
import io.github.phantamanta44.mekores.item.MOItems;
import io.github.phantamanta44.mekores.ore.OreType;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class CommonProxy {
    private final Collection<Item> itemsToRegister = new LinkedList<Item>();
    private final Collection<Pair<ItemStack, String>> oresToRegister = new LinkedList<Pair<ItemStack, String>>();

    public void onPreInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void onInit() {
        MOItems.mekanismOre.registerOreDict();
        MOItems.mekanismOre.registerRecipes();
    }

    public void onPostInit() {
        MekOres.LOGGER.info("Searching for valid Mekanism ores...");
        HashSet<String> modIds = new HashSet<String>();
        int valid = 0;
        int invalid = 0;
        for (String name : OreDictionary.getOreNames()) {
            if (!name.startsWith("ore")) continue;
            String key = name.substring(3);
            OreType type = OreType.getByKey(name.substring(3));
            if (type != null && type.isValid()) {
                CommonProxy.reportOre(type.key, modIds);
                type.setValid();
                ++valid;
                continue;
            }
            if (!OreType.isKeyValid(key)) continue;
            CommonProxy.reportOre(key, modIds);
            MekOres.LOGGER.warn("Unknown ore {}!", (Object)key);
            ++invalid;
        }
        MekOres.LOGGER.info("Found {} valid, {} invalid ores from mod(s) {}", (Object)valid, (Object)invalid, (Object)String.join((CharSequence)", ", modIds));
    }

    private static void reportOre(String key, Set<String> modIds) {
        String mods = OreDictionary.getOres((String)("ore" + key)).stream().map(o -> Objects.requireNonNull(o.func_77973_b().getRegistryName()).func_110624_b()).peek(modIds::add).collect(Collectors.joining(", "));
        MekOres.LOGGER.info("Found ore {} from mod(s) {}", (Object)key, (Object)mods);
    }

    public void queueRegistration(Item item) {
        this.itemsToRegister.add(item);
    }

    public void queueRegistration(ItemStack stack, String key) {
        this.oresToRegister.add((Pair<ItemStack, String>)Pair.of((Object)stack, (Object)key));
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        this.itemsToRegister.forEach(arg_0 -> ((IForgeRegistry)event.getRegistry()).register(arg_0));
        this.itemsToRegister.clear();
        this.oresToRegister.forEach(p -> OreDictionary.registerOre((String)((String)p.getRight()), (ItemStack)((ItemStack)p.getLeft())));
        this.oresToRegister.clear();
    }

    public void registerItemModel(Item item, int meta, String name) {
    }

    public void gameInit() {
    }

    public void cacheOreColours() {
    }

    @Config(modid="mekores")
    public static class CONFIG {
        @Config.RequiresMcRestart
        @Config.Comment(value={"A list of ore types to disable processing for.", "Entries should be formatted as oredict suffixes (e.g. Copper, DeepIron, AstralStarmetal)"})
        public static String[] blacklist = new String[0];
    }
}

