/*
 * Decompiled with CFR 0.152.
 */
package com.mjr.extraplanets.planets.Mercury;

import com.mjr.extraplanets.Config;
import com.mjr.extraplanets.ExtraPlanetsDimensions;
import com.mjr.extraplanets.api.prefabs.world.WorldProviderRealisticSpace;
import com.mjr.extraplanets.blocks.ExtraPlanets_Blocks;
import com.mjr.extraplanets.planets.ExtraPlanets_Planets;
import com.mjr.extraplanets.planets.Mercury.worldgen.ChunkProviderMercury;
import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.galaxies.CelestialBody;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.RoomTreasure;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.gen.IChunkGenerator;

public class WorldProviderMercury
extends WorldProviderRealisticSpace {
    public Vector3 getFogColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.46666667f * f), (double)(0.46666667f * f), (double)(0.46666667f * f));
    }

    public Vector3 getSkyColor() {
        float f = 1.0f - this.getStarBrightness(1.0f);
        return new Vector3((double)(0.0f * f), (double)(0.0f * f), (double)(0.0f * f));
    }

    public boolean hasSunset() {
        return false;
    }

    public long getDayLength() {
        return 820000L;
    }

    public Class<? extends IChunkGenerator> getChunkProviderClass() {
        return ChunkProviderMercury.class;
    }

    public double getHorizon() {
        return 44.0;
    }

    public int func_76557_i() {
        return 44;
    }

    public boolean func_76566_a(int var1, int var2) {
        return true;
    }

    public float getGravity() {
        return 0.058f;
    }

    public int getHeight() {
        return 800;
    }

    public double getMeteorFrequency() {
        return 10.0;
    }

    public double getFuelUsageMultiplier() {
        return 1.0;
    }

    public boolean canSpaceshipTierPass(int tier) {
        return tier >= 3;
    }

    public float getFallDamageModifier() {
        return 0.38f;
    }

    public CelestialBody getCelestialBody() {
        return ExtraPlanets_Planets.MERCURY;
    }

    public double getSolarEnergyMultiplier() {
        return 6.0;
    }

    @Override
    public int getPressureLevel() {
        return 20;
    }

    @Override
    public int getSolarRadiationLevel() {
        return Config.MERCURY_RADIATION_AMOUNT;
    }

    public DimensionType func_186058_p() {
        return ExtraPlanetsDimensions.MERCURY;
    }

    public int getDungeonSpacing() {
        return 800;
    }

    public ResourceLocation getDungeonChestType() {
        return RoomTreasure.MOONCHEST;
    }

    public List<Block> getSurfaceBlocks() {
        LinkedList<Block> list = new LinkedList<Block>();
        list.add(ExtraPlanets_Blocks.MERCURY_BLOCKS);
        return list;
    }
}

