/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.ai;

import com.google.common.base.Predicate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import net.minecraft.entity.Entity;

public class StringFilterEntitySelector
implements Predicate<Entity> {
    private List<EntityFilter> filters = new ArrayList<EntityFilter>();

    public boolean apply(Entity entity) {
        for (EntityFilter f : this.getFilter()) {
            if (!f.apply(entity)) continue;
            return true;
        }
        return false;
    }

    protected List<EntityFilter> getFilter() {
        return this.filters;
    }

    public StringFilterEntitySelector setFilter(String filterStr) {
        EntityFilter filter = EntityFilter.fromString(filterStr);
        if (filter != null) {
            this.filters = Collections.singletonList(filter);
        } else {
            this.filters.clear();
        }
        return this;
    }

    public StringFilterEntitySelector setFilter(List<EntityFilter> filters) {
        this.filters = filters;
        return this;
    }

    public StringFilterEntitySelector addEntry(String filterStr) {
        EntityFilter filter = EntityFilter.fromString(filterStr);
        if (filter != null) {
            this.filters.add(filter);
        }
        return this;
    }
}

