/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler;

import me.desht.pneumaticcraft.api.client.IGuiAnimatedStat;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiJetBootsOptions;
import me.desht.pneumaticcraft.client.gui.widget.GuiAnimatedStat;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.recipes.CraftingRegistrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class JetBootsUpgradeHandler
extends IUpgradeRenderHandler.SimpleToggleableRenderHandler {
    private static final String[] HEADINGS = new String[]{"S", "SW", "W", "NW", "N", "NE", "E", "SE"};
    private String l1;
    private String l2;
    private String l3;
    private String r1;
    private String r2;
    private String r3;
    private int widestR;
    @SideOnly(value=Side.CLIENT)
    private IGuiAnimatedStat jbStat;

    @Override
    public String getUpgradeName() {
        return "jetBoots";
    }

    @Override
    public Item[] getRequiredUpgrades() {
        return new Item[]{Itemss.upgrades.get(IItemRegistry.EnumUpgrade.JET_BOOTS)};
    }

    @Override
    public IOptionPage getGuiOptionsPage() {
        return new GuiJetBootsOptions(this);
    }

    @Override
    public EntityEquipmentSlot getEquipmentSlot() {
        return EntityEquipmentSlot.FEET;
    }

    @Override
    public void update(EntityPlayer player, int rangeUpgrades) {
        super.update(player, rangeUpgrades);
        String g1 = TextFormatting.WHITE.toString();
        String g2 = TextFormatting.GREEN.toString();
        if (this.jbStat.isClicked()) {
            double mx = player.field_70165_t - player.field_70142_S;
            double my = player.field_70163_u - player.field_70137_T;
            double mz = player.field_70161_v - player.field_70136_U;
            double v = Math.sqrt(mx * mx + my * my + mz * mz);
            double vg = Math.sqrt(mx * mx + mz * mz);
            int heading = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 8.0f / 360.0f) + 0.5)) & 7;
            int yaw = ((int)player.field_70177_z + 180) % 360;
            if (yaw < 0) {
                yaw += 360;
            }
            BlockPos pos = player.func_180425_c();
            this.l1 = String.format(" %sSpd: %s%05.2fm/s", g1, g2, v * 20.0);
            this.l2 = String.format("  %sAlt: %s%03dm", g1, g2, pos.func_177956_o());
            this.l3 = String.format("%sHead: %s%d\u00b0 (%s)", g1, g2, yaw, HEADINGS[heading]);
            this.r1 = String.format("%sGnd: %s%05.2f", g1, g2, vg * 20.0);
            this.r2 = String.format("%sGnd: %s%dm", g1, g2, pos.func_177956_o() - player.field_70170_p.func_189649_b(pos.func_177958_n(), pos.func_177952_p()));
            this.r3 = String.format("%sPch: %s%d\u00b0", g1, g2, (int)(-player.field_70125_A));
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            this.widestR = Math.max(fr.func_78256_a(this.r1), Math.max(fr.func_78256_a(this.r2), fr.func_78256_a(this.r3)));
        }
    }

    @Override
    public void render2D(float partialTicks, boolean helmetEnabled) {
        super.render2D(partialTicks, helmetEnabled);
        if (helmetEnabled && this.jbStat.isClicked()) {
            FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
            int xl = this.jbStat.getBaseX() + 5;
            int y = this.jbStat.getBaseY() + fr.field_78288_b + 8;
            int xr = this.jbStat.getBaseX() + this.jbStat.getWidth() - 5;
            if (this.jbStat.isLeftSided()) {
                xl -= this.jbStat.getWidth();
                xr -= this.jbStat.getWidth();
            }
            fr.func_175063_a(this.l1, (float)xl, (float)y, 0x404040);
            fr.func_175063_a(this.l2, (float)xl, (float)(y + fr.field_78288_b), 0x404040);
            fr.func_175063_a(this.l3, (float)xl, (float)(y + fr.field_78288_b * 2), 0x404040);
            fr.func_175063_a(this.r1, (float)(xr - this.widestR), (float)y, 0x404040);
            fr.func_175063_a(this.r2, (float)(xr - this.widestR), (float)(y + fr.field_78288_b), 0x404040);
            fr.func_175063_a(this.r3, (float)(xr - this.widestR), (float)(y + fr.field_78288_b * 2), 0x404040);
        }
    }

    @Override
    public IGuiAnimatedStat getAnimatedStat() {
        if (this.jbStat == null) {
            this.jbStat = new GuiAnimatedStat(null, "Jet Boots", GuiAnimatedStat.StatIcon.of(CraftingRegistrator.getUpgrade(IItemRegistry.EnumUpgrade.JET_BOOTS)), 0x3000AA00, null, ArmorHUDLayout.INSTANCE.jetBootsStat);
            this.jbStat.setMinDimensionsAndReset(0, 0);
            this.jbStat.addPadding(3, 32);
        }
        return this.jbStat;
    }

    @Override
    public void onResolutionChanged() {
        this.jbStat = null;
    }
}

