/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.render.pneumatic_armor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IBlockTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IEntityTrackEntry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableBlock;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IHackableEntity;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IPneumaticHelmetRegistry;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IUpgradeRenderHandler;
import me.desht.pneumaticcraft.api.hacking.CapabilityHacking;
import me.desht.pneumaticcraft.api.hacking.IHacking;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.UpgradeRenderHandlerList;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.block_tracker.BlockTrackEntryList;
import me.desht.pneumaticcraft.lib.Log;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import org.apache.commons.lang3.Validate;

public class PneumaticHelmetRegistry
implements IPneumaticHelmetRegistry {
    private static final PneumaticHelmetRegistry INSTANCE = new PneumaticHelmetRegistry();
    public final List<Class<? extends IEntityTrackEntry>> entityTrackEntries = new ArrayList<Class<? extends IEntityTrackEntry>>();
    public final Map<Class<? extends Entity>, Class<? extends IHackableEntity>> hackableEntities = new HashMap<Class<? extends Entity>, Class<? extends IHackableEntity>>();
    public final Map<Block, Class<? extends IHackableBlock>> hackableBlocks = new HashMap<Block, Class<? extends IHackableBlock>>();
    public final Map<String, Class<? extends IHackableEntity>> stringToEntityHackables = new HashMap<String, Class<? extends IHackableEntity>>();
    public final Map<String, Class<? extends IHackableBlock>> stringToBlockHackables = new HashMap<String, Class<? extends IHackableBlock>>();

    public static PneumaticHelmetRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerEntityTrackEntry(Class<? extends IEntityTrackEntry> entry) {
        if (entry == null) {
            throw new NullPointerException("Can't register null!");
        }
        this.entityTrackEntries.add(entry);
    }

    @Override
    public void addHackable(Class<? extends Entity> entityClazz, Class<? extends IHackableEntity> iHackable) {
        if (entityClazz == null) {
            throw new NullPointerException("Entity class is null!");
        }
        if (iHackable == null) {
            throw new NullPointerException("IHackableEntity is null!");
        }
        if (Entity.class.isAssignableFrom(iHackable)) {
            Log.warning("Entities that implement IHackableEntity shouldn't be registered as hackable! Registering entity: " + entityClazz.getCanonicalName());
        } else {
            try {
                IHackableEntity hackableEntity = iHackable.newInstance();
                if (hackableEntity.getId() != null) {
                    this.stringToEntityHackables.put(hackableEntity.getId(), iHackable);
                }
                this.hackableEntities.put(entityClazz, iHackable);
            }
            catch (InstantiationException e) {
                Log.error("Not able to register hackable entity: " + iHackable.getName() + ". Does the class have a parameterless constructor?");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Not able to register hackable entity: " + iHackable.getName() + ". Is the class a public class?");
                e.printStackTrace();
            }
        }
    }

    @Override
    public void addHackable(Block block, Class<? extends IHackableBlock> iHackable) {
        if (block == null) {
            throw new NullPointerException("Block is null! class = " + iHackable);
        }
        if (iHackable == null) {
            throw new NullPointerException("IHackableBlock is null! block = " + block.getRegistryName());
        }
        if (Block.class.isAssignableFrom(iHackable)) {
            Log.warning("Blocks that implement IHackableBlock shouldn't be registered as hackable! Registering block: " + block.func_149732_F());
        } else {
            try {
                IHackableBlock hackableBlock = iHackable.newInstance();
                if (hackableBlock.getId() != null) {
                    this.stringToBlockHackables.put(hackableBlock.getId(), iHackable);
                }
                this.hackableBlocks.put(block, iHackable);
            }
            catch (InstantiationException e) {
                Log.error("Not able to register hackable block: " + iHackable.getName() + ". Does the class have a parameterless constructor?");
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                Log.error("Not able to register hackable block: " + iHackable.getName() + ". Is the class a public class?");
                e.printStackTrace();
            }
        }
    }

    @Override
    public List<IHackableEntity> getCurrentEntityHacks(Entity entity) {
        IHacking hacking = (IHacking)entity.getCapability(CapabilityHacking.HACKING_CAPABILITY, null);
        if (hacking != null) {
            return hacking.getCurrentHacks();
        }
        Log.warning("Hacking capability couldn't be found in the entity " + entity.func_70005_c_());
        return Collections.emptyList();
    }

    @Override
    public void registerBlockTrackEntry(IBlockTrackEntry entry) {
        BlockTrackEntryList.instance.trackList.add((Object)entry);
    }

    @Override
    public void registerRenderHandler(IUpgradeRenderHandler renderHandler) {
        Validate.notNull((Object)renderHandler, (String)"Render handler can't be null!", (Object[])new Object[0]);
        UpgradeRenderHandlerList.instance().addUpgradeRenderer(renderHandler);
    }
}

