/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.client.gui.pneumatic_armor;

import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IGuiScreen;
import me.desht.pneumaticcraft.api.client.pneumaticHelmet.IOptionPage;
import me.desht.pneumaticcraft.client.gui.GuiButtonSpecial;
import me.desht.pneumaticcraft.client.gui.pneumatic_armor.GuiMoveStat;
import me.desht.pneumaticcraft.client.render.pneumatic_armor.upgrade_handler.EntityTrackUpgradeHandler;
import me.desht.pneumaticcraft.client.util.GuiUtils;
import me.desht.pneumaticcraft.common.config.ArmorHUDLayout;
import me.desht.pneumaticcraft.common.item.ItemPneumaticArmor;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateArmorExtraData;
import me.desht.pneumaticcraft.common.util.EntityFilter;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import me.desht.pneumaticcraft.lib.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import org.lwjgl.input.Keyboard;

public class GuiEntityTrackOptions
implements IOptionPage {
    private final EntityTrackUpgradeHandler renderHandler;
    private GuiTextField textField;
    private GuiButtonSpecial warningButton;
    private int sendTimer = 0;

    public GuiEntityTrackOptions(EntityTrackUpgradeHandler renderHandler) {
        this.renderHandler = renderHandler;
    }

    @Override
    public String getPageName() {
        return "Entity Tracker";
    }

    @Override
    public void initGui(IGuiScreen gui) {
        gui.getButtonList().add(new GuiButton(10, 30, 128, 150, 20, "Move Stat Screen..."));
        this.textField = new GuiTextField(-1, gui.getFontRenderer(), 35, 60, 140, 10);
        this.textField.func_146195_b(true);
        if (PneumaticCraftRepressurized.proxy.getClientPlayer() != null) {
            this.textField.func_146180_a(ItemPneumaticArmor.getEntityFilter(PneumaticCraftRepressurized.proxy.getClientPlayer().func_184582_a(EntityEquipmentSlot.HEAD)));
        }
        this.warningButton = new GuiButtonSpecial(1, 175, 57, 20, 20, "");
        this.warningButton.setVisible(false);
        this.warningButton.field_146125_m = false;
        this.warningButton.setRenderedIcon(Textures.GUI_PROBLEMS_TEXTURE);
        gui.getButtonList().add(this.warningButton);
        this.validateEntityFilter(this.textField.func_146179_b());
    }

    @Override
    public void actionPerformed(GuiButton button) {
        if (button.field_146127_k == 10) {
            Minecraft.func_71410_x().field_71439_g.func_71053_j();
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMoveStat(this.renderHandler, ArmorHUDLayout.LayoutTypes.ENTITY_TRACKER));
        }
    }

    @Override
    public void drawPreButtons(int x, int y, float partialTicks) {
    }

    @Override
    public void drawScreen(int x, int y, float partialTicks) {
        this.textField.func_146194_f();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        fontRenderer.func_78276_b(I18n.func_135052_a((String)"gui.entityFilter", (Object[])new Object[0]), 35, 50, -1);
        if (Keyboard.isKeyDown((int)59)) {
            GuiUtils.showPopupHelpScreen(Minecraft.func_71410_x().field_71462_r, fontRenderer, PneumaticCraftUtils.convertStringIntoList(I18n.func_135052_a((String)"gui.entityFilter.helpText", (Object[])new Object[0]), 60));
        }
    }

    @Override
    public void keyTyped(char ch, int key) {
        if (this.textField != null && this.textField.func_146206_l() && key != 1) {
            this.textField.func_146201_a(ch, key);
            if (this.validateEntityFilter(this.textField.func_146179_b())) {
                this.sendTimer = 5;
            }
        }
    }

    private boolean validateEntityFilter(String filter) {
        try {
            this.warningButton.field_146125_m = false;
            this.warningButton.setTooltipText("");
            EntityFilter f = new EntityFilter(filter);
            return true;
        }
        catch (Exception e) {
            this.warningButton.field_146125_m = true;
            this.warningButton.setTooltipText(TextFormatting.GOLD + e.getMessage());
            return false;
        }
    }

    @Override
    public void updateScreen() {
        if (this.sendTimer > 0 && --this.sendTimer == 0) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("entityFilter", this.textField.func_146179_b());
            NetworkHandler.sendToServer(new PacketUpdateArmorExtraData(EntityEquipmentSlot.HEAD, tag));
        }
    }

    @Override
    public void mouseClicked(int x, int y, int button) {
    }

    @Override
    public void handleMouseInput() {
    }

    @Override
    public boolean canBeTurnedOff() {
        return true;
    }

    @Override
    public boolean displaySettingsText() {
        return true;
    }
}

