/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.processor;

import java.util.List;
import nc.recipe.NCRecipes;
import nc.recipe.ProcessorRecipe;
import nc.recipe.ProcessorRecipeHandler;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energyFluid.IBufferable;

public interface IProcessor
extends IInterfaceable,
IBufferable {
    public ProcessorRecipeHandler getRecipeHandler();

    public void refreshRecipe();

    public void refreshActivity();

    public void refreshActivityOnProduction();

    public static double maxStat(NCRecipes.Type recipeType, int i) {
        double max = 1.0;
        List recipes = recipeType.getRecipeHandler().getRecipes();
        for (ProcessorRecipe recipe : recipes) {
            if (recipe == null || recipe.extras().size() <= i || !(recipe.extras().get(i) instanceof Double)) continue;
            max = Math.max(max, (Double)recipe.extras().get(i));
        }
        return max;
    }

    public static double maxBaseProcessTime(NCRecipes.Type recipeType, int defaultProcessTime) {
        return IProcessor.maxStat(recipeType, 0) * (double)defaultProcessTime;
    }

    public static double maxBaseProcessPower(NCRecipes.Type recipeType, int defaultProcessPower) {
        return IProcessor.maxStat(recipeType, 1) * (double)defaultProcessPower;
    }

    public static int getCapacity(NCRecipes.Type recipeType, int defaultProcessTime, double speedMultiplier, int defaultProcessPower, double powerMultiplier) {
        return Math.max(1, (int)Math.round(Math.ceil(IProcessor.maxBaseProcessTime(recipeType, defaultProcessTime) / speedMultiplier))) * Math.min(Integer.MAX_VALUE, (int)(IProcessor.maxBaseProcessPower(recipeType, defaultProcessPower) * powerMultiplier));
    }
}

