/*
 * Decompiled with CFR 0.152.
 */
package nc.tile.energyFluid;

import javax.annotation.Nonnull;
import nc.config.NCConfig;
import nc.tile.dummy.IInterfaceable;
import nc.tile.energy.IEnergySpread;
import nc.tile.energy.ITileEnergy;
import nc.tile.energyFluid.IBufferable;
import nc.tile.energyFluid.TileEnergyFluidSidedInventory;
import nc.tile.fluid.IFluidSpread;
import nc.tile.fluid.ITileFluid;
import nc.tile.internal.energy.EnergyConnection;
import nc.tile.internal.fluid.TankSorption;
import nc.tile.internal.inventory.ItemSorption;
import nc.tile.inventory.ITileInventory;
import nc.util.NCInventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileBuffer
extends TileEnergyFluidSidedInventory
implements IInterfaceable,
IEnergySpread,
IFluidSpread {
    private int pushCount;

    public TileBuffer() {
        super("buffer", 1, ITileInventory.inventoryConnectionAll(ItemSorption.BOTH), 64000, ITileEnergy.energyConnectionAll(EnergyConnection.BOTH), 32000, null, ITileFluid.fluidConnectionAll(TankSorption.BOTH));
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            if (this.pushCount == 0) {
                this.pushStacks();
                this.pushEnergy();
                this.pushFluid();
            }
            this.tickPush();
        }
    }

    public void tickPush() {
        ++this.pushCount;
        this.pushCount %= NCConfig.machine_update_rate;
    }

    @Override
    public void pushStacksToSide(@Nonnull EnumFacing side) {
        TileEntity tile = this.getTileWorld().func_175625_s(this.getTilePos().func_177972_a(side));
        if (!(tile instanceof IBufferable)) {
            return;
        }
        IItemHandler adjInv = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjInv == null || adjInv.getSlots() < 1) {
            return;
        }
        for (int i = 0; i < this.getInventoryStacks().size(); ++i) {
            ItemStack initialStack;
            ItemStack inserted;
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190926_b() || (inserted = NCInventoryHelper.addStackToInventory(adjInv, initialStack = ((ItemStack)this.getInventoryStacks().get(i)).func_77946_l())).func_190916_E() >= initialStack.func_190916_E()) continue;
            ((ItemStack)this.getInventoryStacks().get(i)).func_190918_g(initialStack.func_190916_E() - inserted.func_190916_E());
            if (((ItemStack)this.getInventoryStacks().get(i)).func_190916_E() > 0) continue;
            this.getInventoryStacks().set(i, (Object)ItemStack.field_190927_a);
        }
    }

    @Override
    public void pushFluidToSide(@Nonnull EnumFacing side) {
        if (!this.getFluidConnection(side).getTankSorption(0).canDrain()) {
            return;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(side));
        if (!(tile instanceof IBufferable)) {
            return;
        }
        IFluidHandler adjStorage = (IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, side.func_176734_d());
        if (adjStorage == null) {
            return;
        }
        for (int i = 0; i < this.getTanks().size(); ++i) {
            if (this.getTanks().get(i).getFluid() == null || !this.getTankSorption(side, i).canDrain()) {
                return;
            }
            this.getTanks().get(i).drain(adjStorage.fill(this.getTanks().get(i).drain(this.getTanks().get(i).getCapacity(), false), true), true);
        }
    }

    @Override
    public int getEUSourceTier() {
        return 1;
    }

    @Override
    public int getEUSinkTier() {
        return 10;
    }
}

