/*
 * Decompiled with CFR 0.152.
 */
package nc.recipe.processor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import nc.recipe.ProcessorRecipeHandler;
import nc.recipe.ingredient.OreIngredient;
import nc.util.OreDictHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;

public class AlloyFurnaceRecipes
extends ProcessorRecipeHandler {
    private static final List<String> SILICON = Lists.newArrayList((Object[])new String[]{"itemSilicon", "ingotSilicon"});
    private static final List<Object> ENDER_PEARL = Lists.newArrayList((Object[])new Object[]{Items.field_151079_bi, "dustEnder"});

    public AlloyFurnaceRecipes() {
        super("alloy_furnace", 2, 0, 1, 0);
    }

    @Override
    public void addRecipes() {
        this.addAlloyIngotIngotRecipes("Copper", 3, "Tin", 1, "Bronze", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Iron", 1, "Graphite", 1, "Steel", 1, 1.0, 1.0);
        this.addAlloyIngotCoalRecipes("Iron", 1, 2, "Steel", 1, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Steel", 1, "Boron", 1, "Ferroboron", 2, 1.0, 1.5);
        this.addAlloyIngotIngotRecipes("Ferroboron", 1, "Lithium", 1, "Tough", 2, 1.5, 1.5);
        this.addAlloyIngotGemRecipes("Graphite", 2, "Diamond", 1, "HardCarbon", 2, 1.0, 2.0);
        this.addAlloyIngotIngotRecipes("Magnesium", 1, "Boron", 2, "MagnesiumDiboride", 3, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Lithium", 1, "ManganeseDioxide", 1, "LithiumManganeseDioxide", 2, 1.5, 1.0);
        this.addAlloyIngotIngotRecipes("Copper", 3, "Silver", 1, "Shibuichi", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Tin", 3, "Silver", 1, "TinSilver", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Lead", 3, "Platinum", 1, "LeadPlatinum", 4, 1.5, 0.5);
        this.addAlloyIngotIngotRecipes("Tough", 1, "HardCarbon", 1, "Extreme", 1, 2.0, 2.0);
        this.addAlloyIngotGemRecipes("Extreme", 1, "BoronArsenide", 1, "Thermoconducting", 2, 1.5, 1.5);
        this.addAlloyIngotIngotRecipes("Zirconium", 7, "Tin", 1, "Zircaloy", 8, 4.0, 1.0);
        this.addRecipe(SILICON, AlloyFurnaceRecipes.metalList("Graphite"), AlloyFurnaceRecipes.oreStack("ingotSiliconCarbide", 2), 2.0, 2.0);
        this.addAlloyIngotIngotRecipes("Iron", 15, "CarbonManganese", 1, "HSLASteel", 16, 8.0, 2.0);
        this.addAlloyIngotIngotRecipes("Aluminum", 3, "Copper", 1, "AluminumBrass", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminium", 3, "Copper", 1, "AluminumBrass", 4, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Cobalt", 1, "Ardite", 1, "Manyullyn", 1, 2.0, 2.0);
        this.addAlloyIngotIngotRecipes("Gold", 1, "Silver", 1, "Electrum", 2, 1.0, 0.5);
        this.addAlloyIngotIngotRecipes("Iron", 2, "Nickel", 1, "Invar", 3, 1.0, 1.5);
        this.addAlloyIngotIngotRecipes("Copper", 1, "Nickel", 1, "Constantan", 2, 1.0, 1.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Steel"), SILICON, "ingotElectricalSteel", 1.5, 1.5);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Gold"), AlloyFurnaceRecipes.oreStack("dustEnergetic", 2), "ingotEnergeticAlloy", 1.0, 1.5);
        this.addRecipe(AlloyFurnaceRecipes.metalList("EnergeticAlloy"), ENDER_PEARL, "ingotVibrantAlloy", 1.5, 2.0);
        this.addRecipe(SILICON, "dustRedstone", "ingotRedstoneAlloy", 1.0, 1.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Iron"), "dustRedstone", "ingotConductiveIron", 1.0, 1.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Iron"), ENDER_PEARL, "ingotPulsatingIron", 1.5, 1.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Steel"), "obsidian", "ingotDarkSteel", 1.5, 2.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Gold"), Blocks.field_150425_aM, "ingotSoularium", 1.5, 0.5);
        this.addRecipe("ingotDarkSteel", AlloyFurnaceRecipes.oreStack("dustDimensional", 2), "ingotEndSteel", 2.0, 2.0);
        this.addRecipe(AlloyFurnaceRecipes.oreStackList(AlloyFurnaceRecipes.metalList("Lead"), 2), AlloyFurnaceRecipes.metalList("Iron"), AlloyFurnaceRecipes.oreStack("ingotConstructionAlloy", 3), 1.0, 1.0);
        this.addRecipe(AlloyFurnaceRecipes.gemList("Diamond"), AlloyFurnaceRecipes.oreStack("nuggetPulsatingIron", 8), "itemPulsatingCrystal", 1.0, 1.5);
        this.addRecipe(AlloyFurnaceRecipes.gemList("Emerald"), AlloyFurnaceRecipes.oreStack("nuggetVibrantAlloy", 8), "itemVibrantCrystal", 1.0, 1.5);
        this.addRecipe("itemClay", "gravel", "ingotCrudeSteel", 0.5, 1.0);
        this.addRecipe("ingotGold", "itemPulsatingPowder", "ingotCrystallineAlloy", 1.0, 1.0);
        this.addRecipe("ingotEndSteel", Items.field_185162_cT, "ingotMelodicAlloy", 2.0, 1.5);
        this.addRecipe("ingotMelodicAlloy", "netherStar", AlloyFurnaceRecipes.oreStack("ingotStellarAlloy", 2), 2.0, 2.0);
        this.addRecipe(AlloyFurnaceRecipes.metalList("Silver"), AlloyFurnaceRecipes.oreStack("dustEnergetic", 2), "ingotEnergeticSilver", 1.0, 1.5);
        this.addRecipe(AlloyFurnaceRecipes.metalList("EnergeticSilver"), ENDER_PEARL, "ingotVividAlloy", 1.5, 2.0);
        this.addAlloyIngotIngotRecipes("Copper", 3, "Zinc", 1, "Brass", 4, 1.0, 1.0);
        this.addAlloyIngotDustRecipes("Gold", 1, "Redstone", 2, "ingotRedmetal", 1, 1.0, 1.0);
        this.addAlloyIngotFuelRecipes("Iron", 2, "Coke", 1, "Steel", 2, 1.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminum", 7, "Titanium", 3, "TitaniumAluminide", 3, 3.0, 1.0);
        this.addAlloyIngotIngotRecipes("Aluminium", 7, "Titanium", 3, "TitaniumAluminide", 3, 3.0, 1.0);
        this.addAlloyIngotIngotRecipes("Titanium", 1, "Iridium", 1, "TitaniumIridium", 2, 1.5, 2.0);
    }

    public void addAlloyIngotIngotRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotDustRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.DUST_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotFuelRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.FUEL_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyIngotGemRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power) {
        this.addAlloyRecipes(in1, inSize1, in2, inSize2, out, outSize, time, power, OreDictHelper.NUGGET_VOLUME_TYPES, OreDictHelper.INGOT_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES, OreDictHelper.TINYDUST_VOLUME_TYPES, OreDictHelper.GEM_VOLUME_TYPES, OreDictHelper.BLOCK_VOLUME_TYPES);
    }

    public void addAlloyRecipes(String in1, int inSize1, String in2, int inSize2, String out, int outSize, double time, double power, List<String> inNuggets1, List<String> inIngots1, List<String> inBlocks1, List<String> inNuggets2, List<String> inIngots2, List<String> inBlocks2) {
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, inIngots1, inSize1), AlloyFurnaceRecipes.typeStackList(in2, inIngots2, inSize2), AlloyFurnaceRecipes.oreStack("ingot" + out, outSize), time, power);
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, inNuggets1, inSize1), AlloyFurnaceRecipes.typeStackList(in2, inNuggets2, inSize2), AlloyFurnaceRecipes.oreStack("nugget" + out, outSize), time / 9.0, power);
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, inBlocks1, inSize1), AlloyFurnaceRecipes.typeStackList(in2, inBlocks2, inSize2), AlloyFurnaceRecipes.oreStack("block" + out, outSize), time * 9.0, power);
    }

    public void addAlloyIngotCoalRecipes(String in1, int inSize1, int inSize2, String out, int outSize, double time, double power) {
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, OreDictHelper.INGOT_VOLUME_TYPES, inSize1), AlloyFurnaceRecipes.typeStackList("", OreDictHelper.COAL_TYPES, inSize2), AlloyFurnaceRecipes.oreStack("ingot" + out, outSize), time, power);
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, OreDictHelper.NUGGET_VOLUME_TYPES, inSize1), AlloyFurnaceRecipes.typeStackList("Coal", OreDictHelper.TINYDUST_VOLUME_TYPES, inSize2), AlloyFurnaceRecipes.oreStack("nugget" + out, outSize), time / 9.0, power);
        this.addRecipe(AlloyFurnaceRecipes.typeStackList(in1, OreDictHelper.BLOCK_VOLUME_TYPES, inSize1), AlloyFurnaceRecipes.typeStackList("Coal", OreDictHelper.BLOCK_VOLUME_TYPES, inSize2), AlloyFurnaceRecipes.oreStack("block" + out, outSize), time * 9.0, power);
    }

    private static ArrayList<OreIngredient> typeStackList(String type, List<String> forms, int size) {
        ArrayList<OreIngredient> list = new ArrayList<OreIngredient>();
        for (String form : forms) {
            list.add(AlloyFurnaceRecipes.oreStack(form + type, size));
        }
        return list;
    }

    private static List<String> metalList(String name) {
        return Lists.newArrayList((Object[])new String[]{"ingot" + name, "dust" + name});
    }

    private static List<String> gemList(String name) {
        return Lists.newArrayList((Object[])new String[]{"gem" + name, "dust" + name});
    }
}

