/*
 * Decompiled with CFR 0.152.
 */
package nc.multiblock.gui;

import java.util.ArrayList;
import java.util.List;
import nc.multiblock.gui.GuiMultiblockController;
import nc.multiblock.gui.element.MultiblockButton;
import nc.multiblock.network.ClearAllFluidsPacket;
import nc.multiblock.saltFission.SaltFissionReactor;
import nc.network.PacketHandler;
import nc.util.Lang;
import nc.util.NCMath;
import nc.util.StringHelper;
import nc.util.UnitHelper;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class GuiSaltFissionController
extends GuiMultiblockController<SaltFissionReactor> {
    protected final ResourceLocation gui_texture = new ResourceLocation("nuclearcraft:textures/gui/container/salt_fission_controller.png");

    public GuiSaltFissionController(SaltFissionReactor multiblock, BlockPos controllerPos, Container container) {
        super(multiblock, controllerPos, container);
        this.field_146999_f = 176;
        this.field_147000_g = 114;
    }

    @Override
    protected ResourceLocation getGuiTexture() {
        return this.gui_texture;
    }

    @Override
    public void renderTooltips(int mouseX, int mouseY) {
        if (GuiSaltFissionController.func_146272_n()) {
            this.drawTooltip(this.clearAllFluidsInfo(), mouseX, mouseY, 162, 81, 9, 9);
        }
        this.drawEfficiencyTooltip(mouseX, mouseY, 6, 93, 164, 6);
        this.drawHeatTooltip(mouseX, mouseY, 6, 103, 164, 6);
    }

    public List<String> efficiencyInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.AQUA + Lang.localise("gui.container.salt_fission_controller.raw_efficiency") + " " + TextFormatting.WHITE + NCMath.round(((SaltFissionReactor)this.multiblock).rawEfficiency * 100.0, 1) + "%");
        info.add(TextFormatting.YELLOW + Lang.localise("gui.container.salt_fission_controller.heat_mult") + " " + TextFormatting.WHITE + NCMath.round(((SaltFissionReactor)this.multiblock).heatMult * 100.0, 1) + "%");
        info.add(TextFormatting.BLUE + Lang.localise("gui.container.salt_fission_controller.cooling_efficiency") + " " + TextFormatting.WHITE + NCMath.round(((SaltFissionReactor)this.multiblock).coolingEfficiency * 100.0, 1) + "%");
        return info;
    }

    public void drawEfficiencyTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.efficiencyInfo(), mouseX, mouseY, x, y, width, height);
    }

    public List<String> heatInfo() {
        ArrayList<String> info = new ArrayList<String>();
        info.add(TextFormatting.YELLOW + Lang.localise("gui.container.salt_fission_controller.heat_stored") + " " + TextFormatting.WHITE + UnitHelper.prefix((long)((int)((SaltFissionReactor)this.multiblock).heatBuffer.heatStored), (long)((int)((SaltFissionReactor)this.multiblock).heatBuffer.heatCapacity), 6, "H"));
        info.add(TextFormatting.YELLOW + Lang.localise("gui.container.salt_fission_controller.net_heat_gen") + " " + TextFormatting.WHITE + UnitHelper.prefix((int)((SaltFissionReactor)this.multiblock).getNetHeatingRate(false), 6, "H/t"));
        info.add(TextFormatting.BLUE + Lang.localise("gui.container.salt_fission_controller.cooling_rate") + " " + TextFormatting.WHITE + UnitHelper.prefix((int)(-((SaltFissionReactor)this.multiblock).cooling), 6, "H/t"));
        return info;
    }

    public void drawHeatTooltip(int mouseX, int mouseY, int x, int y, int width, int height) {
        this.drawTooltip(this.heatInfo(), mouseX, mouseY, x, y, width, height);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        int fontColor = ((SaltFissionReactor)this.multiblock).isReactorOn ? -1 : 0xEEAA00;
        String title = ((SaltFissionReactor)this.multiblock).getInteriorLengthX() + "*" + ((SaltFissionReactor)this.multiblock).getInteriorLengthY() + "*" + ((SaltFissionReactor)this.multiblock).getInteriorLengthZ() + " " + Lang.localise("gui.container.salt_fission_controller.reactor");
        this.field_146289_q.func_78276_b(title, this.field_146999_f / 2 - this.width(title) / 2, 6, fontColor);
        String underline = StringHelper.charLine('-', MathHelper.func_76143_f((double)((double)this.width(title) / (double)this.width("-"))));
        this.field_146289_q.func_78276_b(underline, this.field_146999_f / 2 - this.width(underline) / 2, 12, fontColor);
        String vessels = Lang.localise("gui.container.salt_fission_controller.vessels") + " " + ((SaltFissionReactor)this.multiblock).getVessels().size();
        this.field_146289_q.func_78276_b(vessels, this.field_146999_f / 2 - this.width(vessels) / 2, 24, fontColor);
        String heaters = Lang.localise("gui.container.salt_fission_controller.heaters") + " " + ((SaltFissionReactor)this.multiblock).getHeaters().size();
        this.field_146289_q.func_78276_b(heaters, this.field_146999_f / 2 - this.width(heaters) / 2, 36, fontColor);
        String coolingRate = Lang.localise("gui.container.salt_fission_controller.cooling_efficiency") + " " + (int)(((SaltFissionReactor)this.multiblock).coolingEfficiency * 100.0) + "%";
        this.field_146289_q.func_78276_b(coolingRate, this.field_146999_f / 2 - this.width(coolingRate) / 2, 52, fontColor);
        String heat_gen = Lang.localise("gui.container.salt_fission_controller.net_heat_gen") + " " + UnitHelper.prefix((int)((SaltFissionReactor)this.multiblock).getNetHeatingRate(false), 6, "H/t");
        this.field_146289_q.func_78276_b(heat_gen, this.field_146999_f / 2 - this.width(heat_gen) / 2, 64, fontColor);
        String cooling = Lang.localise("gui.container.salt_fission_controller.cooling_rate") + " " + UnitHelper.prefix((int)(-((SaltFissionReactor)this.multiblock).cooling), 6, "H/t");
        this.field_146289_q.func_78276_b(cooling, this.field_146999_f / 2 - this.width(cooling) / 2, 76, fontColor);
    }

    @Override
    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        super.func_146976_a(partialTicks, mouseX, mouseY);
        int e = (int)Math.round(((SaltFissionReactor)this.multiblock).coolingEfficiency / ((SaltFissionReactor)this.multiblock).rawEfficiency * 164.0);
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 92, 3, 114, e, 6);
        int h = (int)Math.round((double)((SaltFissionReactor)this.multiblock).heatBuffer.heatStored / (double)((SaltFissionReactor)this.multiblock).heatBuffer.heatCapacity * 164.0);
        this.func_73729_b(this.field_147003_i + 6, this.field_147009_r + 102, 3, 120, h, 6);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new MultiblockButton.ButtonClearAllFluids(0, this.field_147003_i + 162, this.field_147009_r + 81));
    }

    protected void func_146284_a(GuiButton guiButton) {
        if (((SaltFissionReactor)this.multiblock).WORLD.field_72995_K && guiButton.field_146127_k == 0 && GuiSaltFissionController.func_146272_n()) {
            PacketHandler.instance.sendToServer((IMessage)new ClearAllFluidsPacket(this.controllerPos));
        }
    }
}

