/*
 * Decompiled with CFR 0.152.
 */
package nc.capability.radiation.entity;

import nc.capability.radiation.entity.IEntityRads;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public class EntityRads
implements IEntityRads {
    private final double maxRads;
    private double totalRads = 0.0;
    private double radiationLevel = 0.0;
    private double radiationResistance = 0.0;
    private boolean radXWoreOff = false;
    private double radawayBuffer = 0.0;
    private double radawayBufferSlow = 0.0;
    private double poisonBuffer = 0.0;
    private boolean consumed = false;
    private double radawayCooldown = 0.0;
    private double radXCooldown = 0.0;
    private double radiationImmunityTime = 0.0;
    private boolean shouldWarn = false;

    public EntityRads(double maxRads) {
        this.maxRads = maxRads;
    }

    @Override
    public NBTTagCompound writeNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        nbt.func_74780_a("totalRads", this.totalRads);
        nbt.func_74780_a("radiationLevel", this.radiationLevel);
        nbt.func_74780_a("radiationResistance", this.radiationResistance);
        nbt.func_74757_a("radXWoreOff", this.radXWoreOff);
        nbt.func_74780_a("radawayBuffer", this.radawayBuffer);
        nbt.func_74780_a("radawayBufferSlow", this.radawayBufferSlow);
        nbt.func_74780_a("poisonBuffer", this.poisonBuffer);
        nbt.func_74757_a("consumed", this.consumed);
        nbt.func_74780_a("radawayCooldown", this.radawayCooldown);
        nbt.func_74780_a("radXCooldown", this.radXCooldown);
        nbt.func_74780_a("radiationImmunityTime", this.radiationImmunityTime);
        nbt.func_74757_a("shouldWarn", this.shouldWarn);
        return nbt;
    }

    @Override
    public void readNBT(IEntityRads instance, EnumFacing side, NBTTagCompound nbt) {
        this.totalRads = nbt.func_74769_h("totalRads");
        this.radiationLevel = nbt.func_74769_h("radiationLevel");
        this.radiationResistance = nbt.func_74769_h("radiationResistance");
        this.radXWoreOff = nbt.func_74767_n("radXWoreOff");
        this.radawayBuffer = nbt.func_74769_h("radawayBuffer");
        this.radawayBufferSlow = nbt.func_74769_h("radawayBufferSlow");
        this.poisonBuffer = nbt.func_74769_h("poisonBuffer");
        this.consumed = nbt.func_74767_n("consumed");
        this.radawayCooldown = nbt.func_74769_h("radawayCooldown");
        this.radXCooldown = nbt.func_74769_h("radXCooldown");
        this.radiationImmunityTime = nbt.func_74769_h("radiationImmunityTime");
        this.shouldWarn = nbt.func_74767_n("shouldWarn");
    }

    @Override
    public double getTotalRads() {
        return this.totalRads;
    }

    @Override
    public void setTotalRads(double newTotalRads, boolean useImmunity) {
        if (!useImmunity || this.getRadiationImmunityTime() <= 0.0) {
            this.totalRads = MathHelper.func_151237_a((double)newTotalRads, (double)0.0, (double)this.maxRads);
        }
    }

    @Override
    public double getMaxRads() {
        return this.maxRads;
    }

    @Override
    public double getRadiationLevel() {
        return this.radiationLevel;
    }

    @Override
    public void setRadiationLevel(double newRadiationLevel) {
        this.radiationLevel = Math.max(newRadiationLevel, 0.0);
    }

    @Override
    public double getRadiationResistance() {
        return this.radiationResistance;
    }

    @Override
    public void setRadiationResistance(double newRadiationResistance) {
        this.radiationResistance = Math.max(newRadiationResistance, 0.0);
    }

    @Override
    public boolean getRadXWoreOff() {
        return this.radXWoreOff;
    }

    @Override
    public void setRadXWoreOff(boolean radXWoreOff) {
        this.radXWoreOff = radXWoreOff;
    }

    @Override
    public double getRadawayBuffer(boolean slow) {
        return slow ? this.radawayBufferSlow : this.radawayBuffer;
    }

    @Override
    public void setRadawayBuffer(boolean slow, double newBuffer) {
        if (slow) {
            this.radawayBufferSlow = Math.max(newBuffer, 0.0);
        } else {
            this.radawayBuffer = Math.max(newBuffer, 0.0);
        }
    }

    @Override
    public double getPoisonBuffer() {
        return this.poisonBuffer;
    }

    @Override
    public void setPoisonBuffer(double newBuffer, double maxLevel) {
        this.poisonBuffer = MathHelper.func_151237_a((double)newBuffer, (double)0.0, (double)maxLevel);
    }

    @Override
    public boolean getConsumedMedicine() {
        return this.consumed;
    }

    @Override
    public void setConsumedMedicine(boolean consumed) {
        this.consumed = consumed;
    }

    @Override
    public double getRadawayCooldown() {
        return this.radawayCooldown;
    }

    @Override
    public void setRadawayCooldown(double cooldown) {
        this.radawayCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadaway() {
        return !this.consumed && this.radawayCooldown <= 0.0;
    }

    @Override
    public double getRadXCooldown() {
        return this.radXCooldown;
    }

    @Override
    public void setRadXCooldown(double cooldown) {
        this.radXCooldown = Math.max(cooldown, 0.0);
    }

    @Override
    public boolean canConsumeRadX() {
        return !this.consumed && this.radXCooldown <= 0.0;
    }

    @Override
    public double getRadiationImmunityTime() {
        return this.radiationImmunityTime;
    }

    @Override
    public void setRadiationImmunityTime(double newRadiationImmunityTime) {
        this.radiationImmunityTime = Math.max(newRadiationImmunityTime, 0.0);
    }

    @Override
    public boolean getShouldWarn() {
        return this.shouldWarn;
    }

    @Override
    public void setShouldWarn(boolean shouldWarn) {
        this.shouldWarn = shouldWarn;
    }
}

