/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.intermod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.UBLogger;
import exterminatorjeff.undergroundbiomes.api.common.UBModOreRegistrar;
import exterminatorjeff.undergroundbiomes.intermod.OresRegistry;
import exterminatorjeff.undergroundbiomes.intermod.UBOreConfig;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.Level;

public class ModOreRegistrar
implements UBModOreRegistrar {
    private static final UBLogger LOGGER = new UBLogger(OresRegistry.class, Level.INFO);
    private final File directory;
    private HashMap<String, UBOreConfig> ores = new HashMap();
    private final Type jsonType = new TypeToken<ArrayList<UBOreConfig>>(){}.getType();

    public ModOreRegistrar(FMLPreInitializationEvent event) {
        this.directory = Paths.get(event.getModConfigurationDirectory().toString(), "undergroundbiomes", "ores").toFile();
        try {
            Files.createDirectories(this.directory.toPath(), new FileAttribute[0]);
            this.createDefaults();
            this.setupOres();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void requestOreSetup(RegistryEvent.Register<Block> event, UBOreConfig ore) {
        ResourceLocation location = new ResourceLocation(ore.getInternalOreName());
        IForgeRegistry registry = event.getRegistry();
        if (!registry.containsKey(location)) {
            return;
        }
        Block block = (Block)registry.getValue(location);
        API.ORES_REGISTRY.requestOreSetup(block, ore);
        API.ORES_REGISTRY.registerOreOverlay(block, ore.getMeta(), new ResourceLocation(ore.getOverlay()));
    }

    @Override
    public void requestOreSetups(RegistryEvent.Register<Block> event) {
        for (UBOreConfig ore : this.ores.values()) {
            this.requestOreSetup(event, ore);
        }
    }

    private void createDefaults() {
        this.writeDefaults(this.getMinecraftOres(), "minecraft.json");
        this.writeDefaults(this.getNuclearcraftOres(), "nuclearcraft.json");
        this.writeDefaults(this.getGrowthcraftOres(), "growthcraft.json");
        this.writeDefaults(this.getActuallyAdditionsOres(), "actuallyadditions.json");
        this.writeDefaults(this.getAppliedEnergisticsOres(), "appliedenergistics2.json");
        this.writeDefaults(this.getBaseMetalsOres(), "basemetals.json");
        this.writeDefaults(this.getBaseMineralsOres(), "baseminerals.json");
        this.writeDefaults(this.getBiomesOPlentyOres(), "biomesoplenty.json");
        this.writeDefaults(this.getBetterUndergroundOres(), "betterunderground.json");
        this.writeDefaults(this.getDraconicEvolutionOres(), "draconicevolution.json");
        this.writeDefaults(this.getEnderOreOres(), "enderore.json");
        this.writeDefaults(this.getExtremeReactorsOres(), "extremereactors.json");
        this.writeDefaults(this.getForestyOres(), "forestry.json");
        this.writeDefaults(this.getImmersiveEngineeringOres(), "immersiveengineering.json");
        this.writeDefaults(this.getIndustrialCraftOres(), "industrialcraft.json");
        this.writeDefaults(this.getMekanismOres(), "mekanism.json");
        this.writeDefaults(this.getModernMetalsOres(), "modernmetals.json");
        this.writeDefaults(this.getRFToolsOres(), "rftools.json");
        this.writeDefaults(this.getTechRebornOres(), "techreborn.json");
        this.writeDefaults(this.getThermalFoundationOres(), "thermalfoundation.json");
        this.writeDefaults(this.getThaumcraftOres(), "thaumcraft.json");
        this.writeDefaults(this.getGeolosysOres(), "geolosys.json");
        this.writeDefaults(this.getMysticalAgricultureOres(), "mysticalagriculture.json");
        this.writeDefaults(this.getMatterOverdriveLegacyOres(), "matteroverdrivelegacy.json");
        this.writeDefaults(this.getTaigaOres(), "taiga.json");
        this.writeDefaults(this.getMetallurgy4Ores(), "metallurgy4.json");
        this.writeDefaults(this.getProjectRedOres(), "projectred.json");
        this.writeDefaults(this.getPoorMetalsOres(), "poormetals.json");
        this.writeDefaults(this.getDenseMetalsOres(), "densemetals.json");
    }

    private void writeDefaults(ArrayList<UBOreConfig> ores, String filename) {
        try {
            Path filepath = Paths.get(this.directory.toString(), filename);
            if (!filepath.toFile().exists()) {
                Gson gson = new GsonBuilder().setPrettyPrinting().create();
                String json = gson.toJson(ores, this.jsonType);
                Files.write(filepath, Arrays.asList(json.split("\n")), Charset.forName("UTF-8"), new OpenOption[0]);
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void setupOres() {
        for (File fileEntry : this.directory.listFiles()) {
            if (!fileEntry.isFile() || !FilenameUtils.getExtension((String)fileEntry.getPath()).equals("json")) continue;
            this.readFile(fileEntry);
        }
    }

    private void readFile(File file) {
        try {
            Gson gson = new Gson();
            String json = null;
            json = FileUtils.readFileToString((File)file, (String)"UTF8");
            ArrayList ores = (ArrayList)gson.fromJson(json, this.jsonType);
            if (ores != null) {
                for (int i = 0; i < ores.size(); ++i) {
                    UBOreConfig ore = (UBOreConfig)ores.get(i);
                    if (this.ores.containsKey(ore.toKey())) {
                        String message = "Ore " + ore.toKey() + " has already been defined elsewhere!\nFound while checking: " + file.getAbsolutePath();
                        if (API.SETTINGS.crashOnProblems()) {
                            LOGGER.fatal(message);
                        } else {
                            LOGGER.warn(message);
                        }
                    }
                    this.ores.put(ore.toKey(), ore);
                }
            } else {
                LOGGER.warn("No ores found in " + file.getPath());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<UBOreConfig> getMinecraftOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("minecraft:diamond_ore", "undergroundbiomes:blocks/overlays/minecraft/diamond"));
        ores.add(new UBOreConfig("minecraft:iron_ore", "undergroundbiomes:blocks/overlays/minecraft/iron"));
        ores.add(new UBOreConfig("minecraft:coal_ore", "undergroundbiomes:blocks/overlays/minecraft/coal"));
        ores.add(new UBOreConfig("minecraft:lapis_ore", "undergroundbiomes:blocks/overlays/minecraft/lapis"));
        ores.add(new UBOreConfig("minecraft:redstone_ore", "undergroundbiomes:blocks/overlays/minecraft/redstone"));
        ores.add(new UBOreConfig("minecraft:gold_ore", "undergroundbiomes:blocks/overlays/minecraft/gold"));
        ores.add(new UBOreConfig("minecraft:emerald_ore", "undergroundbiomes:blocks/overlays/minecraft/emerald"));
        return ores;
    }

    private ArrayList<UBOreConfig> getProjectRedOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("projectred-exploration:ore", 0, "undergroundbiomes:blocks/overlays/projectred/ruby_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 1, "undergroundbiomes:blocks/overlays/projectred/sapphire_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 2, "undergroundbiomes:blocks/overlays/projectred/peridot_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 3, "undergroundbiomes:blocks/overlays/projectred/copper_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 4, "undergroundbiomes:blocks/overlays/projectred/tin_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 5, "undergroundbiomes:blocks/overlays/projectred/silver_ore"));
        ores.add(new UBOreConfig("projectred-exploration:ore", 6, "undergroundbiomes:blocks/overlays/projectred/electrotine_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getActuallyAdditionsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "actuallyadditions:block_misc";
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/custom/black_quarz"));
        return ores;
    }

    private ArrayList<UBOreConfig> getAppliedEnergisticsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("appliedenergistics2:quartz_ore", "appliedenergistics2:blocks/charged_quartz_ore_light"));
        ores.add(new UBOreConfig("appliedenergistics2:charged_quartz_ore", "appliedenergistics2:blocks/charged_quartz_ore_light"));
        return ores;
    }

    private ArrayList<UBOreConfig> getGrowthcraftOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("growthcraft:salt_ore", "undergroundbiomes:blocks/overlays/growthcraft/salt_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getMetallurgy4Ores() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("metallurgy:adamantine_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/adamantine_ore"));
        ores.add(new UBOreConfig("metallurgy:astral_silver_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/astral_silver_ore"));
        ores.add(new UBOreConfig("metallurgy:atlarus_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/atlarus_ore"));
        ores.add(new UBOreConfig("metallurgy:bitumen_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/bitumen_ore"));
        ores.add(new UBOreConfig("metallurgy:carmot_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/carmot_ore"));
        ores.add(new UBOreConfig("metallurgy:copper_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/copper_ore"));
        ores.add(new UBOreConfig("metallurgy:deep_iron_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/deep_iron_ore"));
        ores.add(new UBOreConfig("metallurgy:infuscolium_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/infuscolium_ore"));
        ores.add(new UBOreConfig("metallurgy:lutetium_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/lutetium_ore"));
        ores.add(new UBOreConfig("metallurgy:magnesium_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/magnesium_ore"));
        ores.add(new UBOreConfig("metallurgy:manganese_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/manganese_ore"));
        ores.add(new UBOreConfig("metallurgy:mithril_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/mithril_ore"));
        ores.add(new UBOreConfig("metallurgy:orichalcum_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/orichalcum_ore"));
        ores.add(new UBOreConfig("metallurgy:osmium_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/osmium_ore"));
        ores.add(new UBOreConfig("metallurgy:oureclase_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/oureclase_ore"));
        ores.add(new UBOreConfig("metallurgy:phosphorite_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/phosphorite_ore"));
        ores.add(new UBOreConfig("metallurgy:platinum_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/platinum_ore"));
        ores.add(new UBOreConfig("metallurgy:potash_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/potash_ore"));
        ores.add(new UBOreConfig("metallurgy:prometheum_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/prometheum_ore"));
        ores.add(new UBOreConfig("metallurgy:rubracium_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/rubracium_ore"));
        ores.add(new UBOreConfig("metallurgy:salpeter_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/salpeter_ore"));
        ores.add(new UBOreConfig("metallurgy:silver_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/silver_ore"));
        ores.add(new UBOreConfig("metallurgy:sulfur_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/sulfur_ore"));
        ores.add(new UBOreConfig("metallurgy:tin_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/tin_ore"));
        ores.add(new UBOreConfig("metallurgy:zinc_ore", 0, "undergroundbiomes:blocks/overlays/metallurgy4/zinc_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getPoorMetalsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("poormetals:poor_aluminum_ore", 0, "poormetals:blocks/overworld/poor_aluminum_ore"));
        ores.add(new UBOreConfig("poormetals:poor_antimony_ore", 0, "poormetals:blocks/overworld/poor_antimony_ore"));
        ores.add(new UBOreConfig("poormetals:poor_beryllium_ore", 0, "poormetals:blocks/overworld/poor_beryllium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_bismuth_ore", 0, "poormetals:blocks/overworld/poor_bismuth_ore"));
        ores.add(new UBOreConfig("poormetals:poor_boron_ore", 0, "poormetals:blocks/overworld/poor_boron_ore"));
        ores.add(new UBOreConfig("poormetals:poor_cadmium_ore", 0, "poormetals:blocks/overworld/poor_cadmium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_chromium_ore", 0, "poormetals:blocks/overworld/poor_chromium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_copper_ore", 0, "poormetals:blocks/overworld/poor_copper_ore"));
        ores.add(new UBOreConfig("poormetals:poor_gold_ore", 0, "poormetals:blocks/overworld/poor_gold_ore"));
        ores.add(new UBOreConfig("poormetals:poor_iridium_ore", 0, "poormetals:blocks/overworld/poor_iridium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_iron_ore", 0, "poormetals:blocks/overworld/poor_iron_ore"));
        ores.add(new UBOreConfig("poormetals:poor_lead_ore", 0, "poormetals:blocks/overworld/poor_lead_ore"));
        ores.add(new UBOreConfig("poormetals:poor_maganese_ore", 0, "poormetals:blocks/overworld/poor_maganese_ore"));
        ores.add(new UBOreConfig("poormetals:poor_magnesium_ore", 0, "poormetals:blocks/overworld/poor_magnesium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_mercury_ore", 0, "poormetals:blocks/overworld/poor_mercury_ore"));
        ores.add(new UBOreConfig("poormetals:poor_nickel_ore", 0, "poormetals:blocks/overworld/poor_nickel_ore"));
        ores.add(new UBOreConfig("poormetals:poor_osmium_ore", 0, "poormetals:blocks/overworld/poor_osmium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_platinum_ore", 0, "poormetals:blocks/overworld/poor_platinum_ore"));
        ores.add(new UBOreConfig("poormetals:poor_plutonium_ore", 0, "poormetals:blocks/overworld/poor_plutonium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_rutile_ore", 0, "poormetals:blocks/overworld/poor_rutile_ore"));
        ores.add(new UBOreConfig("poormetals:poor_silver_ore", 0, "poormetals:blocks/overworld/poor_silver_ore"));
        ores.add(new UBOreConfig("poormetals:poor_tantalum_ore", 0, "poormetals:blocks/overworld/poor_tantalum_ore"));
        ores.add(new UBOreConfig("poormetals:poor_thorium_ore", 0, "poormetals:blocks/overworld/poor_thorium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_tin_ore", 0, "poormetals:blocks/overworld/poor_tin_ore"));
        ores.add(new UBOreConfig("poormetals:poor_titanium_ore", 0, "poormetals:blocks/overworld/poor_titanium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_tungsten_ore", 0, "poormetals:blocks/overworld/poor_tungsten_ore"));
        ores.add(new UBOreConfig("poormetals:poor_uranium_ore", 0, "poormetals:blocks/overworld/poor_uranium_ore"));
        ores.add(new UBOreConfig("poormetals:poor_zinc_ore", 0, "poormetals:blocks/overworld/poor_zinc_ore"));
        ores.add(new UBOreConfig("poormetals:poor_zirconium_ore", 0, "poormetals:blocks/overworld/poor_zirconium_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getNuclearcraftOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("nuclearcraft:ore", 0, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_copper"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 1, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_tin"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 2, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_lead"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 3, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_thorium"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 4, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_uranium"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 5, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_boron"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 6, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_lithium"));
        ores.add(new UBOreConfig("nuclearcraft:ore", 7, "undergroundbiomes:blocks/overlays/nuclearcraft/ore_magnesium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getMatterOverdriveLegacyOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("matteroverdrive:dilithium_ore", 0, "undergroundbiomes:blocks/overlays/matteroverdrivelegacy/dilithium_ore"));
        ores.add(new UBOreConfig("matteroverdrive:tritanium_ore", 0, "undergroundbiomes:blocks/overlays/matteroverdrivelegacy/tritanium_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getTaigaOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("taiga:dilithium_ore", 0, "undergroundbiomes:blocks/overlays/taiga/dilithium"));
        ores.add(new UBOreConfig("taiga:vibranium_ore", 0, "undergroundbiomes:blocks/overlays/taiga/vibranium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getGeolosysOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("geolosys:ore", 0, "undergroundbiomes:blocks/overlays/geolosys/hematite"));
        ores.add(new UBOreConfig("geolosys:ore", 1, "undergroundbiomes:blocks/overlays/geolosys/limonite"));
        ores.add(new UBOreConfig("geolosys:ore", 2, "undergroundbiomes:blocks/overlays/geolosys/malachite"));
        ores.add(new UBOreConfig("geolosys:ore", 3, "undergroundbiomes:blocks/overlays/geolosys/azurite"));
        ores.add(new UBOreConfig("geolosys:ore", 4, "undergroundbiomes:blocks/overlays/geolosys/cassiterite"));
        ores.add(new UBOreConfig("geolosys:ore", 5, "undergroundbiomes:blocks/overlays/geolosys/teallite"));
        ores.add(new UBOreConfig("geolosys:ore", 6, "undergroundbiomes:blocks/overlays/geolosys/galena"));
        ores.add(new UBOreConfig("geolosys:ore", 7, "undergroundbiomes:blocks/overlays/geolosys/bauxite"));
        ores.add(new UBOreConfig("geolosys:ore", 8, "undergroundbiomes:blocks/overlays/geolosys/platinum"));
        ores.add(new UBOreConfig("geolosys:ore", 9, "undergroundbiomes:blocks/overlays/geolosys/autunite"));
        ores.add(new UBOreConfig("geolosys:ore", 10, "undergroundbiomes:blocks/overlays/geolosys/sphalerite"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 0, "undergroundbiomes:blocks/overlays/geolosys/coal"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 1, "undergroundbiomes:blocks/overlays/geolosys/cinnabar"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 2, "undergroundbiomes:blocks/overlays/geolosys/gold"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 3, "undergroundbiomes:blocks/overlays/geolosys/lapis"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 4, "undergroundbiomes:blocks/overlays/geolosys/quartz"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 5, "undergroundbiomes:blocks/overlays/geolosys/kimberlite"));
        ores.add(new UBOreConfig("geolosys:ore_vanilla", 6, "undergroundbiomes:blocks/overlays/geolosys/beryl"));
        return ores;
    }

    private ArrayList<UBOreConfig> getBaseMetalsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("basemetals:antimony_ore", "undergroundbiomes:blocks/overlays/basemetals/antimony"));
        ores.add(new UBOreConfig("basemetals:bismuth_ore", "undergroundbiomes:blocks/overlays/basemetals/bismuth"));
        ores.add(new UBOreConfig("basemetals:copper_ore", "undergroundbiomes:blocks/overlays/thermalfoundation/copper"));
        ores.add(new UBOreConfig("basemetals:lead_ore", "undergroundbiomes:blocks/overlays/basemetals/lead"));
        ores.add(new UBOreConfig("basemetals:mercury_ore", "undergroundbiomes:blocks/overlays/basemetals/mercury"));
        ores.add(new UBOreConfig("basemetals:nickel_ore", "undergroundbiomes:blocks/overlays/basemetals/nickel"));
        ores.add(new UBOreConfig("basemetals:platinum_ore", "undergroundbiomes:blocks/overlays/basemetals/platinum"));
        ores.add(new UBOreConfig("basemetals:silver_ore", "undergroundbiomes:blocks/overlays/thermalfoundation/silver"));
        ores.add(new UBOreConfig("basemetals:tin_ore", "undergroundbiomes:blocks/overlays/basemetals/tin"));
        ores.add(new UBOreConfig("basemetals:zinc_ore", "undergroundbiomes:blocks/overlays/basemetals/zinc"));
        return ores;
    }

    private ArrayList<UBOreConfig> getBaseMineralsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("baseminerals:lithium_ore", "undergroundbiomes:blocks/overlays/baseminerals/lithium"));
        ores.add(new UBOreConfig("baseminerals:niter_ore", "undergroundbiomes:blocks/overlays/baseminerals/niter"));
        ores.add(new UBOreConfig("baseminerals:phosphorus_ore", "undergroundbiomes:blocks/overlays/baseminerals/phosphorus"));
        ores.add(new UBOreConfig("baseminerals:potash_ore", "undergroundbiomes:blocks/overlays/baseminerals/potash"));
        ores.add(new UBOreConfig("baseminerals:salt_ore", "undergroundbiomes:blocks/overlays/baseminerals/salt"));
        ores.add(new UBOreConfig("baseminerals:saltpeter_ore", "undergroundbiomes:blocks/overlays/baseminerals/saltpeter"));
        ores.add(new UBOreConfig("baseminerals:sulfur_ore", "undergroundbiomes:blocks/overlays/baseminerals/sulfur"));
        return ores;
    }

    private ArrayList<UBOreConfig> getMysticalAgricultureOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("mysticalagriculture:inferium_ore", "mysticalagriculture:blocks/inferium_ore"));
        ores.add(new UBOreConfig("mysticalagriculture:prosperity_ore", "mysticalagriculture:blocks/prosperity_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getBetterUndergroundOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("betterunderground:blockfossils", "undergroundbiomes:blocks/overlays/custom/fossil"));
        return ores;
    }

    private ArrayList<UBOreConfig> getBiomesOPlentyOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "biomesoplenty:gem_ore";
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/custom/ruby"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/custom/peridot"));
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/custom/topaz"));
        ores.add(new UBOreConfig(oreName, 4, "undergroundbiomes:blocks/overlays/custom/tanzanite"));
        ores.add(new UBOreConfig(oreName, 5, "undergroundbiomes:blocks/overlays/custom/malachite"));
        ores.add(new UBOreConfig(oreName, 6, "undergroundbiomes:blocks/overlays/custom/sapphire"));
        ores.add(new UBOreConfig(oreName, 7, "undergroundbiomes:blocks/overlays/custom/amber"));
        return ores;
    }

    private ArrayList<UBOreConfig> getDraconicEvolutionOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("draconicevolution:draconium_ore", 0, "undergroundbiomes:blocks/overlays/draconicevolution/draconium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getEnderOreOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("enderore:ore_ender", "undergroundbiomes:blocks/overlays/enderore/ender"));
        return ores;
    }

    private ArrayList<UBOreConfig> getDenseMetalsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("densemetals:dense_antimony_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_antimony_ore"));
        ores.add(new UBOreConfig("densemetals:dense_bismuth_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_bismuth_ore"));
        ores.add(new UBOreConfig("densemetals:dense_coal_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_coal_ore"));
        ores.add(new UBOreConfig("densemetals:dense_copper_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_copper_ore"));
        ores.add(new UBOreConfig("densemetals:dense_diamond_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_diamond_ore"));
        ores.add(new UBOreConfig("densemetals:dense_emerald_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_emerald_ore"));
        ores.add(new UBOreConfig("densemetals:dense_gold_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_gold_ore"));
        ores.add(new UBOreConfig("densemetals:dense_iron_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_iron_ore"));
        ores.add(new UBOreConfig("densemetals:dense_lapis_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_lapis_ore"));
        ores.add(new UBOreConfig("densemetals:dense_lead_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_lead_ore"));
        ores.add(new UBOreConfig("densemetals:dense_mercury_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_mercury_ore"));
        ores.add(new UBOreConfig("densemetals:dense_nickel_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_nickel_ore"));
        ores.add(new UBOreConfig("densemetals:dense_platinum_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_platinum_ore"));
        ores.add(new UBOreConfig("densemetals:dense_redstone_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_redstone_ore"));
        ores.add(new UBOreConfig("densemetals:dense_silver_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_silver_ore"));
        ores.add(new UBOreConfig("densemetals:dense_tin_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_tin_ore"));
        ores.add(new UBOreConfig("densemetals:dense_zinc_ore", "undergroundbiomes:blocks/overlays/densemetals/dense_zinc_ore"));
        return ores;
    }

    private ArrayList<UBOreConfig> getExtremeReactorsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("bigreactors:brore", 0, "undergroundbiomes:blocks/overlays/bigreactors/yellorite"));
        return ores;
    }

    private ArrayList<UBOreConfig> getForestyOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "forestry:resources";
        ores.add(new UBOreConfig(oreName, 0, "undergroundbiomes:blocks/overlays/custom/apatite"));
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/thermalfoundation/copper"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/thermalfoundation/tin"));
        return ores;
    }

    private ArrayList<UBOreConfig> getIndustrialCraftOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "ic2:resource";
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/thermalfoundation/copper"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/thermalfoundation/lead"));
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/thermalfoundation/tin"));
        ores.add(new UBOreConfig(oreName, 4, "undergroundbiomes:blocks/overlays/custom/uranium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getImmersiveEngineeringOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "immersiveengineering:ore";
        ores.add(new UBOreConfig(oreName, 0, "undergroundbiomes:blocks/overlays/thermalfoundation/copper"));
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/thermalfoundation/aluminum"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/thermalfoundation/lead"));
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/thermalfoundation/silver"));
        ores.add(new UBOreConfig(oreName, 4, "undergroundbiomes:blocks/overlays/thermalfoundation/nickel"));
        ores.add(new UBOreConfig(oreName, 5, "undergroundbiomes:blocks/overlays/custom/uranium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getMekanismOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "mekanism:oreblock";
        ores.add(new UBOreConfig(oreName, 0, "undergroundbiomes:blocks/overlays/mekanism/osmium"));
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/mekanism/copper"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/mekanism/tin"));
        return ores;
    }

    private ArrayList<UBOreConfig> getModernMetalsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("modernmetals:aluminum_ore", "undergroundbiomes:blocks/overlays/modernmetals/aluminum"));
        ores.add(new UBOreConfig("modernmetals:beryllium_ore", "undergroundbiomes:blocks/overlays/modernmetals/beryllium"));
        ores.add(new UBOreConfig("modernmetals:boron_ore", "undergroundbiomes:blocks/overlays/modernmetals/boron"));
        ores.add(new UBOreConfig("modernmetals:cadmium_ore", "undergroundbiomes:blocks/overlays/modernmetals/cadmium"));
        ores.add(new UBOreConfig("modernmetals:chromium_ore", "undergroundbiomes:blocks/overlays/modernmetals/chromium"));
        ores.add(new UBOreConfig("modernmetals:iridium_ore", "undergroundbiomes:blocks/overlays/modernmetals/iridium"));
        ores.add(new UBOreConfig("modernmetals:magnesium_ore", "undergroundbiomes:blocks/overlays/modernmetals/magnesium"));
        ores.add(new UBOreConfig("modernmetals:manganese_ore", "undergroundbiomes:blocks/overlays/modernmetals/manganese"));
        ores.add(new UBOreConfig("modernmetals:osmium_ore", "undergroundbiomes:blocks/overlays/modernmetals/osmium"));
        ores.add(new UBOreConfig("modernmetals:plutonium_ore", "undergroundbiomes:blocks/overlays/modernmetals/plutonium"));
        ores.add(new UBOreConfig("modernmetals:rutile_ore", "undergroundbiomes:blocks/overlays/modernmetals/rutile"));
        ores.add(new UBOreConfig("modernmetals:tantalum_ore", "undergroundbiomes:blocks/overlays/modernmetals/tantalum"));
        ores.add(new UBOreConfig("modernmetals:titanium_ore", "undergroundbiomes:blocks/overlays/modernmetals/titanium"));
        ores.add(new UBOreConfig("modernmetals:tungsten_ore", "undergroundbiomes:blocks/overlays/modernmetals/tungsten"));
        ores.add(new UBOreConfig("modernmetals:uranium_ore", "undergroundbiomes:blocks/overlays/modernmetals/uranium"));
        ores.add(new UBOreConfig("modernmetals:zirconium_ore", "undergroundbiomes:blocks/overlays/modernmetals/zirconium"));
        return ores;
    }

    private ArrayList<UBOreConfig> getRFToolsOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("rftools:dimensional_shard_ore", 0, "undergroundbiomes:blocks/overlays/rftools/dimensionalshard"));
        return ores;
    }

    private ArrayList<UBOreConfig> getTechRebornOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "techreborn:ore";
        ores.add(new UBOreConfig(oreName, 0, "undergroundbiomes:blocks/overlays/techreborn/galena"));
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/techreborn/iridium"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/techreborn/ruby"));
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/techreborn/sapphire"));
        ores.add(new UBOreConfig(oreName, 4, "undergroundbiomes:blocks/overlays/techreborn/bauxite"));
        ores.add(new UBOreConfig(oreName, 12, "undergroundbiomes:blocks/overlays/techreborn/lead"));
        ores.add(new UBOreConfig(oreName, 13, "undergroundbiomes:blocks/overlays/techreborn/silver"));
        return ores;
    }

    private ArrayList<UBOreConfig> getThaumcraftOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        ores.add(new UBOreConfig("thaumcraft:ore_cinnabar", "undergroundbiomes:blocks/overlays/thaumcraft/ore_cinnabar"));
        ores.add(new UBOreConfig("thaumcraft:ore_amber", "undergroundbiomes:blocks/overlays/thaumcraft/ore_amber"));
        ores.add(new UBOreConfig("thaumcraft:ore_quartz", "undergroundbiomes:blocks/overlays/thaumcraft/ore_quartz"));
        return ores;
    }

    private ArrayList<UBOreConfig> getThermalFoundationOres() {
        ArrayList<UBOreConfig> ores = new ArrayList<UBOreConfig>();
        String oreName = "thermalfoundation:ore";
        ores.add(new UBOreConfig(oreName, 0, "undergroundbiomes:blocks/overlays/thermalfoundation/copper"));
        ores.add(new UBOreConfig(oreName, 1, "undergroundbiomes:blocks/overlays/thermalfoundation/tin"));
        ores.add(new UBOreConfig(oreName, 4, "undergroundbiomes:blocks/overlays/thermalfoundation/aluminum"));
        ores.add(new UBOreConfig(oreName, 3, "undergroundbiomes:blocks/overlays/thermalfoundation/lead"));
        ores.add(new UBOreConfig(oreName, 2, "undergroundbiomes:blocks/overlays/thermalfoundation/silver"));
        ores.add(new UBOreConfig(oreName, 5, "undergroundbiomes:blocks/overlays/thermalfoundation/nickel"));
        ores.add(new UBOreConfig(oreName, 6, "undergroundbiomes:blocks/overlays/thermalfoundation/platinum"));
        ores.add(new UBOreConfig(oreName, 7, "undergroundbiomes:blocks/overlays/thermalfoundation/iridium"));
        ores.add(new UBOreConfig(oreName, 8, "undergroundbiomes:blocks/overlays/thermalfoundation/mana_infused"));
        ores.add(new UBOreConfig("thermalfoundation:ore_fluid", 2, "undergroundbiomes:blocks/overlays/thermalfoundation/destabilized_redstone"));
        return ores;
    }
}

