/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import exterminatorjeff.undergroundbiomes.api.API;
import exterminatorjeff.undergroundbiomes.api.common.IUBOreConfig;
import exterminatorjeff.undergroundbiomes.client.UBCreativeTab;
import exterminatorjeff.undergroundbiomes.common.UBSubBlock;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import tyra314.toolprogression.api.OverwrittenContent;
import tyra314.toolprogression.harvest.BlockOverwrite;

public abstract class UBOre
extends Block
implements UBSubBlock {
    public static final int NO_METADATA = -1;
    public final Block baseOre;
    public final int baseOreMeta;
    public final IBlockState baseOreState;
    protected final ItemBlock itemBlock;
    public final IUBOreConfig config;

    public UBOre(Block baseOre, IUBOreConfig config) {
        super(baseOre.func_149688_o(baseOre.func_176223_P()));
        if (Loader.isModLoaded((String)"toolprogression")) {
            if (OverwrittenContent.blocks.containsKey(this.func_149739_a())) {
                String toolClass = ((BlockOverwrite)OverwrittenContent.blocks.get((Object)this.func_149739_a())).toolclass;
                int harvestLevel = ((BlockOverwrite)OverwrittenContent.blocks.get((Object)this.func_149739_a())).level;
                this.setHarvestLevel(toolClass, harvestLevel);
            }
        } else {
            this.setHarvestLevel(baseOre.getHarvestTool(baseOre.func_176223_P()), baseOre.getHarvestLevel(baseOre.func_176223_P()));
        }
        this.func_149647_a(UBCreativeTab.UB_ORES_TAB);
        this.itemBlock = new UBItemOre(this);
        this.baseOre = baseOre;
        this.baseOreMeta = config.getMeta();
        this.baseOreState = baseOre.func_176203_a(this.baseOreMeta);
        this.config = config;
    }

    public int getLightValue(IBlockState state, IBlockAccess access, BlockPos pos) {
        if (this.config.getLightValue() > -1) {
            return this.config.getLightValue();
        }
        return this.baseOre.getLightValue(this.baseOreState, access, pos);
    }

    @Override
    public Block toBlock() {
        return this;
    }

    @Override
    public final ItemBlock getItemBlock() {
        return this.itemBlock;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        if (this.config.hasAlphaOverlay()) {
            return BlockRenderLayer.TRANSLUCENT;
        }
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    protected abstract BlockStateContainer func_180661_e();

    public abstract IBlockState func_176203_a(int var1);

    public int func_176201_c(IBlockState state) {
        return this.baseStone().toBlock().func_176201_c(state);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        return this.baseOre.quantityDropped(this.baseOreState, fortune, random);
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < this.getNbVariants(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        Item item = Item.func_150898_a((Block)this.baseOre);
        Item drop = this.baseOre.func_180660_a(this.baseOreState, rand, fortune);
        if (drop != item) {
            return drop;
        }
        return drop;
    }

    public void func_176206_d(World world, BlockPos pos, IBlockState state) {
        this.baseOre.func_176206_d(world, pos, this.baseOreState);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.baseOre.func_176208_a(world, pos, this.baseOreState, player);
    }

    @Nullable
    public String getHarvestTool(IBlockState state) {
        if (Loader.isModLoaded((String)"toolprogression")) {
            if (OverwrittenContent.blocks.containsKey(this.func_149739_a()) && API.SETTINGS.customOreBlockHardnes().contains(this.func_149739_a())) {
                return ((BlockOverwrite)OverwrittenContent.blocks.get((Object)this.func_149739_a())).toolclass;
            }
            return this.baseOre.getHarvestTool(this.baseOreState);
        }
        return this.baseOre.getHarvestTool(this.baseOreState);
    }

    public int getHarvestLevel(IBlockState state) {
        if (Loader.isModLoaded((String)"toolprogression")) {
            if (OverwrittenContent.blocks.containsKey(this.func_149739_a()) && API.SETTINGS.customOreBlockHardnes().contains(this.func_149739_a())) {
                return ((BlockOverwrite)OverwrittenContent.blocks.get((Object)this.func_149739_a())).level;
            }
            return this.baseOre.getHarvestLevel(this.baseOreState);
        }
        return this.baseOre.getHarvestLevel(this.baseOreState);
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        return this.baseOre.removedByPlayer(this.baseOreState, world, pos, player, willHarvest);
    }

    public boolean func_149744_f(IBlockState state) {
        return this.baseOre.func_149744_f(this.baseOreState);
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.baseOre.func_180656_a(this.baseOreState, world, pos, side);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        this.baseOre.func_180655_c(this.baseOreState, world, pos, rand);
    }

    public int func_180651_a(IBlockState state) {
        int test = this.baseOre.func_180651_a(this.baseOreState);
        if (test > 0) {
            return test;
        }
        if (this.baseOreMeta == -1) {
            return 0;
        }
        return this.baseOreMeta;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        return this.baseOre.getDrops(world, pos, this.baseOreState, fortune);
    }

    public void func_180637_b(World worldIn, BlockPos pos, int amount) {
        this.baseOre.func_180637_b(worldIn, pos, amount);
    }

    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return this.baseOre.func_176195_g(this.baseOreState, worldIn, pos);
    }

    public int getExpDrop(IBlockState state, IBlockAccess world, BlockPos pos, int fortune) {
        return this.baseOre.getExpDrop(this.baseOreState, world, pos, fortune);
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return player.func_184614_ca().func_150998_b(this.baseOreState);
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        this.baseOre.func_180650_b(worldIn, pos, this.baseOreState, rand);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack((Item)this.itemBlock, 1, this.func_176201_c(world.func_180495_p(pos)));
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> infos, ITooltipFlag tooltipFlag) {
        if (API.SETTINGS.displayTooltipModName()) {
            Map indexedModList = Loader.instance().getIndexedModList();
            String modName = ((ModContainer)indexedModList.get(this.baseOre.getRegistryName().func_110624_b())).getName();
            infos.add(API.SETTINGS.getTooltipModNamePreTextFormatting() + API.SETTINGS.getTooltipModNamePreText() + "\u00a7r " + API.SETTINGS.getTooltipModNameFormatting() + modName + "\u00a7r " + API.SETTINGS.getTooltipModNamePostTextFormatting() + API.SETTINGS.getTooltipModNamePostText());
        }
        super.func_190948_a(stack, world, infos, tooltipFlag);
    }

    private class UBItemOre
    extends ItemBlock {
        public UBItemOre(UBOre ubOre) {
            super((Block)ubOre);
            this.func_77656_e(0);
            this.func_77627_a(true);
        }

        public int func_77647_b(int damage) {
            return damage;
        }

        public int getDamage(ItemStack stack) {
            return stack.func_77960_j();
        }

        @SideOnly(value=Side.CLIENT)
        public String func_77653_i(ItemStack stack) {
            try {
                if (UBOre.this.baseOreMeta == -1) {
                    return I18n.func_135052_a((String)(UBOre.this.baseStone().getItemBlock().func_77657_g(stack) + ".name"), (Object[])new Object[0]) + " " + I18n.func_135052_a((String)(UBOre.this.baseOre.func_149739_a() + ".name"), (Object[])new Object[0]);
                }
                ItemStack baseStack = new ItemStack(UBOre.this.baseOre, 1, UBOre.this.baseOreMeta);
                return I18n.func_135052_a((String)(UBOre.this.baseStone().getItemBlock().func_77657_g(stack) + ".name"), (Object[])new Object[0]) + " " + baseStack.func_82833_r();
            }
            catch (Error error) {
                if (UBOre.this.baseOreMeta == -1) {
                    return UBOre.this.baseStone().getItemBlock().func_77657_g(stack) + ".name " + UBOre.this.baseOre.func_149739_a() + ".name";
                }
                ItemStack baseStack = new ItemStack(UBOre.this.baseOre, 1, UBOre.this.baseOreMeta);
                return UBOre.this.baseStone().getItemBlock().func_77657_g(stack) + ".name " + baseStack.func_82833_r();
            }
        }
    }
}

