/*
 * Decompiled with CFR 0.152.
 */
package exterminatorjeff.undergroundbiomes.common.block;

import com.google.common.base.Predicate;
import exterminatorjeff.undergroundbiomes.api.enums.UBStoneStyle;
import exterminatorjeff.undergroundbiomes.common.block.SedimentaryStone;
import exterminatorjeff.undergroundbiomes.intermod.DropsRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;

public class SedimentarySand
extends SedimentaryStone {
    public static final String internal_name = "sedimentary_sand";
    public static boolean fallInstantly;

    public SedimentarySand() {
        this.func_149672_a(SoundType.field_185855_h);
    }

    @Override
    public String getInternalName() {
        return internal_name;
    }

    @Override
    public UBStoneStyle getStoneStyle() {
        return UBStoneStyle.SAND;
    }

    public Material func_149688_o(IBlockState state) {
        return Material.field_151595_p;
    }

    @Override
    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public void func_176213_c(World worldIn, BlockPos pos, IBlockState state) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos p_189540_5_) {
        worldIn.func_175684_a(pos, (Block)this, this.func_149738_a(worldIn));
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (!worldIn.field_72995_K) {
            this.checkFallable(worldIn, pos);
        }
    }

    private void checkFallable(World worldIn, BlockPos pos) {
        if (SedimentarySand.canFallThrough(worldIn.func_180495_p(pos.func_177977_b())) && pos.func_177956_o() >= 0) {
            int i = 32;
            if (!fallInstantly && worldIn.func_175707_a(pos.func_177982_a(-32, -32, -32), pos.func_177982_a(32, 32, 32))) {
                if (!worldIn.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, worldIn.func_180495_p(pos));
                    this.onStartFalling(entityfallingblock);
                    worldIn.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                worldIn.func_175698_g(pos);
                BlockPos blockpos = pos.func_177977_b();
                while (SedimentarySand.canFallThrough(worldIn.func_180495_p(blockpos)) && blockpos.func_177956_o() > 0) {
                    blockpos = blockpos.func_177977_b();
                }
                if (blockpos.func_177956_o() > 0) {
                    worldIn.func_175656_a(blockpos.func_177984_a(), this.func_176223_P());
                }
            }
        }
    }

    protected void onStartFalling(EntityFallingBlock fallingEntity) {
    }

    public int func_149738_a(World worldIn) {
        return 2;
    }

    public static boolean canFallThrough(IBlockState state) {
        Block block = state.func_177230_c();
        Material material = state.func_185904_a();
        return block == Blocks.field_150480_ab || material == Material.field_151579_a || material == Material.field_151586_h || material == Material.field_151587_i;
    }

    public void onEndFalling(World worldIn, BlockPos pos, IBlockState p_176502_3_, IBlockState p_176502_4_) {
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        BlockPos blockpos;
        if (rand.nextInt(16) == 0 && SedimentarySand.canFallThrough(worldIn.func_180495_p(blockpos = pos.func_177977_b()))) {
            double d0 = (float)pos.func_177958_n() + rand.nextFloat();
            double d1 = (double)pos.func_177956_o() - 0.05;
            double d2 = (float)pos.func_177952_p() + rand.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.FALLING_DUST, d0, d1, d2, 0.0, 0.0, 0.0, new int[]{Block.func_176210_f((IBlockState)stateIn)});
        }
    }

    public int getDustColor(IBlockState p_189876_1_) {
        return -16777216;
    }

    @Override
    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        if (fortune > 3) {
            fortune = 3;
        }
        return rand.nextInt(10 - fortune * 3) == 0 ? Items.field_151145_ak : this.itemBlock;
    }

    @Override
    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Item gravelBlock = this.func_180660_a(state, new Random(), fortune);
        ItemStack itemStack = null;
        if (gravelBlock == this.itemBlock) {
            int meta = state.func_177230_c().func_176201_c(state);
            itemStack = new ItemStack(gravelBlock, 1, meta);
        } else {
            itemStack = new ItemStack(gravelBlock, 1);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(itemStack);
        DropsRegistry.INSTANCE.addDrops(result, this, world, pos, state, fortune);
        return result;
    }

    @Override
    public void getDrops(NonNullList<ItemStack> stacks, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Item gravelBlock = this.func_180660_a(state, new Random(), fortune);
        ItemStack itemStack = null;
        if (gravelBlock == this.itemBlock) {
            int meta = state.func_177230_c().func_176201_c(state);
            itemStack = new ItemStack(gravelBlock, 1, meta);
        } else {
            itemStack = new ItemStack(gravelBlock, 1);
        }
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        result.add(itemStack);
        DropsRegistry.INSTANCE.addDrops(result, this, world, pos, state, fortune);
    }

    public String getHarvestTool(IBlockState state) {
        return "shovel";
    }

    @Override
    public float func_176195_g(IBlockState state, World worldIn, BlockPos pos) {
        return Blocks.field_150351_n.func_176195_g(state, worldIn, pos);
    }

    public boolean canSustainPlant(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing direction, IPlantable plantable) {
        EnumPlantType plantType = plantable.getPlantType(world, pos.func_177972_a(direction));
        return plantType == EnumPlantType.Desert || plantType == EnumPlantType.Beach || plantType == EnumPlantType.Water;
    }
}

