/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.triggers;

import binnie.core.AbstractMod;
import binnie.core.BinnieCore;
import binnie.core.triggers.TriggerProvider;
import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.IStatementContainer;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.api.statements.ITriggerExternal;
import buildcraft.api.statements.StatementManager;
import forestry.core.triggers.Sprite;
import javax.annotation.Nullable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

final class BinnieTrigger
implements ITriggerExternal {
    private static int incrementalID = 800;
    protected static BinnieTrigger triggerNoBlankTemplate;
    protected static BinnieTrigger triggerNoTemplate;
    protected static BinnieTrigger triggerIsWorking;
    protected static BinnieTrigger triggerIsNotWorking;
    protected static BinnieTrigger triggerCanWork;
    protected static BinnieTrigger triggerCannotWork;
    protected static BinnieTrigger triggerPowerNone;
    protected static BinnieTrigger triggerPowerLow;
    protected static BinnieTrigger triggerPowerMedium;
    protected static BinnieTrigger triggerPowerHigh;
    protected static BinnieTrigger triggerPowerFull;
    protected static BinnieTrigger triggerSerumFull;
    protected static BinnieTrigger triggerSerumPure;
    protected static BinnieTrigger triggerSerumEmpty;
    protected static BinnieTrigger triggerAcclimatiserNone;
    protected static BinnieTrigger triggerAcclimatiserHot;
    protected static BinnieTrigger triggerAcclimatiserCold;
    protected static BinnieTrigger triggerAcclimatiserWet;
    protected static BinnieTrigger triggerAcclimatiserDry;
    private final String desc;
    private final String tag;
    private final String modID;
    private final String iconFile;
    @SideOnly(value=Side.CLIENT)
    @Nullable
    private ISprite icon;
    private int id = incrementalID++;

    public BinnieTrigger(String desc, String tag, String iconFile) {
        this(desc, tag, BinnieCore.getInstance(), iconFile);
    }

    public BinnieTrigger(String desc, String tag, AbstractMod mod, String iconFile) {
        this.tag = tag;
        StatementManager.registerStatement((IStatement)this);
        TriggerProvider.triggers.add(this);
        this.modID = mod.getModId();
        this.iconFile = iconFile;
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getUniqueTag() {
        return this.tag;
    }

    @SideOnly(value=Side.CLIENT)
    public ISprite getSprite() {
        if (this.icon == null) {
            this.icon = new Sprite(new ResourceLocation(this.modID, String.format("textures/items/%s.png", this.iconFile)));
        }
        return this.icon;
    }

    public int maxParameters() {
        return 0;
    }

    public int minParameters() {
        return 0;
    }

    public IStatementParameter createParameter(int index) {
        return null;
    }

    public IStatement rotateLeft() {
        return null;
    }

    public boolean isTriggerActive(TileEntity target, EnumFacing side, IStatementContainer source, IStatementParameter[] parameters) {
        return false;
    }

    public IStatement[] getPossible() {
        return new IStatement[0];
    }
}

