/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.village;

import com.google.common.collect.Lists;
import fathertoast.specialai.config.Config;
import fathertoast.specialai.village.ReputationHandler;
import fathertoast.specialai.village.VillageSafe;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraft.village.VillageCollection;
import net.minecraft.village.VillageDoorInfo;
import net.minecraft.world.World;

public class VillageCollectionSafe
extends VillageCollection {
    public World theWorld;
    boolean firstTick = true;
    protected int field_75553_e;
    private final List<VillageSafe> loadedVillageList = Lists.newArrayList();
    private final HashMap<Village, Integer> doorCountCache = new HashMap();

    public VillageCollectionSafe(String dataIdentifier) {
        super(dataIdentifier);
    }

    public VillageCollectionSafe(World world) {
        super(world);
        this.theWorld = world;
    }

    public VillageCollectionSafe(World world, VillageCollection parent) {
        super(world);
        this.theWorld = world;
        this.func_76184_a(parent.func_189551_b(new NBTTagCompound()));
    }

    public void func_75544_a() {
        ++this.field_75553_e;
        if (this.firstTick || this.field_75553_e % 40 == 0) {
            ListIterator<Village> itr = this.func_75540_b().listIterator();
            while (itr.hasNext()) {
                Village villageTesterVar = (Village)itr.next();
                if (!VillageSafe.class.equals(villageTesterVar.getClass())) {
                    villageTesterVar = this.convertVillage(villageTesterVar);
                    itr.set(villageTesterVar);
                }
                VillageSafe village = (VillageSafe)villageTesterVar;
                boolean loadedLast = this.isLoaded(village);
                boolean loaded = this.isVillageLoadedInWorld(village);
                if (loaded == loadedLast) continue;
                if (loaded) {
                    this.loadVillage(village);
                    continue;
                }
                this.unloadVillage(village);
            }
        }
        for (VillageSafe village : this.loadedVillageList) {
            village.tickLoaded(this.field_75553_e);
        }
        super.func_75544_a();
        if (Config.get().VILLAGES.HOUSE_REP && this.field_75553_e % 50 == 0) {
            for (VillageSafe village : this.func_75540_b()) {
                if (!this.doorCountCache.containsKey((Object)village)) {
                    this.doorCountCache.put(village, village.func_75567_c());
                    continue;
                }
                int difference = village.func_75567_c() - this.doorCountCache.get((Object)village);
                if (difference == 0) continue;
                this.doorCountCache.put(village, village.func_75567_c());
                ReputationHandler.addReputationToAll(this.theWorld, 32.0, village, difference);
            }
        }
        if (Config.get().VILLAGES.REFRESH_HOUSES && this.field_75553_e % 810 == 0) {
            for (VillageSafe village : this.loadedVillageList) {
                this.refreshAllDoors(village);
            }
        }
        if (this.field_75553_e % 3030 == 0) {
            this.doorCountCache.keySet().retainAll(this.func_75540_b());
        }
        this.firstTick = false;
    }

    public VillageSafe convertVillage(Village village) {
        VillageSafe newVillage = new VillageSafe(this.theWorld);
        NBTTagCompound tag = new NBTTagCompound();
        village.func_82689_b(tag);
        newVillage.func_82690_a(tag);
        return newVillage;
    }

    public boolean isVillageLoadedInWorld(Village village) {
        int chunkR = 2;
        BlockPos center = village.func_180608_a();
        for (int x = -chunkR; x <= chunkR; ++x) {
            for (int z = -chunkR; z <= chunkR; ++z) {
                if (Math.abs(x) + Math.abs(z) > chunkR || this.theWorld.func_175667_e(center.func_177982_a(x << 4, 0, z << 4))) continue;
                return false;
            }
        }
        return true;
    }

    public boolean isLoaded(VillageSafe village) {
        return this.loadedVillageList.contains((Object)village);
    }

    public void loadVillage(VillageSafe village) {
        this.loadedVillageList.add(village);
        this.refreshAllDoors(village);
    }

    public void unloadVillage(VillageSafe village) {
        this.loadedVillageList.remove((Object)village);
    }

    public void refreshAllDoors(VillageSafe village) {
        for (VillageDoorInfo doorInfo : village.func_75558_f()) {
            doorInfo.func_179849_a(this.field_75553_e);
        }
    }

    public void func_76184_a(NBTTagCompound tag) {
        NBTTagList villageList = tag.func_150295_c("Villages", 10);
        tag.func_82580_o("Villages");
        super.func_76184_a(tag);
        tag.func_74782_a("Villages", (NBTBase)villageList);
        this.field_75553_e = tag.func_74762_e("Tick");
        for (int i = 0; i < villageList.func_74745_c(); ++i) {
            NBTTagCompound villageTag = villageList.func_150305_b(i);
            VillageSafe village = new VillageSafe(this.theWorld);
            village.func_82690_a(villageTag);
            this.func_75540_b().add(village);
        }
    }

    public void func_82566_a(World world) {
        this.theWorld = world;
        super.func_82566_a(world);
    }
}

