/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.specialai.village;

import fathertoast.specialai.SpecialAIMod;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageReputationFX
implements IMessage {
    private Type effectType = Type.NONE;
    private BlockPos effectPos = BlockPos.field_177992_a;

    public MessageReputationFX() {
    }

    private MessageReputationFX(Type type, BlockPos pos) {
        this.effectType = type;
        this.effectPos = pos;
    }

    public void fromBytes(ByteBuf buf) {
        int ordinal = buf.readByte() & 0xFF;
        this.effectType = ordinal >= 0 && ordinal < Type.values().length ? Type.values()[ordinal] : Type.NONE;
        this.effectPos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(this.effectType.ordinal());
        buf.writeInt(this.effectPos.func_177958_n());
        buf.writeInt(this.effectPos.func_177956_o());
        buf.writeInt(this.effectPos.func_177952_p());
    }

    public static class Handler
    implements IMessageHandler<MessageReputationFX, IMessage> {
        public IMessage onMessage(MessageReputationFX message, MessageContext ctx) {
            switch (message.effectType) {
                case HAPPY: {
                    this.spawnParticles((World)Minecraft.func_71410_x().field_71441_e, message.effectPos, EnumParticleTypes.VILLAGER_HAPPY, 10);
                    break;
                }
                case ANGRY: {
                    this.spawnParticles((World)Minecraft.func_71410_x().field_71441_e, message.effectPos, EnumParticleTypes.VILLAGER_ANGRY, 5);
                }
            }
            return null;
        }

        private void spawnParticles(World world, BlockPos pos, EnumParticleTypes particle, int count) {
            for (int i = 0; i < count; ++i) {
                world.func_175688_a(particle, (double)((float)pos.func_177958_n() + 0.5f + (world.field_73012_v.nextFloat() - 0.5f) * 1.5f), (double)((float)pos.func_177956_o() + 0.5f + (world.field_73012_v.nextFloat() - 0.5f) * 1.5f), (double)((float)pos.func_177952_p() + 0.5f + (world.field_73012_v.nextFloat() - 0.5f) * 1.5f), world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02, world.field_73012_v.nextGaussian() * 0.02, new int[0]);
            }
        }
    }

    public static enum Type {
        NONE,
        HAPPY,
        ANGRY;


        public void send(World world, BlockPos pos) {
            if (!world.field_72995_K) {
                SpecialAIMod.network().sendToAllAround((IMessage)new MessageReputationFX(this, pos), new NetworkRegistry.TargetPoint(world.field_73011_w.getDimension(), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 24.0));
            }
        }
    }
}

